/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.table;

import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import tangram.swing.table.component.TngTableHeader;
import tangram.swing.table.model.TngTableModel;

public class TngTableHeaderListener
extends MouseAdapter {
    private TngTableHeader tableHeader;

    public TngTableHeaderListener(TngTableHeader tableHeader) {
        this.tableHeader = tableHeader;
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        int vColIndex = this.tableHeader.getColumnModel().getColumnIndexAtX(evt.getX());
        int mColIndex = this.tableHeader.getTable().convertColumnIndexToModel(vColIndex);
        if (vColIndex == -1) {
            return;
        }
        Rectangle headerRect = this.tableHeader.getHeaderRect(vColIndex);
        if (vColIndex == 0) {
            headerRect.width -= 3;
        } else {
            headerRect.grow(-3, 0);
        }
        if (!headerRect.contains(evt.getX(), evt.getY())) {
            return;
        }
        this.columnClicked(evt, mColIndex);
    }

    public void columnClicked(MouseEvent evt, int columnIndex) {
        JTable table = this.tableHeader.getTable();
        TableModel model = table.getModel();
        if (model instanceof TngTableModel) {
            TngTableModel tm = (TngTableModel)model;
            tm.columnClicked(evt, table, columnIndex);
        }
    }
}

