/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.table.component;

import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableColumnModel;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.swing.TngSwing;
import tangram.swing.TngWaiter;
import tangram.swing.table.component.TngTableColumn;
import tangram.swing.table.component.TngTableHeader;
import tangram.swing.table.component.TngTableKeyAdapter;
import tangram.swing.table.component.TngTableMouseAdapter;
import tangram.swing.table.component.TngTableRow;
import tangram.swing.table.component.TngTableRowHeader;
import tangram.swing.table.component.TngTableUtils;
import tangram.swing.table.model.TngTableModel;
import tangram.swing.table.renderer.TngTableRendererCell;

public class TngTable
extends JTable {
    protected boolean rowMarkable = true;
    protected TngTableRowHeader rowHeader = null;

    public TngTable() {
        try {
            this.jbInit();
        }
        catch (Exception e2) {
            TngSwing.exceptionShow(e2);
        }
    }

    private void jbInit() throws Exception {
        TngSwing.setVariantSize(this);
        this.setShowHorizontalLines(true);
        this.setShowVerticalLines(true);
        this.setShowGrid(false);
        this.setAutoResizeMode(0);
        this.setSelectionMode(0);
        this.setDefaultRenderer(TngTableColumn.class, new TngTableRendererCell());
        this.setColumnModel(new DefaultTableColumnModel());
        this.setTableHeader(new TngTableHeader(this.getColumnModel()));
        this.getInputMap(1).getParent().clear();
        this.addKeyListener(new TngTableKeyAdapter(this));
        this.addMouseListener(new TngTableMouseAdapter(this));
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e2) {
                TngTable.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e2) {
                TngTable.this.repaint();
            }
        });
        ToolTipManager.sharedInstance().unregisterComponent(this);
        ToolTipManager.sharedInstance().unregisterComponent(this.getTableHeader());
    }

    public TngTableModel getTableModel() {
        return (TngTableModel)this.getModel();
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.getRowHeader() != null) {
            this.getRowHeader().setRowHeight(rowHeight);
        }
    }

    public boolean isRowMarkable() {
        return this.rowMarkable;
    }

    public void setRowMarkable(boolean markable) {
        this.rowMarkable = markable;
    }

    public void setRowHeader(TngTableRowHeader rowHeader) {
        this.rowHeader = rowHeader;
    }

    public TngTableRowHeader getRowHeader() {
        return this.rowHeader;
    }

    private void repaintRowHeader() {
        if (this.getRowHeader() != null) {
            this.getRowHeader().repaint();
        }
    }

    public String getSelectedColumnValueAsString(int column) {
        return this.getColumnValueAsString(this.getSelectedRow(), column);
    }

    public String getColumnValueAsString(int row, int column) {
        if (row < 0) {
            return null;
        }
        TngTableRow r2 = this.getTableModel().getRow(row);
        if (r2.deleted) {
            return null;
        }
        Object o2 = r2.values[column];
        if (o2 == null) {
            return null;
        }
        return o2.toString();
    }

    protected void showDetails() {
        TngSwing.textShow(Nat.x("Podrobnosti"), this.getTableModel().getInfo());
    }

    protected void markRowSelectAll() {
        if (!this.isRowMarkable()) {
            return;
        }
        int count = this.getRowCount();
        for (int r2 = 0; r2 < count; ++r2) {
            this.getTableModel().setRowMarkSelect(r2);
        }
    }

    protected void unmarkRowSelectAll() {
        if (!this.isRowMarkable()) {
            return;
        }
        int count = this.getRowCount();
        for (int r2 = 0; r2 < count; ++r2) {
            this.getTableModel().clearRowMarkSelect(r2, 0);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e2) {
        super.tableChanged(e2);
        if (e2 == null) {
            return;
        }
        int type = e2.getType();
        int firstRow = e2.getFirstRow();
        if (type == 1) {
            this.toRow(e2.getFirstRow());
        } else if (type == 0 && firstRow != -1) {
            this.repaintRowHeader();
        }
    }

    public void markRowSelect() {
        if (this.isRowMarkable()) {
            int r2 = this.getSelectedRow();
            if (r2 == -1) {
                return;
            }
            this.getTableModel().changeRowMarkSelect(r2);
            this.setRowSelectionInterval(r2, r2);
        }
    }

    public void markRowDelete() {
        int r2 = this.getSelectedRow();
        if (r2 == -1) {
            return;
        }
        this.getTableModel().changeRowMarkDelete(r2);
        this.setRowSelectionInterval(r2, r2);
    }

    public void deleteMarkedRows() {
        if (this.getTableModel().getCountMarkDelete() == 0) {
            int r2 = this.getSelectedRow();
            if (r2 == -1) {
                return;
            }
            try {
                if (TngSwing.msgAsk(Nat.x("Naozaj si \u017eel\u00e1te zmaza\u0165 aktu\u00e1lny riadok?"))) {
                    this.getTableModel().eraseRow(r2);
                }
            }
            catch (Exception er) {
                TngSwing.exceptionShow(Nat.x("Zmazanie z\u00e1znamu"), er);
            }
        } else {
            try {
                int c2 = this.getTableModel().getCountMarkDelete();
                if (TngSwing.msgAsk(Nat.x("Naozaj si \u017eel\u00e1te zmaza\u0165 ozna\u010den\u00e9 riadky?")) && TngSwing.msgAsk(Nat.x("Po\u010det riadkov ozna\u010den\u00fdch na zmazanie: %1", c2) + "\n\n" + Nat.x("Naozaj si \u017eel\u00e1te zmaza\u0165 ozna\u010den\u00e9 riadky?"))) {
                    this.getTableModel().eraseMarkedRows();
                }
            }
            catch (Exception er) {
                TngSwing.exceptionShow(Nat.x("Zmazanie z\u00e1znamu"), er);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAndReset() {
        try {
            TngWaiter.start(this);
            this.getTableModel().refreshSafe();
            this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
            this.toFirstRow();
            this.tableAutoresizeVisible(true);
            this.requestFocusInWindow();
        }
        finally {
            TngWaiter.stop(this);
        }
    }

    public void refreshRowAsyncData(int row) {
        this.getTableModel().refreshRowAsyncData(row);
    }

    public boolean findSingle(int column, String value) {
        int findRow = this.find(column, value);
        if (findRow >= 0) {
            this.setRowSelectionInterval(findRow, findRow);
            this.changeSelection(findRow, column, false, true);
            this.scrollToRowAndColumn(findRow, 0);
            return true;
        }
        return false;
    }

    public int find(int column, String value) {
        if (value == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
            Object val = ((TngTableColumn)this.getTableModel().getValueAt((int)i2, (int)column)).renderValue;
            if (val == null || !val.toString().equals(value)) continue;
            return i2;
        }
        return -1;
    }

    public boolean findMulti(int column, String multiValue) {
        String[] values;
        boolean found = false;
        for (String value : values = TngUtilities.strTokenizeNotNull(multiValue, ',')) {
            int findRow = this.find(column, value);
            if (findRow < 0) continue;
            this.getTableModel().changeRowMarkSelect(findRow);
            this.setRowSelectionInterval(findRow, findRow);
            this.changeSelection(findRow, column, false, true);
            this.scrollToRowAndColumn(findRow, 0);
            found = true;
        }
        return found;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        TngTableModel tm = this.getTableModel();
        tm.close();
    }

    public void tableAutoresizeAll(boolean canShrink) {
        TngTableUtils.tableAutoresizeAll(this, canShrink);
    }

    public void tableAutoresizeVisible(boolean canShrink) {
        TngTableUtils.tableAutoresizeVisible(this, canShrink);
    }

    public void tableAutoresizeVisibleLater(boolean canShrink) {
        TngTableUtils.tableAutoresizeVisibleLater(this, canShrink);
    }

    public void tableAutoresize(boolean canShrink, boolean withHeader, int firstRow, int lastRow) {
        TngTableUtils.tableAutoresize(this, canShrink, withHeader, firstRow, lastRow);
    }

    public int getVisibleFirstRows() {
        return TngTableUtils.getVisibleFirstRows(this);
    }

    public int getVisibleLastRows() {
        return TngTableUtils.getVisibleLastRows(this);
    }

    public int getVisibleRows() {
        return TngTableUtils.getVisibleRows(this);
    }

    public void toFirstRow() {
        TngTableUtils.toFirstRow(this);
    }

    public void toLastRow() {
        TngTableUtils.toLastRow(this);
    }

    public void toRow(int row) {
        TngTableUtils.toRow(this, row);
    }

    public void toPrevRow() {
        TngTableUtils.toPrevRow(this);
    }

    public void toNextRow() {
        TngTableUtils.toNextRow(this);
    }

    public void scrollRight() {
        TngTableUtils.scrollRight(this);
    }

    public void scrollLeft() {
        TngTableUtils.scrollLeft(this);
    }

    public void toPrevPage() {
        TngTableUtils.toPrevPage(this);
    }

    public void toNextPage() {
        TngTableUtils.toNextPage(this);
    }

    public boolean scrollPrevPage() {
        return TngTableUtils.scrollPrevPage(this);
    }

    public boolean scrollNextPage() {
        return TngTableUtils.scrollNextPage(this);
    }

    public void scrollToRow(int row) {
        TngTableUtils.scrollToRow(this, row);
    }

    public void scrollToRowAndColumn(int row, int column) {
        TngTableUtils.scrollToRowAndColumn(this, row, column);
    }
}

