/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.table.component;

import java.awt.Color;
import java.awt.Font;
import javax.swing.ImageIcon;
import tangram.swing.table.component.TngTableColumnType;
import tangram.swing.table.visualizer.TngTableVisualizer;

public class TngTableColumn {
    public String name;
    public String title;
    public boolean canOrdered;
    public TngTableColumnType type;
    public TngTableVisualizer visualizer;
    public int horizontalAlignment;
    public Color foregroundColor;
    public Font font;
    public Object renderValue;
    public String renderString;
    public ImageIcon renderIcon;
    public boolean hiddenSys;
    public boolean hiddenUser;

    public TngTableColumn() {
        this(null, null, null, null);
    }

    public TngTableColumn(String name) {
        this(null, name, null, null);
    }

    public TngTableColumn(String title, String name) {
        this(title, name, null, null);
    }

    public TngTableColumn(String name, TngTableColumnType type) {
        this(null, name, type, null);
    }

    public TngTableColumn(String name, TngTableVisualizer visualizer) {
        this(null, name, null, visualizer);
    }

    public TngTableColumn(String name, TngTableColumnType type, TngTableVisualizer visualizer) {
        this(null, name, type, visualizer);
    }

    public TngTableColumn(String title, String name, TngTableColumnType type, TngTableVisualizer visualizer) {
        this.name = name;
        this.title = title == null ? name : title;
        this.visualizer = visualizer;
        this.type = type != null ? type : (visualizer == null ? TngTableColumnType.STRING : visualizer.getType());
    }

    public TngTableColumn setHiddenSys() {
        this.hiddenSys = true;
        return this;
    }

    public boolean isVisible() {
        return !this.hiddenSys && !this.hiddenUser;
    }

    public void prepareRender() {
        if (this.visualizer != null) {
            this.renderString = this.visualizer.getString(this.renderValue);
            this.renderIcon = this.visualizer.getIcon(this.renderValue);
            this.horizontalAlignment = this.visualizer.horizontalAlignment;
        } else {
            this.renderString = this.renderValue == null ? "" : this.renderValue.toString();
            this.renderIcon = null;
            this.horizontalAlignment = 2;
        }
    }

    public String toString() {
        return this.name;
    }

    public static int findByName(TngTableColumn[] columns, String name) {
        if (columns == null || name == null) {
            return -1;
        }
        for (int i2 = 0; i2 < columns.length; ++i2) {
            if (!name.equals(columns[i2].name)) continue;
            return i2;
        }
        return -1;
    }
}

