/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.table.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import tangram.library.Nat;
import tangram.library.TngJournalFile;
import tangram.library.TngJournalRow;
import tangram.library.TngUtilities;
import tangram.swing.component.TngCheckBox;
import tangram.swing.component.TngComboBox;
import tangram.swing.panel.TngDlg;
import tangram.swing.table.component.TngTableColumn;
import tangram.swing.table.component.TngTablePanel;
import tangram.swing.table.component.TngTableRow;
import tangram.swing.table.component.TngTableRowHeader;
import tangram.swing.table.component.TngTableToolbar;
import tangram.swing.table.model.TngTableModel;

public class TngTablePanelJournalFile
extends TngTablePanel {
    private static final int IDX_SKUPINA = 0;
    private static final int IDX_TEXT = 1;
    private static final int COLUMNS = 2;
    private static final Color COL_TITLE = new Color(0, 128, 128);
    private static final Color COL_ERROR = new Color(128, 0, 128);
    private JPanel panelLegend = new JPanel();
    private String filterGroup;
    private boolean filterOnlyErrors;
    private List<TngJournalRow> allRows = new ArrayList<TngJournalRow>();
    private List<TngJournalRow> filteredRows = new ArrayList<TngJournalRow>();
    private Set<String> distinctGroups = new HashSet<String>();

    public TngTablePanelJournalFile() {
        this.setSelectableMode(false);
    }

    public void loadAllRows(TngJournalFile journalFile) {
        this.allRows.clear();
        this.distinctGroups.clear();
        for (int i2 = 0; i2 < journalFile.getRows(); ++i2) {
            TngJournalRow row = journalFile.getRow(i2);
            this.allRows.add(row);
            if (TngUtilities.isEmpty(row.getGroup())) continue;
            this.distinctGroups.add(row.getGroup());
        }
    }

    private void filterRows() {
        this.filteredRows.clear();
        for (TngJournalRow row : this.allRows) {
            if (this.filterOnlyErrors && !row.isError() || this.filterGroup != null && !this.filterGroup.equals(row.getGroup())) continue;
            this.filteredRows.add(row);
        }
    }

    @Override
    protected TngTableModel modelInitialize() {
        TngTableModel model = new TngTableModel(){

            @Override
            protected void prepareData() {
                TngTablePanelJournalFile.this.filterRows();
                this.countRows = TngTablePanelJournalFile.this.filteredRows.size();
            }

            @Override
            protected void getRowValues(TngTableRow r2) {
                TngJournalRow row = (TngJournalRow)TngTablePanelJournalFile.this.filteredRows.get(r2.irow);
                r2.values[0] = row.getGroup();
                String text = TngUtilities.strRepeat(' ', row.getLevel() * 3);
                text = text + row.getText();
                r2.values[1] = text;
                if (row.isError()) {
                    r2.foregroundColor = COL_ERROR;
                } else if (row.isTitle()) {
                    r2.foregroundColor = COL_TITLE;
                }
            }
        };
        TngTableColumn[] c2 = new TngTableColumn[]{new TngTableColumn(Nat.x("Skupina"), "skupina"), new TngTableColumn(Nat.x("Text"), "text")};
        model.setColumns(c2);
        return model;
    }

    @Override
    protected TngTableToolbar toolbarInitialize() {
        TngTableToolbar toolbar = new TngTableToolbar(){

            @Override
            public void resolveCloseButton() {
                TngDlg panelDlg = this.getPanelDlgParent();
                if (panelDlg != null) {
                    panelDlg.setCloseButton(TngTablePanelJournalFile.this.jPanelToolbar.getButton(12));
                }
            }
        };
        toolbar.getButton(1).setVisible(false);
        toolbar.getButton(2).setVisible(false);
        toolbar.getButton(3).setVisible(false);
        toolbar.getButton(5).setVisible(false);
        toolbar.getButton(4).setVisible(false);
        toolbar.getButton(11).setVisible(false);
        toolbar.getButton(7).setVisible(false);
        toolbar.getButton(6).setVisible(false);
        toolbar.addLegend(this.panelLegend);
        return toolbar;
    }

    @Override
    protected TngTableRowHeader rowHeaderInitialize() {
        return null;
    }

    @Override
    protected void tableExit() {
        this.dlgCancelAction();
    }

    public void createToolbarLegend() {
        this.panelLegend.setLayout(new GridBagLayout());
        TngComboBox groupComboBox = new TngComboBox();
        groupComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e2) {
                TngComboBox source = (TngComboBox)e2.getSource();
                if (source.getSelectedIndex() == 0) {
                    TngTablePanelJournalFile.this.filterGroup = null;
                } else {
                    Object item = source.getSelectedItem();
                    TngTablePanelJournalFile.this.filterGroup = item == null ? null : item.toString();
                }
                TngTablePanelJournalFile.this.tableRefresh();
            }
        });
        groupComboBox.addItem(Nat.x("V\u0161etko"));
        ArrayList<String> distinctGroupsSorted = new ArrayList<String>();
        distinctGroupsSorted.addAll(this.distinctGroups);
        Collections.sort(distinctGroupsSorted);
        for (String group : distinctGroupsSorted) {
            groupComboBox.addItem(group);
        }
        this.panelLegend.add((Component)groupComboBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 10, 0, 10), 0, 0));
        TngCheckBox onlyErrorsCheckBox = new TngCheckBox();
        onlyErrorsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TngTablePanelJournalFile.this.filterOnlyErrors = ((TngCheckBox)e2.getSource()).isSelected();
                TngTablePanelJournalFile.this.tableRefresh();
            }
        });
        onlyErrorsCheckBox.setText(Nat.x("Len chyby"));
        this.panelLegend.add((Component)onlyErrorsCheckBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }
}

