/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.table.export;

import java.awt.Dimension;
import java.io.File;
import java.math.BigDecimal;
import tangram.exception.TngExceptionAbort;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.swing.panel.TngProgressableWorker;
import tangram.swing.table.component.TngTableColumn;
import tangram.swing.table.component.TngTableColumnType;
import tangram.swing.table.component.TngTableRow;
import tangram.swing.table.model.TngTableModel;

public class TngTableExporter {
    private TngProgressableWorker worker;
    private File file;
    private TngTableModel tableModel;
    private TngTableColumn[] usedTableColumns;

    public void setFile(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void setTableModel(TngTableModel tableModel) {
        this.tableModel = tableModel;
    }

    public void setUsedTableColumns(TngTableColumn[] usedTableColumns) {
        this.usedTableColumns = usedTableColumns;
    }

    protected TngTableModel getTableModel() {
        return this.tableModel;
    }

    protected TngTableColumn[] getUsedTableColumns() {
        return this.usedTableColumns;
    }

    protected int getTableRowCount() {
        return this.getTableModel().getRowCount();
    }

    public void export() throws Exception {
        this.worker = new TngProgressableWorker(Nat.x("Prebieha export \u00fadajov, \u010dakajte, pros\u00edm...")){

            @Override
            public void compute() throws Exception {
                TngTableExporter.this.exportInner();
            }
        };
        this.worker.setProgressCancelable(true);
        this.worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportInner() throws Exception {
        try {
            this.progressDesc(Nat.x("Pr\u00edprava z\u00e1pisu \u00fadajov"));
            this.processBefore();
            this.progressDesc(Nat.x("Z\u00e1pis \u00fadajov"));
            this.processTableRows();
            this.progressDesc(Nat.x("Ukon\u010dovanie z\u00e1pisu \u00fadajov"));
            this.processAfter();
        }
        finally {
            this.progressDesc(Nat.x("Finaliz\u00e1cia exportu"));
            this.processFinally();
        }
    }

    protected void processBefore() throws Exception {
    }

    protected void processAfter() throws Exception {
    }

    protected void processFinally() throws Exception {
    }

    protected void processTableRows() throws Exception {
        int rowsCount = this.getTableRowCount();
        this.progressMax(rowsCount);
        for (int row = 0; row < rowsCount; ++row) {
            if (this.worker.isProgressCanceled()) {
                throw new TngExceptionAbort();
            }
            this.progressActual(row + 1);
            this.processTableRow(row);
        }
    }

    protected void processTableRow(int row) throws Exception {
        TngTableRow tableRow = this.getTableModel().getRow(row);
        String[] renderedTableRowValues = this.getRenderedTableRowValues(this.getUsedTableRowValues(tableRow));
        String[] transformedTableRowValues = this.transformTableRowValues(renderedTableRowValues);
        this.processTableRowValues(transformedTableRowValues);
    }

    protected Object[] getUsedTableRowValues(TngTableRow tableRow) {
        TngTableColumn[] usedTableColumns = this.getUsedTableColumns();
        TngTableColumn[] tableColumns = this.getTableModel().getColumns();
        int usedTableColumnsCount = usedTableColumns.length;
        Object[] usedTableRowValues = new Object[usedTableColumnsCount];
        for (int col = 0; col < usedTableColumnsCount; ++col) {
            int usesTableColumnIndex = TngTableColumn.findByName(tableColumns, usedTableColumns[col].name);
            usedTableRowValues[col] = usesTableColumnIndex < 0 || usesTableColumnIndex >= tableRow.values.length ? null : tableRow.values[usesTableColumnIndex];
        }
        return usedTableRowValues;
    }

    protected String[] getRenderedTableRowValues(Object[] tableRowValues) throws Exception {
        TngTableColumn[] usedTableColumns = this.getUsedTableColumns();
        int usedTableColumnsCount = usedTableColumns.length;
        String[] renderedTableRowValues = new String[usedTableColumnsCount];
        for (int col = 0; col < usedTableColumnsCount; ++col) {
            renderedTableRowValues[col] = this.getRenderedTableRowColumnValue(col, tableRowValues[col]);
        }
        return renderedTableRowValues;
    }

    protected String getRenderedTableRowColumnValue(int usedTableColumnIndex, Object tableRowValue) throws Exception {
        TngTableColumn[] usedTableColumns = this.getUsedTableColumns();
        TngTableColumn usedTableColumn = usedTableColumns[usedTableColumnIndex];
        usedTableColumn.renderValue = tableRowValue;
        usedTableColumn.prepareRender();
        return usedTableColumn.renderString;
    }

    protected String[] transformTableRowValues(String[] tableRowValues) throws Exception {
        TngTableColumn[] usedTableColumns = this.getUsedTableColumns();
        int usedTableColumnsCount = usedTableColumns.length;
        String[] transformedTableRowValues = new String[usedTableColumnsCount];
        for (int col = 0; col < usedTableColumnsCount; ++col) {
            String transformedTableRowValue;
            TngTableColumn usedTableColumn = usedTableColumns[col];
            transformedTableRowValues[col] = transformedTableRowValue = this.transformTableRowValue(usedTableColumn, tableRowValues[col]);
        }
        return transformedTableRowValues;
    }

    protected String transformTableRowValue(TngTableColumn usedTableColumn, String tableRowValue) throws Exception {
        return tableRowValue;
    }

    protected void processTableRowValues(String[] transformedTableRowValues) throws Exception {
    }

    protected void progressDesc(String progressDesc) {
        this.worker.setProgressStatus(progressDesc);
    }

    protected void progressMax(int progressMax) {
        this.worker.setProgressMax(progressMax);
    }

    protected void progressActual(int progressActual) {
        this.worker.setProgressValue(progressActual);
    }

    protected Dimension resolveDimensionByModel(TngTableColumn usedTableColumn) {
        Dimension dim = new Dimension(0, 0);
        int usedColumnIndex = TngTableColumn.findByName(this.getUsedTableColumns(), usedTableColumn.name);
        if (usedColumnIndex == -1) {
            return dim;
        }
        TngTableColumnType usedColumnType = usedTableColumn.type;
        if (usedColumnType.isNumeric()) {
            return this.resolveDimensionByModelNumeric(usedColumnIndex);
        }
        return this.resolveDimensionByModelNonNumeric(usedColumnIndex);
    }

    private Dimension resolveDimensionByModelNumeric(int usedColumnIndex) {
        Dimension dim = new Dimension(0, 0);
        TngTableModel tableModel = this.getTableModel();
        for (int i2 = 0; i2 < tableModel.getRowCount(); ++i2) {
            BigDecimal valueDecimal;
            String valueStr;
            Object value = tableModel.getObject(i2, usedColumnIndex);
            if (value == null || TngUtilities.isEmpty(valueStr = value.toString()) || (valueDecimal = TngUtilities.stringToNumber(valueStr)) == null) continue;
            BigDecimal valueDecimalNoZero = valueDecimal.stripTrailingZeros();
            int precision = valueDecimalNoZero.precision();
            int scale = valueDecimalNoZero.scale();
            if (scale < 0) {
                precision -= scale;
                scale = 0;
            }
            if (precision > dim.width) {
                dim.width = precision;
            }
            if (scale <= dim.height) continue;
            dim.height = scale;
        }
        return dim;
    }

    private Dimension resolveDimensionByModelNonNumeric(int usedColumnIndex) {
        Dimension dim = new Dimension(0, 0);
        TngTableModel tableModel = this.getTableModel();
        for (int i2 = 0; i2 < tableModel.getRowCount(); ++i2) {
            int valueStrLen;
            String valueStr;
            Object value = tableModel.getObject(i2, usedColumnIndex);
            if (value == null || TngUtilities.isEmpty(valueStr = value.toString()) || (valueStrLen = valueStr.length()) <= dim.width) continue;
            dim.width = valueStrLen;
        }
        return dim;
    }
}

