/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.table.export;

import java.awt.Dimension;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import tangram.library.TngUtilities;
import tangram.swing.table.component.TngTableColumn;
import tangram.swing.table.component.TngTableColumnType;
import tangram.swing.table.export.TngTableExporter;
import tangram.swing.table.export.TngTableExporterColumn;

public class TngTableExporterTDF
extends TngTableExporter {
    private StringBuilder data = new StringBuilder();
    private BufferedWriter fileWriter;
    private List<TdfColumn> tdfColumns = new ArrayList<TdfColumn>();

    @Override
    protected void processBefore() throws Exception {
        this.fileWriter = new BufferedWriter(new FileWriter(this.getFile()));
        this.loadTdfColumns();
        this.writeDbfHeader();
    }

    @Override
    protected void processTableRowValues(String[] transformedTableRowValues) throws Exception {
        this.data.setLength(0);
        for (int col = 0; col < transformedTableRowValues.length; ++col) {
            String value = transformedTableRowValues[col];
            this.data.append(value);
            if (col == transformedTableRowValues.length - 1) continue;
            this.data.append(",");
        }
        this.fileWrite(this.data.toString());
    }

    @Override
    protected String transformTableRowValue(TngTableColumn tableColumn, String tableRowValue) throws Exception {
        if (TngUtilities.isEmpty(tableRowValue)) {
            return "";
        }
        return tableRowValue.replace(',', ' ');
    }

    @Override
    protected void processAfter() throws Exception {
        if (this.fileWriter != null) {
            this.fileWriter.close();
        }
    }

    private void loadTdfColumns() throws Exception {
        TngTableColumn[] usedTableColumns;
        this.tdfColumns.clear();
        for (TngTableColumn usedTableColumn : usedTableColumns = this.getUsedTableColumns()) {
            TdfColumn dbfColumn = new TdfColumn();
            dbfColumn.resolveColumn(usedTableColumn);
            this.tdfColumns.add(dbfColumn);
        }
    }

    private void writeDbfHeader() throws Exception {
        TdfColumn tdfColumn;
        int col;
        int colCount = this.tdfColumns.size();
        this.data.setLength(0);
        this.data.append(";");
        for (col = 0; col < colCount; ++col) {
            tdfColumn = this.tdfColumns.get(col);
            this.data.append(tdfColumn.getName());
            if (col == colCount - 1) continue;
            this.data.append(",");
        }
        this.fileWrite(this.data.toString());
        for (col = 0; col < colCount; ++col) {
            tdfColumn = this.tdfColumns.get(col);
            this.data.setLength(0);
            this.data.append(";");
            this.data.append(TngUtilities.strPadLeft(tdfColumn.getName(), 30, ' '));
            this.data.append(TngUtilities.strPadLeft(tdfColumn.getTypeAsAstring(), 15, ' '));
            this.data.append(tdfColumn.getPrecisionScaleAsString());
            this.fileWrite(this.data.toString());
        }
    }

    private void fileWrite(String text) throws Exception {
        this.fileWriter.append(text);
        this.fileWriter.newLine();
    }

    private class TdfColumn
    extends TngTableExporterColumn {
        private TdfColumn() {
        }

        @Override
        protected void resolveName() {
            this.name = this.tableColumn.title.toUpperCase();
            this.name = TngUtilities.strLeft(this.name, 19);
            this.name = this.name.replace(' ', '_');
        }

        @Override
        protected void resolveDimension() {
            Dimension dim = TngTableExporterTDF.this.resolveDimensionByModel(this.tableColumn);
            this.precision = dim.width;
            this.scale = dim.height;
        }

        private String getTypeAsAstring() {
            String typeAsString = "Char";
            if (this.tableColumn.type == TngTableColumnType.DECIMAL) {
                typeAsString = "Number";
            } else if (this.tableColumn.type == TngTableColumnType.DATE) {
                typeAsString = "Date";
            } else if (this.tableColumn.type == TngTableColumnType.DATETIME) {
                typeAsString = "Stamp";
            }
            return typeAsString;
        }

        private String getPrecisionScaleAsString() {
            String precision = this.getPrecision() <= 0 ? null : String.valueOf(this.getPrecision());
            String scale = this.getScale() <= 0 ? null : String.valueOf(this.getScale());
            return TngUtilities.strExt(precision, ",", scale);
        }
    }
}

