/*
 * Decompiled with CFR 0.152.
 */
package tangram.swing.table.export;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import tangram.library.TngXlsWorkbook;
import tangram.swing.table.component.TngTableColumn;
import tangram.swing.table.component.TngTableRow;
import tangram.swing.table.export.TngTableExporter;

public class TngTableExporterXLS
extends TngTableExporter {
    private TngXlsWorkbook workbook = new TngXlsWorkbook();
    private int sheetNumber = 0;
    private int rowNumber = 0;
    private Sheet sheet;

    @Override
    protected void processBefore() throws Exception {
        TngTableColumn[] usedTableColumns = this.getUsedTableColumns();
        String[] usedTableColumnsNames = new String[usedTableColumns.length];
        int usedTableColumnsCount = usedTableColumnsNames.length;
        for (int col = 0; col < usedTableColumnsCount; ++col) {
            usedTableColumnsNames[col] = usedTableColumns[col].title;
        }
        this.workbook.setData(this.getFile(), usedTableColumnsNames);
        this.sheet = this.workbook.createSheetWithHeader(++this.sheetNumber);
    }

    @Override
    protected void processTableRow(int row) throws Exception {
        if (!this.workbook.isSXSSF() && this.rowNumber == 32766) {
            this.sheet = this.workbook.createSheetWithHeader(++this.sheetNumber);
            this.rowNumber = 0;
        }
        TngTableColumn[] usedTableColumns = this.getUsedTableColumns();
        int usedTableColumnsCount = usedTableColumns.length;
        TngTableRow tableRow = this.getTableModel().getRow(row);
        Object[] tableRowValues = this.getUsedTableRowValues(tableRow);
        Row sheetRow = this.sheet.createRow(this.rowNumber + 1);
        for (int col = 0; col < usedTableColumnsCount; ++col) {
            Cell cell = sheetRow.createCell(col);
            this.workbook.setCellValueByType(cell, tableRowValues[col]);
        }
        ++this.rowNumber;
    }

    @Override
    protected void processAfter() throws Exception {
        this.workbook.autoSizeSheetsColumns();
        this.workbook.write();
    }
}

