/*
 * Decompiled with CFR 0.152.
 */
package tangram.updater;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import tangram.dm.Version;
import tangram.library.Nat;
import tangram.library.TngUtilities;
import tangram.updater.Observer;
import tangram.updater.Project;

public class Core {
    public static final int UPDATE_PROGRESS_COUNT = 6;
    private static final String CORE_VERSION = "1.0";
    private static final String DIR_LOG = "log";
    private static final String DIR_ARCHIVE = "archive";
    private static final String DIR_SOURCE = "source";
    private static final String FILE_DELETE_TIP = Nat.x("Overte \u010di m\u00e1te pr\u00edstupov\u00e9 pr\u00e1vo na zmazanie s\u00faboru a \u010di sa s\u00fabor pr\u00e1ve teraz nepou\u017e\u00edva.");
    private String baseDir;
    private String workDir;
    private List<String> deleteForceFiles = new ArrayList<String>();
    private static DecimalFormat df = new DecimalFormat("#,###");
    private static DecimalFormat dfx = new DecimalFormat("#,###.0");
    private static final String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
    private static final int STATUS_REMOVE = 0;
    private static final int STATUS_ACTUALIZE = 1;
    private static final int STATUS_SKIP = 2;

    public Core() {
        this.setBaseDir(null);
        this.setWorkDir(null);
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public void setBaseDir(String dir) {
        if (dir != null) {
            this.baseDir = dir;
        } else {
            File act = new File(System.getProperty("user.dir"));
            this.baseDir = act.getParent();
        }
    }

    public void setWorkDir(String dir) {
        this.workDir = dir != null ? dir : System.getProperty("user.dir");
    }

    private String getProjectPath(Project prj) {
        return prj.dir;
    }

    private String getProjectFile(Project prj, String file) {
        return this.getProjectPath(prj) + File.separator + file;
    }

    private String getWorkFile(String subpath, String file) {
        return this.workDir + File.separator + subpath + File.separator + file;
    }

    private String getWorkFile(String subdir, String prefix, String ext, Date start) throws Exception {
        SimpleDateFormat fmtDateTime = new SimpleDateFormat("yyyyMMdd_HHmm");
        return this.getWorkFile(subdir, prefix + "_" + fmtDateTime.format(start) + ext);
    }

    public String[] getSources(String path) throws Exception {
        if (path.toLowerCase().startsWith("http:")) {
            return this.getHttpFiles(path);
        }
        File[] files = new File(path).listFiles();
        if (files == null) {
            return new String[0];
        }
        String[] x2 = new String[files.length];
        for (int i2 = 0; i2 < files.length; ++i2) {
            x2[i2] = files[i2].getAbsolutePath();
        }
        return x2;
    }

    public void findProjectSources(List<Version> versions, Project prj, String[] files) {
        versions.clear();
        if (files == null || files.length == 0) {
            return;
        }
        for (int i2 = 0; i2 < files.length; ++i2) {
            try {
                Version v2 = this.getSourceVersion(prj.code, files[i2]);
                versions.add(v2);
                continue;
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
    }

    public void findProjectSource(Project prj, String[] files) {
        prj.srcFile = null;
        prj.srcVersion = null;
        if (files == null || files.length == 0) {
            return;
        }
        Version maxVersion = new Version("0.00");
        for (int i2 = 0; i2 < files.length; ++i2) {
            try {
                Version v2 = this.getSourceVersion(prj.code, files[i2]);
                if (v2.compareTo(maxVersion) <= 0) continue;
                maxVersion = v2;
                prj.srcVersion = v2;
                prj.srcFile = files[i2];
                continue;
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
    }

    public void findProjectSourceVersion(Project prj, String[] files, Version version) {
        prj.srcFile = null;
        prj.srcVersion = null;
        if (files == null || files.length == 0) {
            return;
        }
        for (int i2 = 0; i2 < files.length; ++i2) {
            try {
                Version v2 = this.getSourceVersion(prj.code, files[i2]);
                if (v2.compareTo(version) != 0) continue;
                prj.srcVersion = v2;
                prj.srcFile = files[i2];
                return;
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
    }

    public void setProjectSource(Project prj, String source) throws Exception {
        prj.srcFile = source;
        prj.srcVersion = source == null ? null : this.getSourceVersion(prj.code, source);
    }

    public void updateProject(Project prj, Observer observer) throws Exception {
        Date start = new Date();
        Source source = null;
        observer.logPrintStream = null;
        SimpleDateFormat fmtDatum = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        if (prj.status != 2) {
            throw new Exception(Nat.x("Produktov\u00fd bal\u00edk %1 e\u0161te nie je nain\u0161talovan\u00fd", prj.name));
        }
        try {
            this.createDir(DIR_LOG);
            String log = this.getWorkFile(DIR_LOG, prj.code, ".txt", start);
            observer.openLog(log);
            observer.log(Nat.nox("\u0160tart: %1", fmtDatum.format(start)));
            observer.log(Nat.nox("Updater core: %1", CORE_VERSION));
            observer.log(Nat.nox("Aktualiz\u00e1cia produktoveho bal\u00edku: %1", prj.name));
            observer.log(Nat.nox("Fixn\u00e9 s\u00fabory: %1", prj.skipFiles == null ? Nat.nox("\u017eiadne") : prj.skipFiles));
            observer.log(Nat.nox("Adres\u00e1r: %1", this.getProjectPath(prj)));
            observer.log(Nat.nox("Aktu\u00e1lna verzia: %1", prj.getVersion()));
            observer.log(Nat.nox("Cie\u013eov\u00e1 verzia: %1", prj.srcVersion));
            observer.log(Nat.nox("S\u00fabor aktualiz\u00e1cie: %1", prj.srcFile));
            observer.log(Nat.nox("Pracovn\u00fd adres\u00e1r: %1", this.workDir));
            this.createDir(DIR_ARCHIVE);
            this.createDir(DIR_SOURCE);
            ProjectFile[] files = this.getProjectFiles(prj);
            File src = this.copySource(prj.srcFile, observer);
            source = this.verifySource(prj, src, files, observer);
            long prjSize = this.verifyProject(prj, files, observer);
            observer.log(Nat.nox("Ve\u013ekos\u0165 aktu\u00e1lnych s\u00faborov: %1 bytov", prjSize));
            observer.log(Nat.nox("Ve\u013ekos\u0165 nov\u00fdch s\u00faborov: %1 bytov", source.size));
            String arch = this.getWorkFile(DIR_ARCHIVE, prj.code, ".zip", start);
            this.archiveProject(new File(arch), files, observer);
            observer.progressSetCritical(true);
            this.clearProject(files, observer);
            this.unzipSource(prj, source, observer);
            if (source != null) {
                this.closeSafe(source.zip);
            }
        }
        catch (Exception e2) {
            try {
                observer.log("Chyba: " + this.getError(e2));
                throw e2;
            }
            catch (Throwable throwable) {
                if (source != null) {
                    this.closeSafe(source.zip);
                }
                observer.log(Nat.nox("Koniec: %1", fmtDatum.format(new Date())));
                observer.closeLog();
                throw throwable;
            }
        }
        observer.log(Nat.nox("Koniec: %1", fmtDatum.format(new Date())));
        observer.closeLog();
    }

    private void createDir(String subpath) throws Exception {
        File dir = new File(this.workDir + File.separator + subpath);
        if (dir.isDirectory()) {
            return;
        }
        if (!dir.mkdirs()) {
            throw new Exception(Nat.x("Nie je mo\u017en\u00e9 vytvori\u0165 adres\u00e1r %1", dir.getAbsolutePath()));
        }
    }

    private String getError(Throwable e2) {
        String h2 = e2.getMessage();
        if (h2 != null && h2.length() != 0) {
            return h2;
        }
        h2 = e2.getClass().getName();
        return h2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void archiveProject(File zipFile, ProjectFile[] files, Observer observer) throws Exception {
        if (files.length == 0) {
            this.skipProgress(Nat.x("Archiv\u00e1cia produktov\u00e9ho bal\u00edka sa nerob\u00ed, neexistuj\u00fa \u017eiadne s\u00fabory"), observer);
            return;
        }
        ZipOutputStream zip = null;
        FileInputStream in = null;
        try {
            int i2;
            observer.log(Nat.nox("Archiv\u00e1cia produktov\u00e9ho bal\u00edka do s\u00faboru %1", zipFile.getName()));
            long totalSize = 0L;
            for (i2 = 0; i2 < files.length; ++i2) {
                totalSize += files[i2].file.length();
            }
            observer.progressStart(Nat.x("Archiv\u00e1cia produktov\u00e9ho bal\u00edka"), totalSize);
            zip = new ZipOutputStream(new FileOutputStream(zipFile));
            for (i2 = 0; i2 < files.length; ++i2) {
                observer.progressBreak();
                observer.log(Nat.nox(" - archiv\u00e1cia s\u00faboru %1", files[i2].getName()));
                ZipEntry ze = new ZipEntry(files[i2].getName());
                ze.setTime(files[i2].file.lastModified());
                zip.putNextEntry(ze);
                if (files[i2].file.isFile()) {
                    in = new FileInputStream(files[i2].file);
                    this.copyStream(in, zip, observer);
                    in.close();
                    in = null;
                }
                zip.closeEntry();
            }
            zip.close();
            zip = null;
            observer.progressEnd();
            this.closeSafe(zip);
            this.closeSafe(in);
        }
        catch (Throwable throwable) {
            this.closeSafe(zip);
            this.closeSafe(in);
            throw throwable;
        }
    }

    private void clearProject(ProjectFile[] files, Observer observer) throws Exception {
        this.deleteForceFiles.clear();
        if (files.length == 0) {
            this.skipProgress(Nat.x("\u010cistenie produktov\u00e9ho bal\u00edka sa nerob\u00ed, neexistuj\u00fa \u017eiadne s\u00fabory"), observer);
            return;
        }
        observer.log(Nat.nox("\u010cistenie produktov\u00e9ho bal\u00edka"));
        observer.progressStart(Nat.x("\u010cistenie produktov\u00e9ho bal\u00edka"), files.length);
        for (int i2 = 0; i2 < files.length; ++i2) {
            observer.progressBreak();
            if (files[i2].status == 0) {
                observer.log(Nat.nox(" - mazanie s\u00faboru %1", files[i2].getName()));
                this.deleteFile(files[i2].file, observer);
            }
            observer.progressAdd(1L);
        }
        observer.progressEnd();
    }

    private void deleteFile(File file, Observer observer) throws Exception {
        if (!file.exists()) {
            observer.log(Nat.nox("   s\u00fabor bol medzi\u010dasom zmazan\u00fd"));
            return;
        }
        String error = null;
        try {
            if (!file.delete()) {
                error = Nat.x("S\u00fabor %1 nie je mo\u017en\u00e9 zmaza\u0165", file.getName());
            }
        }
        catch (Exception e2) {
            error = Nat.x("S\u00fabor %1 nie je mo\u017en\u00e9 zmaza\u0165: %2", file.getName(), this.getError(e2));
        }
        if (error == null) {
            return;
        }
        String warning = error + "\n" + FILE_DELETE_TIP + "\n" + Nat.x("Ak sa s\u00fabor nepodar\u00ed zmaza\u0165, tak produktov\u00fd bal\u00edk ostane v nekonzistentnom stave.\n\u017del\u00e1te si pokra\u010dova\u0165?");
        observer.log(Nat.nox("   upozornenie: %1", error));
        this.deleteForce(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteForce(File file) {
        this.deleteForceFiles.add(file.getAbsolutePath());
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file, false);
            this.closeSafe(out);
        }
        catch (Throwable e2) {
            try {
                TngUtilities.exceptionLog(e2);
                this.closeSafe(out);
            }
            catch (Throwable throwable) {
                this.closeSafe(out);
                throw throwable;
            }
        }
    }

    public List<String> getDeleteForceFiles() {
        return this.deleteForceFiles;
    }

    private void canDeleteFile(File file, Observer observer) throws Exception {
        String error;
        String warning;
        do {
            if (!file.exists()) {
                observer.log(Nat.nox("   s\u00fabor bol medzi\u010dasom zmazan\u00fd"));
                return;
            }
            if (!file.canWrite() && !file.getName().toLowerCase().endsWith(".exe")) {
                return;
            }
            error = null;
            try {
                this.canDeleteFile(file);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                error = Nat.x("S\u00fabor %1 nebude mo\u017en\u00e9 zmaza\u0165: %2", file.getName(), this.getError(e2));
            }
            if (error == null) {
                return;
            }
            warning = error + "\n" + FILE_DELETE_TIP + "\n" + Nat.x("\u017del\u00e1te si sk\u00fasi\u0165 overi\u0165 zmazanie s\u00faboru e\u0161te raz?");
            observer.log(Nat.nox("   upozornenie: %1", error));
        } while (observer.warningYesNo(warning));
        throw new Exception(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void canDeleteFile(File file) throws Exception {
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "rw");
        }
        finally {
            try {
                raf.close();
            }
            catch (Exception exception) {}
        }
    }

    private long verifyProject(Project prj, ProjectFile[] files, Observer observer) throws Exception {
        if (files.length == 0) {
            this.skipProgress(Nat.x("Kontrola produktov\u00e9ho bal\u00edka sa nerob\u00ed, neexistuj\u00fa \u017eiadne s\u00fabory"), observer);
            return 0L;
        }
        observer.log(Nat.nox("Kontrola produktov\u00e9ho bal\u00edka"));
        observer.progressStart(Nat.x("Kontrola produktov\u00e9ho bal\u00edka"), files.length);
        long size = 0L;
        for (int i2 = 0; i2 < files.length; ++i2) {
            observer.progressBreak();
            long l2 = files[i2].file.length();
            if (files[i2].status == 0) {
                size += l2;
                observer.log(Nat.nox(" - s\u00fabor %1 bude zmazan\u00fd (%2)", files[i2].getName(), this.showSize(l2)));
                this.canDeleteFile(files[i2].file, observer);
            } else if (files[i2].status == 1) {
                size += l2;
                observer.log(Nat.nox(" - s\u00fabor %1 bude aktualizovan\u00fd (%2)", files[i2].getName(), this.showSize(l2)));
            } else {
                observer.log(Nat.nox(" - s\u00fabor %1 bude ponechan\u00fd (%2) (%3)", files[i2].getName(), this.showSize(l2), files[i2].info));
            }
            observer.progressAdd(1L);
        }
        observer.progressEnd();
        return size;
    }

    private int findFile(String zipFile, ProjectFile[] files) {
        if (zipFile == null || files == null) {
            return -1;
        }
        zipFile = this.normalizeZipFile(zipFile);
        for (int i2 = 0; i2 < files.length; ++i2) {
            String f2 = files[i2].getName().toLowerCase();
            if (!zipFile.equals(f2)) continue;
            return i2;
        }
        return -1;
    }

    private String normalizeZipFile(String zipFile) {
        if (zipFile.endsWith("/")) {
            zipFile = zipFile.substring(0, zipFile.length() - 1);
        }
        zipFile = zipFile.toLowerCase().replace('/', File.separatorChar);
        return zipFile;
    }

    private Source verifySource(Project prj, File src, ProjectFile[] files, Observer observer) throws Exception {
        ZipEntry ze;
        observer.log(Nat.nox("Kontrola s\u00faboru aktualiz\u00e1cie"));
        Source source = new Source();
        source.zip = new ZipFile(src);
        ArrayList<String> allDirs = new ArrayList<String>();
        Enumeration<? extends ZipEntry> e2 = source.zip.entries();
        while (e2.hasMoreElements()) {
            String skip;
            observer.progressBreak();
            ze = e2.nextElement();
            String zfile = ze.getName();
            if (ze.isDirectory()) {
                allDirs.add(zfile);
            }
            if ((skip = this.skipDirs(prj.skipDirs, this.normalizeZipFile(zfile))) != null) {
                observer.log(Nat.nox(" - s\u00fabor %1 sa ignoruje, u\u017e existuje ako fixn\u00fd s\u00fabor (%2)", zfile, skip));
                continue;
            }
            int f2 = this.findFile(zfile, files);
            if (f2 >= 0) {
                if (files[f2].status == 2) {
                    observer.log(Nat.nox(" - s\u00fabor %1 sa ignoruje, u\u017e existuje ako fixn\u00fd s\u00fabor (%2)", zfile, files[f2].info));
                    continue;
                }
                files[f2].status = 1;
            }
            long l2 = ze.getSize();
            source.files.add(ze);
            if (l2 < 0L || source.size < 0L) {
                source.size = -1L;
                continue;
            }
            source.size += l2;
        }
        this.verifyOnlyLocalDirs(allDirs, files);
        observer.progressStart(Nat.x("Kontrola s\u00faboru aktualiz\u00e1cie"), source.size);
        for (int i2 = 0; i2 < source.files.size(); ++i2) {
            ze = source.files.get(i2);
            observer.log(Nat.nox(" - kontrolovanie s\u00faboru %1 (%2)", ze.getName(), this.showSize(ze.getSize())));
            long crc = this.verifyZipFile(source.zip, ze, observer);
            this.verifyZipCrc(ze, crc, observer);
        }
        observer.progressEnd();
        return source;
    }

    private void verifyOnlyLocalDirs(List<String> sourceDirs, ProjectFile[] projectFiles) {
        for (ProjectFile projectFile : projectFiles) {
            String name;
            if (projectFile.status == 2 || !(name = projectFile.getName().toLowerCase()).contains(File.separator)) continue;
            boolean found = false;
            for (String sourceDir : sourceDirs) {
                if (!name.startsWith(sourceDir = this.normalizeZipFile(sourceDir) + File.separator)) continue;
                found = true;
            }
            if (found) continue;
            projectFile.setSkip("[local]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long verifyZipFile(ZipFile zip, ZipEntry ze, Observer observer) throws Exception {
        InputStream in = null;
        try {
            in = zip.getInputStream(ze);
            if (in == null) {
                throw new Exception(Nat.x("Chyba pri otv\u00e1ran\u00ed s\u00faboru %1 v s\u00fabore aktualiz\u00e1cie", ze.getName()));
            }
            long crc = this.copyStreamCrc(in, null, observer);
            in.close();
            in = null;
            long l2 = crc;
            return l2;
        }
        finally {
            this.closeSafe(in);
        }
    }

    private void verifyZipCrc(ZipEntry ze, long crc, Observer observer) throws Exception {
        if (ze.getCrc() < 0L) {
            observer.log(Nat.nox("Nie je mo\u017en\u00e9 overi\u0165 CRC s\u00faboru %1, preto\u017ee v ZIP s\u00fabore nie je CRC ulo\u017een\u00e9", ze.getName()));
        } else if (ze.getCrc() != crc) {
            throw new Exception(Nat.x("S\u00fabor %1 je po\u0161koden\u00fd, nesed\u00ed CRC", ze.getName()));
        }
    }

    private File copySource(String srcFile, Observer observer) throws Exception {
        if (srcFile.toLowerCase().startsWith("http:")) {
            return this.copyHttpSource(srcFile, observer);
        }
        return this.copyFileSource(srcFile, observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File copyFileSource(String srcFile, Observer observer) throws Exception {
        File orig = new File(srcFile);
        File source = new File(this.getWorkFile(DIR_SOURCE, orig.getName()));
        if (source.exists() && orig.length() == source.length() && orig.lastModified() == source.lastModified()) {
            this.skipProgress(Nat.x("S\u00fabor aktualiz\u00e1cie %1 u\u017e existuje", orig.getName()), observer);
            return source;
        }
        long l2 = orig.length();
        observer.log(Nat.nox("Kop\u00edrovanie s\u00faboru aktualiz\u00e1cie %1 (%2)", orig.getName(), this.showSize(l2)));
        observer.progressStart(Nat.x("Kop\u00edrovanie s\u00faboru aktualiz\u00e1cie: %1", this.showSizeIq(l2)), l2);
        FileOutputStream out = null;
        FileInputStream in = null;
        try {
            out = new FileOutputStream(source);
            in = new FileInputStream(orig);
            this.copyStream(in, out, observer);
            observer.progressEnd();
            out.close();
            out = null;
            in.close();
            in = null;
            source.setLastModified(orig.lastModified());
            File file = source;
            this.closeSafe(out);
            this.closeSafe(in);
            return file;
        }
        catch (Throwable throwable) {
            this.closeSafe(out);
            this.closeSafe(in);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File copyHttpSource(String srcFile, Observer observer) throws Exception {
        URL url = new URL(srcFile);
        URLConnection uc = url.openConnection();
        long origLength = uc.getContentLength();
        long origLastModified = uc.getLastModified();
        String origName = new File(srcFile).getName();
        File source = new File(this.getWorkFile(DIR_SOURCE, origName));
        if (source.exists() && origLength == source.length() && origLastModified == source.lastModified()) {
            this.skipProgress(Nat.x("S\u00fabor aktualiz\u00e1cie %1 u\u017e existuje", origName), observer);
            return source;
        }
        observer.log(Nat.nox("S\u0165ahovanie s\u00faboru aktualiz\u00e1cie %1 (%2)", origName, this.showSize(origLength)));
        observer.progressStart(Nat.x("S\u0165ahovanie s\u00faboru aktualiz\u00e1cie: %1", this.showSizeIq(origLength)), origLength);
        FileOutputStream out = null;
        InputStream in = null;
        try {
            out = new FileOutputStream(source);
            in = uc.getInputStream();
            this.copyStream(in, out, observer);
            observer.progressEnd();
            out.close();
            out = null;
            in.close();
            in = null;
            source.setLastModified(origLastModified);
            File file = source;
            return file;
        }
        finally {
            this.closeSafe(out);
            this.closeSafe(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzipSource(Project prj, Source source, Observer observer) throws Exception {
        observer.log(Nat.nox("Rozba\u013eovanie s\u00faborov"));
        observer.progressStart(Nat.x("Rozba\u013eovanie s\u00faborov"), source.size);
        FileOutputStream out = null;
        InputStream in = null;
        try {
            for (int i2 = 0; i2 < source.files.size(); ++i2) {
                ZipEntry ze = source.files.get(i2);
                String zfile = ze.getName();
                File ofile = new File(this.getProjectFile(prj, zfile));
                observer.log(Nat.nox(" - rozba\u013eovanie s\u00faboru %1", zfile));
                if (ze.isDirectory()) {
                    ofile.mkdir();
                    ofile.setLastModified(ze.getTime());
                    continue;
                }
                if (ofile.exists()) {
                    ofile.delete();
                }
                if ((in = source.zip.getInputStream(ze)) == null) {
                    throw new Exception(Nat.x("Chyba pri otv\u00e1ran\u00ed s\u00faboru %1 zo s\u00faboru aktualiz\u00e1cie", ze.getName()));
                }
                out = new FileOutputStream(ofile);
                long crc = this.copyStreamCrc(in, out, observer);
                this.verifyZipCrc(ze, crc, observer);
                out.close();
                out = null;
                ofile.setLastModified(ze.getTime());
                if (ze.getExtra() != null) {
                    // empty if block
                }
                in.close();
                in = null;
            }
            observer.progressEnd();
        }
        finally {
            this.closeSafe(out);
            this.closeSafe(in);
        }
    }

    private ProjectFile[] getProjectFiles(Project prj) throws Exception {
        File dir = new File(this.getProjectPath(prj));
        SkipResolver resolver = new SkipResolver();
        resolver.setSkipPatterns(prj.skipFiles);
        List<File> fileList = this.getProjectFilesRecursive(dir);
        File[] files = fileList.toArray(new File[fileList.size()]);
        ProjectFile[] pfiles = new ProjectFile[files.length];
        for (int i2 = 0; i2 < files.length; ++i2) {
            File singleFile = files[i2];
            pfiles[i2] = new ProjectFile(prj, singleFile);
            String skip = null;
            if (singleFile.isDirectory()) {
                skip = "[dir]";
            } else if (singleFile.isFile()) {
                skip = resolver.check(singleFile.getName());
            }
            if (skip == null) {
                skip = this.skipDirs(prj.skipDirs, pfiles[i2].getName());
            }
            if (skip == null) continue;
            pfiles[i2].setSkip(skip);
        }
        return pfiles;
    }

    private String skipDirs(String skipDirs, String name) {
        String[] wildcards = null;
        if (skipDirs == null || skipDirs.length() == 0) {
            return null;
        }
        wildcards = skipDirs.split(",");
        for (int i2 = 0; i2 < wildcards.length; ++i2) {
            String wildcard = wildcards[i2].trim();
            if (!name.startsWith(wildcard + File.separator)) continue;
            return "[dir]" + wildcard;
        }
        return null;
    }

    private List<File> getProjectFilesRecursive(File aStartingDir) {
        ArrayList<File> result = new ArrayList<File>();
        File[] filesAndDirs = aStartingDir.listFiles();
        List<File> filesDirs = Arrays.asList(filesAndDirs);
        for (File file : filesDirs) {
            result.add(file);
            if (file.isFile()) continue;
            List<File> deeperList = this.getProjectFilesRecursive(file);
            result.addAll(deeperList);
        }
        return result;
    }

    private void copyStream(InputStream in, OutputStream out, Observer observer) throws Exception {
        int n2;
        byte[] buf = new byte[1024];
        while ((n2 = in.read(buf)) > 0) {
            observer.progressBreak();
            if (out != null) {
                out.write(buf, 0, n2);
            }
            observer.progressAdd(n2);
        }
    }

    private long copyStreamCrc(InputStream in, OutputStream out, Observer observer) throws Exception {
        int n2;
        byte[] buf = new byte[1024];
        CRC32 crc32 = new CRC32();
        while ((n2 = in.read(buf)) > 0) {
            observer.progressBreak();
            crc32.update(buf, 0, n2);
            if (out != null) {
                out.write(buf, 0, n2);
            }
            if (n2 != buf.length) {
                observer.progressAdd(n2);
                continue;
            }
            observer.progressAdd(n2);
        }
        return crc32.getValue();
    }

    private void closeSafe(ZipFile c2) {
        if (c2 != null) {
            try {
                c2.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void closeSafe(OutputStream c2) {
        if (c2 != null) {
            try {
                c2.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void closeSafe(InputStream c2) {
        if (c2 != null) {
            try {
                c2.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void closeSafe(Reader c2) {
        if (c2 != null) {
            try {
                c2.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private Version getSourceVersion(String code, String source) throws Exception {
        String ext;
        String prefix;
        String h2 = (source = new File(source).getName()).toLowerCase();
        if (!h2.startsWith(prefix = "update_" + code + "_")) {
            throw new Exception(Nat.x("S\u00fabor aktualiz\u00e1cie %1 nie je pre produktov\u00fd bal\u00edk %2", source, code));
        }
        if (!(h2 = h2.substring(prefix.length())).endsWith(ext = ".zip")) {
            throw new Exception(Nat.x("S\u00fabor aktualiz\u00e1cie %1 nie je pre ZIP s\u00fabor", source));
        }
        h2 = h2.substring(0, h2.length() - ext.length());
        h2 = h2.replace('_', '.');
        try {
            return new Version(h2);
        }
        catch (Throwable e2) {
            throw new Exception(Nat.x("S\u00fabor aktualiz\u00e1cie %1 neobsahuje \u010d\u00edslo verzie", source));
        }
    }

    private String showSize(long l2) {
        return df.format(l2);
    }

    private String showSizeIq(long l2) {
        for (int i2 = units.length - 1; i2 > 0; --i2) {
            long g2 = 1L << i2 * 10;
            if (l2 <= g2) continue;
            double s2 = (double)l2 / (double)g2;
            return dfx.format(s2) + " " + units[i2];
        }
        return df.format(l2) + " " + units[0];
    }

    private void skipProgress(String text, Observer observer) {
        observer.log(text);
        observer.progressStart(text, 1L);
        observer.progressAdd(1L);
        observer.progressEnd();
    }

    private static String regexFromWildcards(String wild) {
        StringBuilder buffer = new StringBuilder();
        char[] chars = wild.toCharArray();
        for (int i2 = 0; i2 < chars.length; ++i2) {
            if (chars[i2] == '*') {
                buffer.append(".*");
                continue;
            }
            if (chars[i2] == '?') {
                buffer.append(".");
                continue;
            }
            if ("+()^$.{}[]|\\".indexOf(chars[i2]) != -1) {
                buffer.append('\\').append(chars[i2]);
                continue;
            }
            buffer.append(chars[i2]);
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getHttpFiles(String host) throws Exception {
        BufferedReader in = null;
        ArrayList<String> files = new ArrayList<String>();
        try {
            String line;
            URL url = new URL(host);
            in = new BufferedReader(new InputStreamReader(url.openStream()));
            String bMark = "<a href=\"update_";
            String eMark = ".zip\">";
            int bCut = 9;
            int eCut = 2;
            while ((line = in.readLine()) != null) {
                int p2 = line.toLowerCase().indexOf(bMark);
                if (p2 < 0 || (p2 = (line = line.substring(p2 + bCut)).toLowerCase().indexOf(eMark)) < 0) continue;
                line = line.substring(0, p2 + eMark.length() - eCut);
                files.add(host + "/" + line);
            }
            in.close();
            in = null;
            String[] stringArray = files.toArray(new String[files.size()]);
            this.closeSafe(in);
            return stringArray;
        }
        catch (Throwable throwable) {
            this.closeSafe(in);
            throw throwable;
        }
    }

    private class SkipResolver {
        Pattern[] patterns;
        String[] wildcards;

        private SkipResolver() {
        }

        public void setSkipPatterns(String skipFiles) throws Exception {
            this.patterns = null;
            this.wildcards = null;
            if (skipFiles == null || skipFiles.length() == 0) {
                return;
            }
            this.wildcards = skipFiles.split(",");
            this.patterns = new Pattern[this.wildcards.length];
            for (int i2 = 0; i2 < this.wildcards.length; ++i2) {
                this.wildcards[i2] = this.wildcards[i2].trim();
                String p2 = Core.regexFromWildcards(this.wildcards[i2]);
                this.patterns[i2] = Pattern.compile(p2, 2);
            }
        }

        public String check(String name) {
            if (this.patterns == null) {
                return null;
            }
            for (int i2 = 0; i2 < this.patterns.length; ++i2) {
                Matcher skip = this.patterns[i2].matcher(name);
                if (!skip.matches()) continue;
                return this.wildcards[i2];
            }
            return null;
        }
    }

    private class Source {
        ZipFile zip;
        ArrayList<ZipEntry> files = new ArrayList();
        long size;

        private Source() {
        }
    }

    private static class ProjectFile {
        public Project project;
        public File file;
        public String info;
        public int status = 0;

        public ProjectFile(Project project, File file) {
            this.project = project;
            this.file = file;
        }

        public void setSkip(String skip) {
            this.info = skip;
            this.status = 2;
        }

        public String getName() {
            String parent = this.project.dir + File.separator;
            return this.file.getAbsolutePath().substring(parent.length());
        }
    }
}

