/*
 * Decompiled with CFR 0.152.
 */
package tangram.xml;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import tangram.interfaces.TngProgressable;
import tangram.library.Nat;
import tangram.library.TngConnection;
import tangram.library.TngSqlUtilities;
import tangram.library.TngUtilities;
import tangram.xml.XmlTableExport;
import tangram.xml.XmlTableExportPrm;

public final class XmlTableExportZip {
    public static void getSchemaTables(TngConnection connection, String schema, String template, String version, List<XmlTableExportPrm> tables) throws Exception {
        tables.clear();
        ArrayList<String> names = new ArrayList<String>();
        TngSqlUtilities.readRegularTables(connection, schema, names);
        if (names.size() == 0) {
            return;
        }
        HashMap<String, String> orders = new HashMap<String, String>();
        TngSqlUtilities.readPrimaryOrders(connection, schema, orders);
        for (int i2 = 0; i2 < names.size(); ++i2) {
            String name = names.get(i2);
            XmlTableExportPrm table = new XmlTableExportPrm();
            table.xmlName = name;
            table.sqlName = name;
            table.schema = schema;
            table.template = template;
            table.version = version;
            table.order = orders.get(name);
            table.filter = null;
            tables.add(table);
        }
    }

    public static void exportSchema(TngConnection connection, String schema, String template, String version, File dir, TngProgressable progress) throws Exception {
        progress.setProgressTitle(Nat.x("Export sch\u00e9my %1", schema));
        progress.setProgressStatus(Nat.x("Zis\u0165ovanie zoznamu tabuliek"));
        progress.setProgressMax(-1);
        ArrayList<XmlTableExportPrm> tables = new ArrayList<XmlTableExportPrm>();
        XmlTableExportZip.getSchemaTables(connection, schema, template, version, tables);
        String zip = schema + "_" + new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date()) + ".ZIP";
        File fileZip = new File(dir, zip);
        XmlTableExportZip.exportTables(tables, connection, fileZip, progress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportTables(List<XmlTableExportPrm> prms, TngConnection connection, File fileZip, TngProgressable progress) throws Exception {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(fileZip));
            int count = prms.size();
            for (int i2 = 0; i2 < count; ++i2) {
                XmlTableExportPrm prm = prms.get(i2);
                progress.setProgressStatus(Nat.x("Export tabu\u013eky %1 (%2/%3)", prm.sqlName, i2 + 1, count));
                progress.setProgressValue(0);
                ZipEntry ze = new ZipEntry(prm.xmlName + ".XML");
                zos.putNextEntry(ze);
                XmlTableExport.exportTable(prm, connection, new BufferedWriter(new OutputStreamWriter((OutputStream)zos, "windows-1250")), progress);
                zos.closeEntry();
            }
            zos.close();
        }
        catch (Throwable throwable) {
            TngUtilities.streamCloseSafe(zos);
            throw throwable;
        }
        TngUtilities.streamCloseSafe(zos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportTable(XmlTableExportPrm prm, TngConnection connection, File fileZip, TngProgressable progress) throws Exception {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(fileZip));
            ZipEntry ze = new ZipEntry(prm.xmlName + ".XML");
            zos.putNextEntry(ze);
            XmlTableExport.exportTable(prm, connection, new BufferedWriter(new OutputStreamWriter((OutputStream)zos, "windows-1250")), progress);
            zos.closeEntry();
            zos.close();
        }
        catch (Throwable throwable) {
            TngUtilities.streamCloseSafe(zos);
            throw throwable;
        }
        TngUtilities.streamCloseSafe(zos);
    }
}

