/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.base32hex;

import com.bysquare.base32hex.Base32hexException;
import com.bysquare.base32hex.IBase32hexEncoder;

public class Base32hexEncoder
implements IBase32hexEncoder {
    private static final String BASE32HEX = "0123456789ABCDEFGHIJKLMNOPQRSTUV";
    private static final char[] BASE32HEX_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUV".toCharArray();
    private static final byte[] BASE32HEX_BYTES = "0123456789ABCDEFGHIJKLMNOPQRSTUV".getBytes();
    private static final byte[] EMPTY = new byte[0];

    public byte[] decode(byte[] byArray) throws Base32hexException {
        if (byArray.length == 0) {
            return EMPTY;
        }
        int n2 = 0;
        byte[] byArray2 = new byte[byArray.length * 5 / 8];
        byte by = 0;
        int n3 = 8;
        for (byte by2 : byArray) {
            int n4;
            if (48 <= by2 && by2 <= 57) {
                n4 = by2 - 48;
            } else if (65 <= by2 && by2 <= 86) {
                n4 = by2 - 65 + 10;
            } else {
                throw new Base32hexException("Unable to decode byte: " + by2);
            }
            if (n3 > 5) {
                n3 = (byte)(n3 - 5);
                by = (byte)(by | n4 << n3);
                continue;
            }
            byArray2[n2++] = (byte)(by | n4 >> 5 - n3);
            n3 = (byte)(n3 + 3);
            by = (byte)(n4 << n3);
        }
        if (n2 < byArray2.length) {
            byArray2[n2] = by;
        }
        return byArray2;
    }

    public byte[] decode(String string) throws Base32hexException {
        int n2 = string.length();
        if (n2 == 0) {
            return EMPTY;
        }
        int n3 = 0;
        byte[] byArray = new byte[n2 * 5 / 8];
        byte by = 0;
        int n4 = 8;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n5;
            char c2 = string.charAt(i2);
            if ('0' <= c2 && c2 <= '9') {
                n5 = c2 - 48;
            } else if ('A' <= c2 && c2 <= 'V') {
                n5 = c2 - 65 + 10;
            } else {
                throw new Base32hexException("Unable to decode character: " + c2);
            }
            if (n4 > 5) {
                n4 = (byte)(n4 - 5);
                by = (byte)(by | n5 << n4);
                continue;
            }
            byArray[n3++] = (byte)(by | n5 >> 5 - n4);
            n4 = (byte)(n4 + 3);
            by = (byte)(n5 << n4);
        }
        if (n3 < byArray.length) {
            byArray[n3] = by;
        }
        return byArray;
    }

    public byte[] encode(byte[] byArray) {
        if (byArray.length == 0) {
            return EMPTY;
        }
        byte[] byArray2 = new byte[(int)Math.ceil((double)(byArray.length * 8) / 5.0)];
        int n2 = 0;
        int n3 = 0;
        int n4 = 5;
        for (int n5 : byArray) {
            int n6 = n5 > -1 ? n5 : n5 + 256;
            n3 = (byte)(n3 | n6 >> 8 - n4);
            byArray2[n2++] = BASE32HEX_BYTES[n3];
            if (n4 < 4) {
                n3 = (byte)(n6 >> 3 - n4 & 0x1F);
                byArray2[n2++] = BASE32HEX_BYTES[n3];
                n4 = (byte)(n4 + 5);
            }
            n4 = (byte)(n4 - 3);
            n3 = (byte)(n6 << n4 & 0x1F);
        }
        if (n2 < byArray2.length) {
            byArray2[n2] = BASE32HEX_BYTES[n3];
        }
        return byArray2;
    }

    public String encodeToString(byte[] byArray) {
        if (byArray.length == 0) {
            return "";
        }
        char[] cArray = new char[(int)Math.ceil((double)(byArray.length * 8) / 5.0)];
        int n2 = 0;
        int n3 = 0;
        int n4 = 5;
        for (int n5 : byArray) {
            int n6 = n5 > -1 ? n5 : n5 + 256;
            n3 = (byte)(n3 | n6 >> 8 - n4);
            cArray[n2++] = BASE32HEX_CHARS[n3];
            if (n4 < 4) {
                n3 = (byte)(n6 >> 3 - n4 & 0x1F);
                cArray[n2++] = BASE32HEX_CHARS[n3];
                n4 = (byte)(n4 + 5);
            }
            n4 = (byte)(n4 - 3);
            n3 = (byte)(n6 << n4 & 0x1F);
        }
        if (n2 < cArray.length) {
            cArray[n2] = BASE32HEX_CHARS[n3];
        }
        return new String(cArray);
    }
}

