/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.document;

import com.bysquare.document.IVerifiable;
import com.bysquare.document.InvalidValueException;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Verify {
    public static final String REGEX_BIC = "[A-Z]{4}[A-Z]{2}[A-Z0-9]{2}([A-Z0-9]{3})?";
    public static final String REGEX_ConstantSymbol = "[0-9]{0,4}";
    public static final String REGEX_CountryCode = "[A-Z]{3}";
    public static final String REGEX_CurrencyCode = "[A-Z]{3}";
    public static final String REGEX_IBAN = "[A-Z]{2}[0-9]{2}[A-Z0-9]{0,30}";
    public static final String REGEX_SpecificSymbol = "[0-9]{0,10}";
    public static final String REGEX_VariableSymbol = "[0-9]{0,10}";
    private static final String NOT_POSITIVE = "cannot be negative, but value %s found";
    private static ThreadLocal<Matcher> matcher = new ThreadLocal<Matcher>(){

        @Override
        protected Matcher initialValue() {
            return Pattern.compile("\\s").matcher("");
        }
    };

    public static void notNull(String string, Object object) throws InvalidValueException {
        if (object == null) {
            throw new InvalidValueException(string + " cannot be null. ");
        }
    }

    public static void notNullAndPercentage(String string, Double d2) throws InvalidValueException {
        Verify.notNull(string, d2);
        if (d2 < 0.0 || d2 > 1.0) {
            throw new InvalidValueException(string + " is invalid, value must be between 0 and 1 inclusive. ");
        }
    }

    public static void notNullAndMatch(String string, String string2, String string3) throws InvalidValueException {
        Verify.notNull(string, string2);
        Verify.nullOrMatch(string, string2, string3);
    }

    public static void notNullAndPositive(String string, Double d2) throws InvalidValueException {
        Verify.notNull(string, d2);
        if (d2 < 0.0) {
            throw new InvalidValueException(string, (Object)String.format(NOT_POSITIVE, d2));
        }
    }

    public static void notNullAndPositive(String string, Integer n2) throws InvalidValueException {
        Verify.notNull(string, n2);
        if (n2 < 0) {
            throw new InvalidValueException(string, (Object)String.format(NOT_POSITIVE, n2));
        }
    }

    public static void notNullAndVerify(String string, IVerifiable iVerifiable) throws InvalidValueException {
        Verify.notNull(string, iVerifiable);
        iVerifiable.verify();
    }

    public static void nullOrInRange(String string, Integer n2, int n3, int n4) throws InvalidValueException {
        if (n2 != null && (n2 < n3 || n2 > n4)) {
            String string2 = String.format("%s is out of range [%s..%s]", n2, n3, n4);
            throw new InvalidValueException(string, (Object)string2);
        }
    }

    public static void nullOrMatch(String string, String string2, String string3) throws InvalidValueException {
        if (string2 != null && !string2.matches(string3)) {
            throw new InvalidValueException(String.format("%s value does not match %s. ", string, string3));
        }
    }

    public static void nullOrPositive(String string, Double d2) throws InvalidValueException {
        if (d2 != null && d2 < 0.0) {
            throw new InvalidValueException(string, (Object)String.format(NOT_POSITIVE, d2));
        }
    }

    public static void nullOrPositive(String string, Integer n2) throws InvalidValueException {
        if (n2 != null && n2 < 0) {
            throw new InvalidValueException(string, (Object)String.format(NOT_POSITIVE, n2));
        }
    }

    public static void nullOrVerify(IVerifiable iVerifiable) throws InvalidValueException {
        if (iVerifiable != null) {
            iVerifiable.verify();
        }
    }

    public static void isNull(String string, Object object, String string2) throws InvalidValueException {
        if (object != null) {
            throw new InvalidValueException(string, (Object)("must be null, " + string2));
        }
    }

    public static <E extends Enum<E>> void enumList(String string, List<E> list, Class<E> clazz) throws InvalidValueException {
        Verify.notNull(string, list);
        if (list.isEmpty()) {
            throw new InvalidValueException(string, (Object)"must not be empty");
        }
        EnumSet<Enum> enumSet = EnumSet.noneOf(clazz);
        for (Enum enum_ : list) {
            if (enum_ == null) {
                throw new InvalidValueException(string, (Object)"must not contain null");
            }
            if (enumSet.contains(enum_)) {
                throw new InvalidValueException(string, (Object)("contains more than one " + enum_));
            }
            enumSet.add(enum_);
        }
    }

    public static void periodFromToDate(Date date, Date date2) throws InvalidValueException {
        if (date != null || date2 != null) {
            Verify.notNull("PeriodFromDate", date);
            Verify.notNull("PeriodToDate", date2);
            if (date.after(date2)) {
                throw new InvalidValueException("PeriodFromDate is after PeriodToDate. ");
            }
        }
    }

    public static void choice(String string, Object ... objectArray) throws InvalidValueException {
        String string2 = null;
        String[] stringArray = string.split(" ");
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] == null) continue;
            String string3 = stringArray[i2];
            if (string2 != null) {
                throw new InvalidValueException(string3 + " conflicts with " + string2 + " field value. ");
            }
            string2 = string3;
        }
        if (string2 == null) {
            throw new InvalidValueException("At least one field is required from: " + string);
        }
    }

    public static final String trim(String string) {
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        return string;
    }

    public static final String trimAll(String string) {
        if (string != null && (string = matcher.get().reset(string).replaceAll("")).length() == 0) {
            string = null;
        }
        return string;
    }

    public static final String trimAllToUpperCase(String string) {
        if (string != null) {
            string = matcher.get().reset(string).replaceAll("");
            string = string.length() == 0 ? null : string.toUpperCase();
        }
        return string;
    }
}

