/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.document.invoice;

import com.bysquare.document.IVerifiable;
import com.bysquare.document.InvalidValueException;
import com.bysquare.document.invoice.InvoiceBase;
import com.bysquare.document.invoice.TaxCategorySummary;
import java.util.Collections;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Order(elements={"TaxExclusiveAmount", "TaxInclusiveAmount", "TaxAmount", "AlreadyClaimedTaxExclusiveAmount", "AlreadyClaimedTaxInclusiveAmount", "AlreadyClaimedTaxAmount", "DifferenceTaxExclusiveAmount", "DifferenceTaxInclusiveAmount", "DifferenceTaxAmount", "PayableRoundingAmount", "PaidDepositsAmount", "PayableAmount"})
@Root(name="MonetarySummary", strict=false)
public class MonetarySummary
implements IVerifiable {
    protected Double payableRoundingAmount;
    protected Double paidDepositsAmount;
    transient InvoiceBase invoice;

    @Element(name="TaxExclusiveAmount", required=false)
    public Double getTaxExclusiveAmount() {
        double d2 = 0.0;
        for (TaxCategorySummary taxCategorySummary : this.getTaxCategorySummaries()) {
            d2 += taxCategorySummary.getTaxExclusiveAmount().doubleValue();
        }
        return d2;
    }

    @Deprecated
    @Element(name="TaxExclusiveAmount", required=false)
    public void setTaxExclusiveAmount(Double d2) {
    }

    @Element(name="TaxInclusiveAmount", required=false)
    public Double getTaxInclusiveAmount() {
        double d2 = 0.0;
        for (TaxCategorySummary taxCategorySummary : this.getTaxCategorySummaries()) {
            d2 += taxCategorySummary.getTaxInclusiveAmount().doubleValue();
        }
        return d2;
    }

    @Deprecated
    @Element(name="TaxInclusiveAmount", required=false)
    public void setTaxInclusiveAmount(Double d2) {
    }

    @Element(name="TaxAmount", required=false)
    public Double getTaxAmount() {
        double d2 = 0.0;
        for (TaxCategorySummary taxCategorySummary : this.getTaxCategorySummaries()) {
            d2 += taxCategorySummary.getTaxAmount().doubleValue();
        }
        return d2;
    }

    @Deprecated
    @Element(name="TaxAmount", required=false)
    public void setTaxAmount(Double d2) {
    }

    @Element(name="AlreadyClaimedTaxExclusiveAmount", required=false)
    public Double getAlreadyClaimedTaxExclusiveAmount() {
        double d2 = 0.0;
        for (TaxCategorySummary taxCategorySummary : this.getTaxCategorySummaries()) {
            d2 += taxCategorySummary.getAlreadyClaimedTaxExclusiveAmount().doubleValue();
        }
        return d2;
    }

    @Deprecated
    @Element(name="AlreadyClaimedTaxExclusiveAmount", required=false)
    public void setAlreadyClaimedTaxExclusiveAmount(Double d2) {
    }

    @Element(name="AlreadyClaimedTaxInclusiveAmount", required=false)
    public Double getAlreadyClaimedTaxInclusiveAmount() {
        double d2 = 0.0;
        for (TaxCategorySummary taxCategorySummary : this.getTaxCategorySummaries()) {
            d2 += taxCategorySummary.getAlreadyClaimedTaxInclusiveAmount().doubleValue();
        }
        return d2;
    }

    @Deprecated
    @Element(name="AlreadyClaimedTaxInclusiveAmount", required=false)
    public void setAlreadyClaimedTaxInclusiveAmount(Double d2) {
    }

    @Element(name="AlreadyClaimedTaxAmount", required=false)
    public Double getAlreadyClaimedTaxAmount() {
        double d2 = 0.0;
        for (TaxCategorySummary taxCategorySummary : this.getTaxCategorySummaries()) {
            d2 += taxCategorySummary.getAlreadyClaimedTaxAmount().doubleValue();
        }
        return d2;
    }

    @Deprecated
    @Element(name="AlreadyClaimedTaxAmount", required=false)
    public void setAlreadyClaimedTaxAmount(Double d2) {
    }

    @Element(name="DifferenceTaxExclusiveAmount", required=false)
    public Double getDifferenceTaxExclusiveAmount() {
        double d2 = 0.0;
        for (TaxCategorySummary taxCategorySummary : this.getTaxCategorySummaries()) {
            d2 += taxCategorySummary.getDifferenceTaxExclusiveAmount().doubleValue();
        }
        return d2;
    }

    @Deprecated
    @Element(name="DifferenceTaxExclusiveAmount", required=false)
    public void setDifferenceTaxExclusiveAmount(Double d2) {
    }

    @Element(name="DifferenceTaxInclusiveAmount", required=false)
    public Double getDifferenceTaxInclusiveAmount() {
        double d2 = 0.0;
        for (TaxCategorySummary taxCategorySummary : this.getTaxCategorySummaries()) {
            d2 += taxCategorySummary.getDifferenceTaxInclusiveAmount().doubleValue();
        }
        return d2;
    }

    @Deprecated
    @Element(name="DifferenceTaxInclusiveAmount", required=false)
    public void setDifferenceTaxInclusiveAmount(Double d2) {
    }

    @Element(name="DifferenceTaxAmount", required=false)
    public Double getDifferenceTaxAmount() {
        double d2 = 0.0;
        for (TaxCategorySummary taxCategorySummary : this.getTaxCategorySummaries()) {
            d2 += taxCategorySummary.getDifferenceTaxAmount().doubleValue();
        }
        return d2;
    }

    @Deprecated
    @Element(name="DifferenceTaxAmount", required=false)
    public void setDifferenceTaxAmount(Double d2) {
    }

    @Element(name="PayableRoundingAmount", required=false)
    public Double getPayableRoundingAmount() {
        if (this.payableRoundingAmount == null) {
            this.payableRoundingAmount = 0.0;
        }
        return this.payableRoundingAmount;
    }

    @Element(name="PayableRoundingAmount", required=false)
    public void setPayableRoundingAmount(Double d2) {
        this.payableRoundingAmount = d2;
    }

    @Element(name="PaidDepositsAmount", required=false)
    public Double getPaidDepositsAmount() {
        if (this.paidDepositsAmount == null) {
            this.paidDepositsAmount = 0.0;
        }
        return this.paidDepositsAmount;
    }

    @Element(name="PaidDepositsAmount", required=false)
    public void setPaidDepositsAmount(Double d2) {
        this.paidDepositsAmount = d2;
    }

    @Element(name="PayableAmount", required=false)
    public Double getPayableAmount() {
        return this.getDifferenceTaxInclusiveAmount() - this.getPaidDepositsAmount() + this.getPayableRoundingAmount();
    }

    @Deprecated
    @Element(name="PayableAmount", required=false)
    public void setPayableAmount(Double d2) {
    }

    private Iterable<TaxCategorySummary> getTaxCategorySummaries() {
        if (this.invoice != null) {
            return this.invoice.getTaxCategorySummaries();
        }
        return Collections.emptyList();
    }

    @Override
    public void verify() throws InvalidValueException {
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof MonetarySummary)) {
            return false;
        }
        MonetarySummary monetarySummary = (MonetarySummary)object;
        return this.getPaidDepositsAmount().equals(monetarySummary.getPaidDepositsAmount()) && this.getPayableRoundingAmount().equals(monetarySummary.getPayableRoundingAmount());
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + this.getPaidDepositsAmount().hashCode();
        n2 = 31 * n2 + this.getPayableRoundingAmount().hashCode();
        return n2;
    }
}

