/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.document.invoice;

import com.bysquare.document.IVerifiable;
import com.bysquare.document.InvalidValueException;
import com.bysquare.document.Verify;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Order;
import org.simpleframework.xml.Root;

@Order(elements={"StreetName", "BuildingNumber", "CityName", "PostalZone", "State", "Country"})
@Root(name="PostalAddress", strict=false)
public class PostalAddress
implements IVerifiable {
    protected String streetName;
    protected String buildingNumber;
    protected String cityName;
    protected String postalZone;
    protected String state;
    protected String country;

    @Element(name="StreetName", required=false)
    public String getStreetName() {
        return this.streetName;
    }

    @Element(name="StreetName", required=false)
    public void setStreetName(String string) {
        this.streetName = Verify.trim(string);
    }

    @Element(name="BuildingNumber", required=false)
    public String getBuildingNumber() {
        return this.buildingNumber;
    }

    @Element(name="BuildingNumber", required=false)
    public void setBuildingNumber(String string) {
        this.buildingNumber = Verify.trim(string);
    }

    @Element(name="CityName", required=false)
    public String getCityName() {
        return this.cityName;
    }

    @Element(name="CityName", required=false)
    public void setCityName(String string) {
        this.cityName = Verify.trim(string);
    }

    @Element(name="PostalZone", required=false)
    public String getPostalZone() {
        return this.postalZone;
    }

    @Element(name="PostalZone", required=false)
    public void setPostalZone(String string) {
        this.postalZone = Verify.trimAll(string);
    }

    @Element(name="State", required=false)
    public String getState() {
        return this.state;
    }

    @Element(name="State", required=false)
    public void setState(String string) {
        this.state = Verify.trim(string);
    }

    @Element(name="Country", required=false)
    public String getCountry() {
        return this.country;
    }

    @Element(name="Country", required=false)
    public void setCountry(String string) {
        this.country = Verify.trimAllToUpperCase(string);
    }

    public boolean isEmpty() {
        return this.streetName == null && this.buildingNumber == null && this.cityName == null && this.postalZone == null && this.state == null && this.country == null;
    }

    public void verify() throws InvalidValueException {
        Verify.notNull("StreetName", this.getStreetName());
        Verify.notNull("CityName", this.getCityName());
        Verify.notNull("PostalZone", this.getPostalZone());
        Verify.notNullAndMatch("Country", this.getCountry(), "[A-Z]{3}");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof PostalAddress)) {
            return false;
        }
        PostalAddress postalAddress = (PostalAddress)object;
        if (this.buildingNumber == null ? postalAddress.buildingNumber != null : !this.buildingNumber.equals(postalAddress.buildingNumber)) {
            return false;
        }
        if (this.cityName == null ? postalAddress.cityName != null : !this.cityName.equals(postalAddress.cityName)) {
            return false;
        }
        if (this.country == null ? postalAddress.country != null : !this.country.equals(postalAddress.country)) {
            return false;
        }
        if (this.postalZone == null ? postalAddress.postalZone != null : !this.postalZone.equals(postalAddress.postalZone)) {
            return false;
        }
        if (this.state == null ? postalAddress.state != null : !this.state.equals(postalAddress.state)) {
            return false;
        }
        return !(this.streetName == null ? postalAddress.streetName != null : !this.streetName.equals(postalAddress.streetName));
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.buildingNumber == null ? 0 : this.buildingNumber.hashCode());
        n2 = 31 * n2 + (this.cityName == null ? 0 : this.cityName.hashCode());
        n2 = 31 * n2 + (this.country == null ? 0 : this.country.hashCode());
        n2 = 31 * n2 + (this.postalZone == null ? 0 : this.postalZone.hashCode());
        n2 = 31 * n2 + (this.state == null ? 0 : this.state.hashCode());
        n2 = 31 * n2 + (this.streetName == null ? 0 : this.streetName.hashCode());
        return n2;
    }
}

