/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.logo;

import com.bysquare.logo.LogoFactory;
import com.bysquare.logo.LogoKey;
import com.bysquare.logo.MissingLogoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class DirectoryLogoFactory
extends LogoFactory {
    private File directory;

    public DirectoryLogoFactory(File file) {
        this.setDirectory(file);
    }

    public File getDirectory() {
        return this.directory;
    }

    protected InputStream getInputStream(LogoKey logoKey) throws MissingLogoException {
        File file = new File(this.directory, logoKey + ".png");
        if (!file.exists()) {
            throw new MissingLogoException("Cannot find logo file: " + file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new MissingLogoException("Cannot read logo file: " + file.getAbsolutePath());
        }
        try {
            return new FileInputStream(file);
        }
        catch (Throwable throwable) {
            throw new MissingLogoException("Cannot create logo: " + logoKey, throwable);
        }
    }

    public void setDirectory(File file) {
        if (file == null) {
            throw new NullPointerException("Logo directory cannot be null. ");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("File is not a logo directory. ");
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException("Cannot read from logo directory. ");
        }
        this.directory = file;
    }
}

