/*
 * Decompiled with CFR 0.152.
 */
package com.bysquare.sequence;

import com.bysquare.document.BysquareDocument;
import com.bysquare.document.invoiceitems.DeliveryNoteReference;
import com.bysquare.document.invoiceitems.InvoiceItemsBase;
import com.bysquare.document.invoiceitems.InvoiceLine;
import com.bysquare.document.invoiceitems.InvoiceLines;
import com.bysquare.document.invoiceitems.OrderReference;
import com.bysquare.sequence.SequenceEncoder;

class InvoiceItemsBaseEncoder
extends SequenceEncoder {
    InvoiceItemsBaseEncoder() {
    }

    private void encode(OrderReference orderReference) {
        if (orderReference != null) {
            this.add(orderReference.getOrderID(), 4, 10);
            this.add(orderReference.getOrderLineID(), 3, 10);
        } else {
            this.skip();
            this.skip();
        }
    }

    private void encode(DeliveryNoteReference deliveryNoteReference) {
        if (deliveryNoteReference != null) {
            this.add(deliveryNoteReference.getDeliveryNoteID(), 2, 10);
            this.add(deliveryNoteReference.getDeliveryNoteLineID(), 1, 10);
        } else {
            this.skip();
            this.skip();
        }
    }

    private void encode(InvoiceLine invoiceLine) {
        if (invoiceLine != null) {
            this.encode(invoiceLine.getOrderReference());
            this.encode(invoiceLine.getDeliveryNoteReference());
            this.add(invoiceLine.getItemName(), 5, 30);
            this.add(invoiceLine.getItemEANCode(), 6, 10);
            this.add(invoiceLine.getPeriodFromDate());
            this.add(invoiceLine.getPeriodToDate());
            this.add(invoiceLine.getInvoicedQuantity());
            this.add(invoiceLine.getUnitPriceTaxExclusiveAmount());
            this.add(invoiceLine.getUnitPriceTaxAmount());
            this.add(invoiceLine.getClassifiedTaxCategory());
        } else {
            this.encode((OrderReference)null);
            this.encode((DeliveryNoteReference)null);
            this.skip();
            this.skip();
            this.skip();
            this.skip();
            this.skip();
            this.skip();
            this.skip();
            this.skip();
        }
    }

    private void encode(InvoiceLines invoiceLines) {
        this.add(invoiceLines.size());
        for (InvoiceLine invoiceLine : invoiceLines) {
            this.encode(invoiceLine);
        }
    }

    private void encode(InvoiceItemsBase invoiceItemsBase) {
        this.add(invoiceItemsBase.getInvoiceID(), 8, 10);
        this.add(invoiceItemsBase.getFirstInvoiceLineID(), 7, 10);
        this.encode(invoiceItemsBase.getInvoiceLines());
    }

    protected void encodeInternal(BysquareDocument bysquareDocument) {
        this.encode((InvoiceItemsBase)bysquareDocument);
    }

    protected int getFieldCount(BysquareDocument bysquareDocument) {
        return 3 + ((InvoiceItemsBase)bysquareDocument).getInvoiceLines().size() * 12;
    }
}

