/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringsResourceTranslator {
    private static final String API_KEY = System.getProperty("translateAPI.key");
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Pattern ENTRY_PATTERN = Pattern.compile("<string name=\"([^\"]+)\".*>([^<]+)</string>");
    private static final Pattern STRINGS_FILE_NAME_PATTERN = Pattern.compile("values-(.+)");
    private static final Pattern TRANSLATE_RESPONSE_PATTERN = Pattern.compile("translatedText\":\\s*\"([^\"]+)\"");
    private static final Pattern VALUES_DIR_PATTERN = Pattern.compile("values-[a-z]{2}(-[a-zA-Z]{2,3})?");
    private static final String APACHE_2_LICENSE = "<!--\n Copyright (C) 2013 ZXing authors\n\n Licensed under the Apache License, Version 2.0 (the \"License\");\n you may not use this file except in compliance with the License.\n You may obtain a copy of the License at\n\n      http://www.apache.org/licenses/LICENSE-2.0\n\n Unless required by applicable law or agreed to in writing, software\n distributed under the License is distributed on an \"AS IS\" BASIS,\n WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n See the License for the specific language governing permissions and\n limitations under the License.\n -->\n";
    private static final Map<String, String> LANGUAGE_CODE_MASSAGINGS = new HashMap<String, String>(3);

    private StringsResourceTranslator() {
    }

    public static void main(String[] args) throws IOException {
        File[] translatedValuesDirs;
        File resDir = new File(args[0]);
        File valueDir = new File(resDir, "values");
        File stringsFile = new File(valueDir, "strings.xml");
        List<String> forceRetranslation = Arrays.asList(args).subList(1, args.length);
        for (File translatedValuesDir : translatedValuesDirs = resDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && VALUES_DIR_PATTERN.matcher(file.getName()).matches();
            }
        })) {
            File translatedStringsFile = new File(translatedValuesDir, "strings.xml");
            StringsResourceTranslator.translate(stringsFile, translatedStringsFile, forceRetranslation);
        }
    }

    private static void translate(File englishFile, File translatedFile, Collection<String> forceRetranslation) throws IOException {
        SortedMap<String, String> english = StringsResourceTranslator.readLines(englishFile);
        SortedMap<String, String> translated = StringsResourceTranslator.readLines(translatedFile);
        String parentName = translatedFile.getParentFile().getName();
        Matcher stringsFileNameMatcher = STRINGS_FILE_NAME_PATTERN.matcher(parentName);
        stringsFileNameMatcher.find();
        String language = stringsFileNameMatcher.group(1);
        String massagedLanguage = LANGUAGE_CODE_MASSAGINGS.get(language);
        if (massagedLanguage != null) {
            language = massagedLanguage;
        }
        System.out.println("Translating " + language);
        File resultTempFile = File.createTempFile(parentName, ".xml");
        resultTempFile.deleteOnExit();
        boolean anyChange = false;
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(resultTempFile), UTF8));){
            out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            out.write(APACHE_2_LICENSE);
            out.write("<resources>\n");
            for (Map.Entry englishEntry : english.entrySet()) {
                String key = (String)englishEntry.getKey();
                String value = (String)englishEntry.getValue();
                out.write("  <string name=\"");
                out.write(key);
                ((Writer)out).write(34);
                if (value.contains("%s") || value.contains("%f")) {
                    out.write(" formatted=\"false\"");
                }
                ((Writer)out).write(62);
                String translatedString = (String)translated.get(key);
                if (translatedString == null || forceRetranslation.contains(key)) {
                    anyChange = true;
                    translatedString = StringsResourceTranslator.translateString(value, language);
                }
                out.write(translatedString);
                out.write("</string>\n");
            }
            out.write("</resources>\n");
            ((Writer)out).flush();
        }
        if (anyChange) {
            System.out.println("  Writing translations");
            translatedFile.delete();
            resultTempFile.renameTo(translatedFile);
        } else {
            resultTempFile.delete();
        }
    }

    static String translateString(String english, String language) throws IOException {
        if ("en".equals(language)) {
            return english;
        }
        String massagedLanguage = LANGUAGE_CODE_MASSAGINGS.get(language);
        if (massagedLanguage != null) {
            language = massagedLanguage;
        }
        System.out.println("  Need translation for " + english);
        if (API_KEY == null) {
            throw new IllegalArgumentException("translateAPI.key is not specified");
        }
        URL translateURL = new URL("https://www.googleapis.com/language/translate/v2?key=" + API_KEY + "&q=" + URLEncoder.encode(english, "UTF-8") + "&source=en&target=" + language);
        CharSequence translateResult = StringsResourceTranslator.fetch(translateURL);
        Matcher m2 = TRANSLATE_RESPONSE_PATTERN.matcher(translateResult);
        if (!m2.find()) {
            System.err.println("No translate result");
            System.err.println(translateResult);
            return english;
        }
        String translation = m2.group(1);
        System.out.println("  Got translation " + translation);
        translation = translation.replaceAll("\\\\u0026quot;", "\"");
        translation = translation.replaceAll("\\\\u0026#39;", "'");
        translation = translation.replaceAll("\\\\u200b", "");
        translation = translation.replaceAll("&amp;quot;", "\"");
        translation = translation.replaceAll("&amp;#39;", "'");
        return translation;
    }

    private static CharSequence fetch(URL translateURL) throws IOException {
        URLConnection connection = translateURL.openConnection();
        connection.connect();
        StringBuilder translateResult = new StringBuilder(200);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), UTF8));){
            int charsRead;
            char[] buffer = new char[1024];
            while ((charsRead = in.read(buffer)) > 0) {
                translateResult.append(buffer, 0, charsRead);
            }
        }
        return translateResult;
    }

    private static SortedMap<String, String> readLines(File file) throws IOException {
        TreeMap<String, String> entries = new TreeMap<String, String>();
        if (!file.exists()) {
            return entries;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), UTF8));){
            String line;
            while ((line = reader.readLine()) != null) {
                Matcher m2 = ENTRY_PATTERN.matcher(line);
                if (!m2.find()) continue;
                String key = m2.group(1);
                String value = m2.group(2);
                entries.put(key, value);
            }
            TreeMap<String, String> treeMap = entries;
            return treeMap;
        }
    }

    static {
        LANGUAGE_CODE_MASSAGINGS.put("zh-rCN", "zh-cn");
        LANGUAGE_CODE_MASSAGINGS.put("zh-rTW", "zh-tw");
    }
}

