/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.client.j2se.Config;
import com.google.zxing.client.j2se.DecodeWorker;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;

public final class CommandLineRunner {
    private static final Pattern COMMA = Pattern.compile(",");

    private CommandLineRunner() {
    }

    public static void main(String[] args) throws Exception {
        int total;
        if (args.length == 0) {
            CommandLineRunner.printUsage();
            return;
        }
        Config config = new Config();
        ConcurrentLinkedQueue<String> inputs = new ConcurrentLinkedQueue<String>();
        block24: for (String arg : args) {
            String[] argValue = arg.split("=");
            switch (argValue[0]) {
                case "--try_harder": {
                    config.setTryHarder(true);
                    continue block24;
                }
                case "--pure_barcode": {
                    config.setPureBarcode(true);
                    continue block24;
                }
                case "--products_only": {
                    config.setProductsOnly(true);
                    continue block24;
                }
                case "--dump_results": {
                    config.setDumpResults(true);
                    continue block24;
                }
                case "--dump_black_point": {
                    config.setDumpBlackPoint(true);
                    continue block24;
                }
                case "--multi": {
                    config.setMulti(true);
                    continue block24;
                }
                case "--brief": {
                    config.setBrief(true);
                    continue block24;
                }
                case "--recursive": {
                    config.setRecursive(true);
                    continue block24;
                }
                case "--crop": {
                    int[] crop = new int[4];
                    String[] tokens = COMMA.split(argValue[1]);
                    for (int i2 = 0; i2 < crop.length; ++i2) {
                        crop[i2] = Integer.parseInt(tokens[i2]);
                    }
                    config.setCrop(crop);
                    continue block24;
                }
                case "--possibleFormats": {
                    config.setPossibleFormats(COMMA.split(argValue[1]));
                    continue block24;
                }
                default: {
                    if (arg.startsWith("-")) {
                        System.err.println("Unknown command line option " + arg);
                        CommandLineRunner.printUsage();
                        return;
                    }
                    CommandLineRunner.addArgumentToInputs(arg, config, inputs);
                }
            }
        }
        config.setHints(CommandLineRunner.buildHints(config));
        int numThreads = Math.min(inputs.size(), Runtime.getRuntime().availableProcessors());
        int successful = 0;
        if (numThreads > 1) {
            ExecutorService executor = Executors.newFixedThreadPool(numThreads);
            ArrayList<Future<Integer>> futures = new ArrayList<Future<Integer>>(numThreads);
            for (int x2 = 0; x2 < numThreads; ++x2) {
                futures.add(executor.submit(new DecodeWorker(config, inputs)));
            }
            executor.shutdown();
            for (Future future : futures) {
                successful += ((Integer)future.get()).intValue();
            }
        } else {
            successful += new DecodeWorker(config, inputs).call().intValue();
        }
        if ((total = inputs.size()) > 1) {
            System.out.println("\nDecoded " + successful + " files out of " + total + " successfully (" + successful * 100 / total + "%)\n");
        }
    }

    private static void addArgumentToInputs(String argument, Config config, Queue<String> inputs) throws IOException {
        File inputFile = new File(argument);
        if (inputFile.exists()) {
            if (inputFile.isDirectory()) {
                for (File singleFile : inputFile.listFiles()) {
                    String filename = singleFile.getName().toLowerCase(Locale.ENGLISH);
                    if (filename.startsWith(".")) continue;
                    if (singleFile.isDirectory()) {
                        if (!config.isRecursive()) continue;
                        CommandLineRunner.addArgumentToInputs(singleFile.getAbsolutePath(), config, inputs);
                        continue;
                    }
                    if (filename.endsWith(".txt") || filename.contains(".mono.png")) continue;
                    inputs.add(singleFile.getCanonicalPath());
                }
            } else {
                inputs.add(inputFile.getCanonicalPath());
            }
        } else {
            inputs.add(argument);
        }
    }

    private static Map<DecodeHintType, ?> buildHints(Config config) {
        ArrayList<BarcodeFormat> possibleFormats = new ArrayList<BarcodeFormat>();
        String[] possibleFormatsNames = config.getPossibleFormats();
        if (possibleFormatsNames != null && possibleFormatsNames.length > 0) {
            for (String format : possibleFormatsNames) {
                possibleFormats.add(BarcodeFormat.valueOf(format));
            }
        } else {
            possibleFormats.add(BarcodeFormat.UPC_A);
            possibleFormats.add(BarcodeFormat.UPC_E);
            possibleFormats.add(BarcodeFormat.EAN_13);
            possibleFormats.add(BarcodeFormat.EAN_8);
            possibleFormats.add(BarcodeFormat.RSS_14);
            possibleFormats.add(BarcodeFormat.RSS_EXPANDED);
            if (!config.isProductsOnly()) {
                possibleFormats.add(BarcodeFormat.CODE_39);
                possibleFormats.add(BarcodeFormat.CODE_93);
                possibleFormats.add(BarcodeFormat.CODE_128);
                possibleFormats.add(BarcodeFormat.ITF);
                possibleFormats.add(BarcodeFormat.QR_CODE);
                possibleFormats.add(BarcodeFormat.DATA_MATRIX);
                possibleFormats.add(BarcodeFormat.AZTEC);
                possibleFormats.add(BarcodeFormat.PDF_417);
                possibleFormats.add(BarcodeFormat.CODABAR);
                possibleFormats.add(BarcodeFormat.MAXICODE);
            }
        }
        EnumMap<DecodeHintType, Serializable> hints = new EnumMap<DecodeHintType, Serializable>(DecodeHintType.class);
        hints.put(DecodeHintType.POSSIBLE_FORMATS, possibleFormats);
        if (config.isTryHarder()) {
            hints.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
        }
        if (config.isPureBarcode()) {
            hints.put(DecodeHintType.PURE_BARCODE, Boolean.TRUE);
        }
        return hints;
    }

    private static void printUsage() {
        System.err.println("Decode barcode images using the ZXing library");
        System.err.println();
        System.err.println("usage: CommandLineRunner { file | dir | url } [ options ]");
        System.err.println("  --try_harder: Use the TRY_HARDER hint, default is normal (mobile) mode");
        System.err.println("  --pure_barcode: Input image is a pure monochrome barcode image, not a photo");
        System.err.println("  --products_only: Only decode the UPC and EAN families of barcodes");
        System.err.println("  --dump_results: Write the decoded contents to input.txt");
        System.err.println("  --dump_black_point: Compare black point algorithms as input.mono.png");
        System.err.println("  --multi: Scans image for multiple barcodes");
        System.err.println("  --brief: Only output one line per file, omitting the contents");
        System.err.println("  --recursive: Descend into subdirectories");
        System.err.println("  --crop=left,top,width,height: Only examine cropped region of input image(s)");
        StringBuilder builder = new StringBuilder();
        builder.append("  --possibleFormats=barcodeFormat[,barcodeFormat2...] where barcodeFormat is any of: ");
        for (BarcodeFormat format : BarcodeFormat.values()) {
            builder.append((Object)format).append(',');
        }
        builder.setLength(builder.length() - 1);
        System.err.println(builder);
    }
}

