/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.Config;
import com.google.zxing.client.j2se.ImageReader;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ResultParser;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.multi.GenericMultipleBarcodeReader;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import javax.imageio.ImageIO;

final class DecodeWorker
implements Callable<Integer> {
    private static final Charset UTF8 = Charset.forName("UTF8");
    private final Config config;
    private final Queue<String> inputs;

    DecodeWorker(Config config, Queue<String> inputs) {
        this.config = config;
        this.inputs = inputs;
    }

    @Override
    public Integer call() throws IOException {
        String input;
        int successful = 0;
        while ((input = this.inputs.poll()) != null) {
            File inputFile = new File(input);
            if (inputFile.exists()) {
                if (this.config.isMulti()) {
                    Result[] results = this.decodeMulti(inputFile.toURI(), this.config.getHints());
                    if (results == null) continue;
                    ++successful;
                    if (!this.config.isDumpResults()) continue;
                    DecodeWorker.dumpResultMulti(inputFile, results);
                    continue;
                }
                Result result = this.decode(inputFile.toURI(), this.config.getHints());
                if (result == null) continue;
                ++successful;
                if (!this.config.isDumpResults()) continue;
                DecodeWorker.dumpResult(inputFile, result);
                continue;
            }
            if (this.decode(URI.create(input), this.config.getHints()) == null) continue;
            ++successful;
        }
        return successful;
    }

    private static void dumpResult(File input, Result result) throws IOException {
        String name = input.getCanonicalPath();
        int pos = name.lastIndexOf(46);
        if (pos > 0) {
            name = name.substring(0, pos);
        }
        File dump = new File(name + ".txt");
        DecodeWorker.writeStringToFile(result.getText(), dump);
    }

    private static void dumpResultMulti(File input, Result[] results) throws IOException {
        String name = input.getCanonicalPath();
        int pos = name.lastIndexOf(46);
        if (pos > 0) {
            name = name.substring(0, pos);
        }
        File dump = new File(name + ".txt");
        DecodeWorker.writeResultsToFile(results, dump);
    }

    private static void writeStringToFile(String value, File file) throws IOException {
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), UTF8);){
            out.write(value);
        }
    }

    private static void writeResultsToFile(Result[] results, File file) throws IOException {
        String newline = System.getProperty("line.separator");
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), UTF8);){
            for (Result result : results) {
                out.write(result.getText());
                out.write(newline);
            }
        }
    }

    private Result decode(URI uri, Map<DecodeHintType, ?> hints) throws IOException {
        BufferedImage image = ImageReader.readImage(uri);
        try {
            BufferedImageLuminanceSource source;
            if (this.config.getCrop() == null) {
                source = new BufferedImageLuminanceSource(image);
            } else {
                int[] crop = this.config.getCrop();
                source = new BufferedImageLuminanceSource(image, crop[0], crop[1], crop[2], crop[3]);
            }
            BinaryBitmap bitmap = new BinaryBitmap(new HybridBinarizer(source));
            if (this.config.isDumpBlackPoint()) {
                DecodeWorker.dumpBlackPoint(uri, image, bitmap);
            }
            Result result = new MultiFormatReader().decode(bitmap, hints);
            if (this.config.isBrief()) {
                System.out.println(uri.toString() + ": Success");
            } else {
                ParsedResult parsedResult = ResultParser.parseResult(result);
                System.out.println(uri.toString() + " (format: " + (Object)((Object)result.getBarcodeFormat()) + ", type: " + (Object)((Object)parsedResult.getType()) + "):\nRaw result:\n" + result.getText() + "\nParsed result:\n" + parsedResult.getDisplayResult());
                System.out.println("Found " + result.getResultPoints().length + " result points.");
                for (int i2 = 0; i2 < result.getResultPoints().length; ++i2) {
                    ResultPoint rp = result.getResultPoints()[i2];
                    if (rp == null) continue;
                    System.out.println("  Point " + i2 + ": (" + rp.getX() + ',' + rp.getY() + ')');
                }
            }
            return result;
        }
        catch (NotFoundException ignored) {
            System.out.println(uri.toString() + ": No barcode found");
            return null;
        }
    }

    private Result[] decodeMulti(URI uri, Map<DecodeHintType, ?> hints) throws IOException {
        BufferedImage image = ImageReader.readImage(uri);
        try {
            BufferedImageLuminanceSource source;
            if (this.config.getCrop() == null) {
                source = new BufferedImageLuminanceSource(image);
            } else {
                int[] crop = this.config.getCrop();
                source = new BufferedImageLuminanceSource(image, crop[0], crop[1], crop[2], crop[3]);
            }
            BinaryBitmap bitmap = new BinaryBitmap(new HybridBinarizer(source));
            if (this.config.isDumpBlackPoint()) {
                DecodeWorker.dumpBlackPoint(uri, image, bitmap);
            }
            MultiFormatReader multiFormatReader = new MultiFormatReader();
            GenericMultipleBarcodeReader reader = new GenericMultipleBarcodeReader(multiFormatReader);
            Result[] results = reader.decodeMultiple(bitmap, hints);
            if (this.config.isBrief()) {
                System.out.println(uri.toString() + ": Success");
            } else {
                for (Result result : results) {
                    ParsedResult parsedResult = ResultParser.parseResult(result);
                    System.out.println(uri.toString() + " (format: " + (Object)((Object)result.getBarcodeFormat()) + ", type: " + (Object)((Object)parsedResult.getType()) + "):\nRaw result:\n" + result.getText() + "\nParsed result:\n" + parsedResult.getDisplayResult());
                    System.out.println("Found " + result.getResultPoints().length + " result points.");
                    for (int i2 = 0; i2 < result.getResultPoints().length; ++i2) {
                        ResultPoint rp = result.getResultPoints()[i2];
                        System.out.println("  Point " + i2 + ": (" + rp.getX() + ',' + rp.getY() + ')');
                    }
                }
            }
            return results;
        }
        catch (NotFoundException ignored) {
            System.out.println(uri.toString() + ": No barcode found");
            return null;
        }
    }

    private static void dumpBlackPoint(URI uri, BufferedImage image, BinaryBitmap bitmap) {
        int x2;
        int offset;
        int y;
        String inputName = uri.getPath();
        if (inputName.contains(".mono.png")) {
            return;
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int stride = width * 3;
        int[] pixels = new int[stride * height];
        int[] argb = new int[width];
        for (int y2 = 0; y2 < height; ++y2) {
            image.getRGB(0, y2, width, 1, argb, 0, width);
            System.arraycopy(argb, 0, pixels, y2 * stride, width);
        }
        BitArray row = new BitArray(width);
        for (y = 0; y < height; ++y) {
            try {
                row = bitmap.getBlackRow(y, row);
            }
            catch (NotFoundException nfe) {
                offset = y * stride + width;
                for (x2 = 0; x2 < width; ++x2) {
                    pixels[offset + x2] = -65536;
                }
                continue;
            }
            int offset2 = y * stride + width;
            for (int x3 = 0; x3 < width; ++x3) {
                pixels[offset2 + x3] = row.get(x3) ? -16777216 : -1;
            }
        }
        try {
            for (y = 0; y < height; ++y) {
                BitMatrix matrix = bitmap.getBlackMatrix();
                offset = y * stride + width * 2;
                for (x2 = 0; x2 < width; ++x2) {
                    pixels[offset + x2] = matrix.get(x2, y) ? -16777216 : -1;
                }
            }
        }
        catch (NotFoundException ignored) {
            // empty catch block
        }
        DecodeWorker.writeResultImage(stride, height, pixels, uri, inputName, ".mono.png");
    }

    private static void writeResultImage(int stride, int height, int[] pixels, URI uri, String inputName, String suffix) {
        int pos;
        BufferedImage result = new BufferedImage(stride, height, 2);
        result.setRGB(0, 0, stride, height, pixels, 0, stride);
        String resultName = inputName;
        if ("http".equals(uri.getScheme()) && (pos = resultName.lastIndexOf(47)) > 0) {
            resultName = '.' + resultName.substring(pos);
        }
        if ((pos = resultName.lastIndexOf(46)) > 0) {
            resultName = resultName.substring(0, pos);
        }
        resultName = resultName + suffix;
        try (FileOutputStream outStream = new FileOutputStream(resultName);){
            if (!ImageIO.write((RenderedImage)result, "png", outStream)) {
                System.err.println("Could not encode an image to " + resultName);
            }
        }
        catch (IOException ignored) {
            System.err.println("Could not write to " + resultName);
        }
    }
}

