/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.decoder;

import com.google.zxing.common.BitMatrix;

abstract class DataMask {
    private static final DataMask[] DATA_MASKS = new DataMask[]{new DataMask000(), new DataMask001(), new DataMask010(), new DataMask011(), new DataMask100(), new DataMask101(), new DataMask110(), new DataMask111()};

    private DataMask() {
    }

    final void unmaskBitMatrix(BitMatrix bits, int dimension) {
        for (int i2 = 0; i2 < dimension; ++i2) {
            for (int j2 = 0; j2 < dimension; ++j2) {
                if (!this.isMasked(i2, j2)) continue;
                bits.flip(j2, i2);
            }
        }
    }

    abstract boolean isMasked(int var1, int var2);

    static DataMask forReference(int reference) {
        if (reference < 0 || reference > 7) {
            throw new IllegalArgumentException();
        }
        return DATA_MASKS[reference];
    }

    private static final class DataMask111
    extends DataMask {
        private DataMask111() {
        }

        @Override
        boolean isMasked(int i2, int j2) {
            return ((i2 + j2 & 1) + i2 * j2 % 3 & 1) == 0;
        }
    }

    private static final class DataMask110
    extends DataMask {
        private DataMask110() {
        }

        @Override
        boolean isMasked(int i2, int j2) {
            int temp = i2 * j2;
            return ((temp & 1) + temp % 3 & 1) == 0;
        }
    }

    private static final class DataMask101
    extends DataMask {
        private DataMask101() {
        }

        @Override
        boolean isMasked(int i2, int j2) {
            int temp = i2 * j2;
            return (temp & 1) + temp % 3 == 0;
        }
    }

    private static final class DataMask100
    extends DataMask {
        private DataMask100() {
        }

        @Override
        boolean isMasked(int i2, int j2) {
            return ((i2 >>> 1) + j2 / 3 & 1) == 0;
        }
    }

    private static final class DataMask011
    extends DataMask {
        private DataMask011() {
        }

        @Override
        boolean isMasked(int i2, int j2) {
            return (i2 + j2) % 3 == 0;
        }
    }

    private static final class DataMask010
    extends DataMask {
        private DataMask010() {
        }

        @Override
        boolean isMasked(int i2, int j2) {
            return j2 % 3 == 0;
        }
    }

    private static final class DataMask001
    extends DataMask {
        private DataMask001() {
        }

        @Override
        boolean isMasked(int i2, int j2) {
            return (i2 & 1) == 0;
        }
    }

    private static final class DataMask000
    extends DataMask {
        private DataMask000() {
        }

        @Override
        boolean isMasked(int i2, int j2) {
            return (i2 + j2 & 1) == 0;
        }
    }
}

