/*
 * Decompiled with CFR 0.152.
 */
package com.hp.gagawa.java;

import com.hp.gagawa.java.attributes.Attribute;
import java.util.ArrayList;

public abstract class Node {
    protected String tag_;
    protected ArrayList<Attribute> attributes_;
    protected Node parent_;

    protected Node(String string) {
        this.tag_ = string;
        this.attributes_ = new ArrayList();
    }

    public Node getParent() {
        return this.parent_;
    }

    public void setAttribute(String string, String string2) {
        if (string2 != null) {
            for (Attribute attribute : this.attributes_) {
                if (!attribute.getName().equals(string)) continue;
                attribute.setValue(string2);
                return;
            }
            this.attributes_.add(new Attribute(string, string2));
        }
    }

    public String getAttribute(String string) {
        for (Attribute attribute : this.attributes_) {
            if (!attribute.getName().equals(string)) continue;
            return attribute.getValue();
        }
        return null;
    }

    public boolean removeAttribute(String string) {
        for (Attribute attribute : this.attributes_) {
            if (!attribute.getName().equals(string)) continue;
            return this.attributes_.remove(attribute);
        }
        return false;
    }

    public void setParent(Node node) {
        this.parent_ = node;
    }

    public String write() {
        StringBuffer stringBuffer = new StringBuffer(this.writeOpen());
        stringBuffer.append(this.writeClose());
        return stringBuffer.toString();
    }

    protected String writeOpen() {
        StringBuffer stringBuffer = new StringBuffer("<");
        stringBuffer.append(this.tag_);
        for (Attribute attribute : this.attributes_) {
            stringBuffer.append(attribute.write());
        }
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    protected String writeClose() {
        StringBuffer stringBuffer = new StringBuffer("</");
        stringBuffer.append(this.tag_);
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

