/*
 * Decompiled with CFR 0.152.
 */
package com.hp.gagawa.java.elements;

import com.hp.gagawa.java.FertileNode;
import com.hp.gagawa.java.Node;
import com.hp.gagawa.java.elements.Text;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Comment
extends FertileNode {
    public Comment() {
        super("!--");
    }

    public Comment(String string) {
        this();
        this.appendText(string);
    }

    @Override
    public String write() {
        StringBuilder stringBuilder = new StringBuilder("<!-- >");
        if (this.children != null && this.children.size() > 0) {
            for (Node node : this.children) {
                stringBuilder.append(node.write());
            }
        }
        stringBuilder.append("< -->");
        return stringBuilder.toString();
    }

    public Comment appendChild(Node node) {
        if (this == node) {
            throw new Error("Cannot append a node to itself.");
        }
        node.setParent(this);
        this.children.add(node);
        return this;
    }

    public Comment appendChild(int n2, Node node) {
        if (this == node) {
            throw new Error("Cannot append a node to itself.");
        }
        node.setParent(this);
        this.children.add(n2, node);
        return this;
    }

    public Comment appendChild(List<Node> list) {
        if (list != null) {
            for (Node node : list) {
                this.appendChild(node);
            }
        }
        return this;
    }

    public Comment appendChild(Node ... nodeArray) {
        for (int i2 = 0; i2 < nodeArray.length; ++i2) {
            this.appendChild(nodeArray[i2]);
        }
        return this;
    }

    public Comment appendText(String string) {
        return this.appendChild((Node)new Text(string));
    }

    public Comment removeChild(Node node) {
        this.children.remove(node);
        return this;
    }

    public Comment removeChildren() {
        this.children.clear();
        return this;
    }
}

