/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.awt.geom;

import com.itextpdf.awt.geom.PolylineShapeIterator;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class PolylineShape
implements Shape {
    protected int[] x;
    protected int[] y;
    protected int np;

    public PolylineShape(int[] x2, int[] y, int nPoints) {
        this.np = nPoints;
        this.x = new int[this.np];
        this.y = new int[this.np];
        System.arraycopy(x2, 0, this.x, 0, this.np);
        System.arraycopy(y, 0, this.y, 0, this.np);
    }

    public Rectangle2D getBounds2D() {
        int[] r2 = this.rect();
        return r2 == null ? null : new Rectangle2D.Double(r2[0], r2[1], r2[2], r2[3]);
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    private int[] rect() {
        if (this.np == 0) {
            return null;
        }
        int xMin = this.x[0];
        int yMin = this.y[0];
        int xMax = this.x[0];
        int yMax = this.y[0];
        for (int i2 = 1; i2 < this.np; ++i2) {
            if (this.x[i2] < xMin) {
                xMin = this.x[i2];
            } else if (this.x[i2] > xMax) {
                xMax = this.x[i2];
            }
            if (this.y[i2] < yMin) {
                yMin = this.y[i2];
                continue;
            }
            if (this.y[i2] <= yMax) continue;
            yMax = this.y[i2];
        }
        return new int[]{xMin, yMin, xMax - xMin, yMax - yMin};
    }

    public boolean contains(double x2, double y) {
        return false;
    }

    public boolean contains(Point2D p2) {
        return false;
    }

    public boolean contains(double x2, double y, double w2, double h2) {
        return false;
    }

    public boolean contains(Rectangle2D r2) {
        return false;
    }

    public boolean intersects(double x2, double y, double w2, double h2) {
        return this.intersects(new Rectangle2D.Double(x2, y, w2, h2));
    }

    public boolean intersects(Rectangle2D r2) {
        if (this.np == 0) {
            return false;
        }
        Line2D.Double line = new Line2D.Double(this.x[0], this.y[0], this.x[0], this.y[0]);
        for (int i2 = 1; i2 < this.np; ++i2) {
            ((Line2D)line).setLine(this.x[i2 - 1], this.y[i2 - 1], this.x[i2], this.y[i2]);
            if (!line.intersects(r2)) continue;
            return true;
        }
        return false;
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return new PolylineShapeIterator(this, at);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new PolylineShapeIterator(this, at);
    }
}

