/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.awt.geom;

import com.itextpdf.awt.geom.AffineTransform;
import com.itextpdf.awt.geom.Line2D;
import com.itextpdf.awt.geom.PathIterator;
import com.itextpdf.awt.geom.Point2D;
import com.itextpdf.awt.geom.RectangularShape;
import com.itextpdf.awt.geom.misc.HashCode;
import com.itextpdf.awt.geom.misc.Messages;
import java.util.NoSuchElementException;

public abstract class Rectangle2D
extends RectangularShape {
    public static final int OUT_LEFT = 1;
    public static final int OUT_TOP = 2;
    public static final int OUT_RIGHT = 4;
    public static final int OUT_BOTTOM = 8;

    protected Rectangle2D() {
    }

    public abstract void setRect(double var1, double var3, double var5, double var7);

    public abstract int outcode(double var1, double var3);

    public abstract Rectangle2D createIntersection(Rectangle2D var1);

    public abstract Rectangle2D createUnion(Rectangle2D var1);

    public void setRect(Rectangle2D r2) {
        this.setRect(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight());
    }

    public void setFrame(double x2, double y, double width, double height) {
        this.setRect(x2, y, width, height);
    }

    public Rectangle2D getBounds2D() {
        return (Rectangle2D)this.clone();
    }

    public boolean intersectsLine(double x1, double y1, double x2, double y2) {
        double rx1 = this.getX();
        double ry1 = this.getY();
        double rx2 = rx1 + this.getWidth();
        double ry2 = ry1 + this.getHeight();
        return rx1 <= x1 && x1 <= rx2 && ry1 <= y1 && y1 <= ry2 || rx1 <= x2 && x2 <= rx2 && ry1 <= y2 && y2 <= ry2 || Line2D.linesIntersect(rx1, ry1, rx2, ry2, x1, y1, x2, y2) || Line2D.linesIntersect(rx2, ry1, rx1, ry2, x1, y1, x2, y2);
    }

    public boolean intersectsLine(Line2D l2) {
        return this.intersectsLine(l2.getX1(), l2.getY1(), l2.getX2(), l2.getY2());
    }

    public int outcode(Point2D p2) {
        return this.outcode(p2.getX(), p2.getY());
    }

    public boolean contains(double x2, double y) {
        if (this.isEmpty()) {
            return false;
        }
        double x1 = this.getX();
        double y1 = this.getY();
        double x22 = x1 + this.getWidth();
        double y2 = y1 + this.getHeight();
        return x1 <= x2 && x2 < x22 && y1 <= y && y < y2;
    }

    public boolean intersects(double x2, double y, double width, double height) {
        if (this.isEmpty() || width <= 0.0 || height <= 0.0) {
            return false;
        }
        double x1 = this.getX();
        double y1 = this.getY();
        double x22 = x1 + this.getWidth();
        double y2 = y1 + this.getHeight();
        return x2 + width > x1 && x2 < x22 && y + height > y1 && y < y2;
    }

    public boolean contains(double x2, double y, double width, double height) {
        if (this.isEmpty() || width <= 0.0 || height <= 0.0) {
            return false;
        }
        double x1 = this.getX();
        double y1 = this.getY();
        double x22 = x1 + this.getWidth();
        double y2 = y1 + this.getHeight();
        return x1 <= x2 && x2 + width <= x22 && y1 <= y && y + height <= y2;
    }

    public static void intersect(Rectangle2D src1, Rectangle2D src2, Rectangle2D dst) {
        double x1 = Math.max(src1.getMinX(), src2.getMinX());
        double y1 = Math.max(src1.getMinY(), src2.getMinY());
        double x2 = Math.min(src1.getMaxX(), src2.getMaxX());
        double y2 = Math.min(src1.getMaxY(), src2.getMaxY());
        dst.setFrame(x1, y1, x2 - x1, y2 - y1);
    }

    public static void union(Rectangle2D src1, Rectangle2D src2, Rectangle2D dst) {
        double x1 = Math.min(src1.getMinX(), src2.getMinX());
        double y1 = Math.min(src1.getMinY(), src2.getMinY());
        double x2 = Math.max(src1.getMaxX(), src2.getMaxX());
        double y2 = Math.max(src1.getMaxY(), src2.getMaxY());
        dst.setFrame(x1, y1, x2 - x1, y2 - y1);
    }

    public void add(double x2, double y) {
        double x1 = Math.min(this.getMinX(), x2);
        double y1 = Math.min(this.getMinY(), y);
        double x22 = Math.max(this.getMaxX(), x2);
        double y2 = Math.max(this.getMaxY(), y);
        this.setRect(x1, y1, x22 - x1, y2 - y1);
    }

    public void add(Point2D p2) {
        this.add(p2.getX(), p2.getY());
    }

    public void add(Rectangle2D r2) {
        Rectangle2D.union(this, r2, this);
    }

    public PathIterator getPathIterator(AffineTransform t2) {
        return new Iterator(this, t2);
    }

    public PathIterator getPathIterator(AffineTransform t2, double flatness) {
        return new Iterator(this, t2);
    }

    public int hashCode() {
        HashCode hash = new HashCode();
        hash.append(this.getX());
        hash.append(this.getY());
        hash.append(this.getWidth());
        hash.append(this.getHeight());
        return hash.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Rectangle2D) {
            Rectangle2D r2 = (Rectangle2D)obj;
            return this.getX() == r2.getX() && this.getY() == r2.getY() && this.getWidth() == r2.getWidth() && this.getHeight() == r2.getHeight();
        }
        return false;
    }

    class Iterator
    implements PathIterator {
        double x;
        double y;
        double width;
        double height;
        AffineTransform t;
        int index;

        Iterator(Rectangle2D r2, AffineTransform at) {
            this.x = r2.getX();
            this.y = r2.getY();
            this.width = r2.getWidth();
            this.height = r2.getHeight();
            this.t = at;
            if (this.width < 0.0 || this.height < 0.0) {
                this.index = 6;
            }
        }

        public int getWindingRule() {
            return 1;
        }

        public boolean isDone() {
            return this.index > 5;
        }

        public void next() {
            ++this.index;
        }

        public int currentSegment(double[] coords) {
            int type;
            if (this.isDone()) {
                throw new NoSuchElementException(Messages.getString("awt.4B"));
            }
            if (this.index == 5) {
                return 4;
            }
            if (this.index == 0) {
                type = 0;
                coords[0] = this.x;
                coords[1] = this.y;
            } else {
                type = 1;
                switch (this.index) {
                    case 1: {
                        coords[0] = this.x + this.width;
                        coords[1] = this.y;
                        break;
                    }
                    case 2: {
                        coords[0] = this.x + this.width;
                        coords[1] = this.y + this.height;
                        break;
                    }
                    case 3: {
                        coords[0] = this.x;
                        coords[1] = this.y + this.height;
                        break;
                    }
                    case 4: {
                        coords[0] = this.x;
                        coords[1] = this.y;
                    }
                }
            }
            if (this.t != null) {
                this.t.transform(coords, 0, coords, 0, 1);
            }
            return type;
        }

        public int currentSegment(float[] coords) {
            int type;
            if (this.isDone()) {
                throw new NoSuchElementException(Messages.getString("awt.4B"));
            }
            if (this.index == 5) {
                return 4;
            }
            if (this.index == 0) {
                coords[0] = (float)this.x;
                coords[1] = (float)this.y;
                type = 0;
            } else {
                type = 1;
                switch (this.index) {
                    case 1: {
                        coords[0] = (float)(this.x + this.width);
                        coords[1] = (float)this.y;
                        break;
                    }
                    case 2: {
                        coords[0] = (float)(this.x + this.width);
                        coords[1] = (float)(this.y + this.height);
                        break;
                    }
                    case 3: {
                        coords[0] = (float)this.x;
                        coords[1] = (float)(this.y + this.height);
                        break;
                    }
                    case 4: {
                        coords[0] = (float)this.x;
                        coords[1] = (float)this.y;
                    }
                }
            }
            if (this.t != null) {
                this.t.transform(coords, 0, coords, 0, 1);
            }
            return type;
        }
    }

    public static class Double
    extends Rectangle2D {
        public double x;
        public double y;
        public double width;
        public double height;

        public Double() {
        }

        public Double(double x2, double y, double width, double height) {
            this.setRect(x2, y, width, height);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return this.width <= 0.0 || this.height <= 0.0;
        }

        public void setRect(double x2, double y, double width, double height) {
            this.x = x2;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public void setRect(Rectangle2D r2) {
            this.x = r2.getX();
            this.y = r2.getY();
            this.width = r2.getWidth();
            this.height = r2.getHeight();
        }

        public int outcode(double px, double py) {
            int code = 0;
            if (this.width <= 0.0) {
                code |= 5;
            } else if (px < this.x) {
                code |= 1;
            } else if (px > this.x + this.width) {
                code |= 4;
            }
            if (this.height <= 0.0) {
                code |= 0xA;
            } else if (py < this.y) {
                code |= 2;
            } else if (py > this.y + this.height) {
                code |= 8;
            }
            return code;
        }

        public Rectangle2D getBounds2D() {
            return new Double(this.x, this.y, this.width, this.height);
        }

        public Rectangle2D createIntersection(Rectangle2D r2) {
            Double dst = new Double();
            Rectangle2D.intersect(this, r2, dst);
            return dst;
        }

        public Rectangle2D createUnion(Rectangle2D r2) {
            Double dest = new Double();
            Rectangle2D.union(this, r2, dest);
            return dest;
        }

        public String toString() {
            return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
        }
    }

    public static class Float
    extends Rectangle2D {
        public float x;
        public float y;
        public float width;
        public float height;

        public Float() {
        }

        public Float(float x2, float y, float width, float height) {
            this.setRect(x2, y, width, height);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return this.width <= 0.0f || this.height <= 0.0f;
        }

        public void setRect(float x2, float y, float width, float height) {
            this.x = x2;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public void setRect(double x2, double y, double width, double height) {
            this.x = (float)x2;
            this.y = (float)y;
            this.width = (float)width;
            this.height = (float)height;
        }

        public void setRect(Rectangle2D r2) {
            this.x = (float)r2.getX();
            this.y = (float)r2.getY();
            this.width = (float)r2.getWidth();
            this.height = (float)r2.getHeight();
        }

        public int outcode(double px, double py) {
            int code = 0;
            if (this.width <= 0.0f) {
                code |= 5;
            } else if (px < (double)this.x) {
                code |= 1;
            } else if (px > (double)(this.x + this.width)) {
                code |= 4;
            }
            if (this.height <= 0.0f) {
                code |= 0xA;
            } else if (py < (double)this.y) {
                code |= 2;
            } else if (py > (double)(this.y + this.height)) {
                code |= 8;
            }
            return code;
        }

        public Rectangle2D getBounds2D() {
            return new Float(this.x, this.y, this.width, this.height);
        }

        public Rectangle2D createIntersection(Rectangle2D r2) {
            Rectangle2D dst = r2 instanceof Double ? new Double() : new Float();
            Rectangle2D.intersect(this, r2, dst);
            return dst;
        }

        public Rectangle2D createUnion(Rectangle2D r2) {
            Rectangle2D dst = r2 instanceof Double ? new Double() : new Float();
            Rectangle2D.union(this, r2, dst);
            return dst;
        }

        public String toString() {
            return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
        }
    }
}

