/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.rups.view.itext;

import com.itextpdf.rups.view.contextmenu.ContextMenuMouseListener;
import com.itextpdf.rups.view.contextmenu.StreamPanelContextMenu;
import com.itextpdf.rups.view.itext.ColorTextPane;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.exceptions.InvalidPdfException;
import com.itextpdf.text.io.RandomAccessSourceFactory;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PRTokeniser;
import com.itextpdf.text.pdf.PdfContentParser;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import com.itextpdf.text.pdf.parser.PdfImageObject;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class SyntaxHighlightedStreamPane
extends JScrollPane
implements Observer {
    protected ColorTextPane text;
    protected static Map<String, Map<Object, Object>> attributemap = null;
    protected static boolean matchingOperands = false;
    protected static final RandomAccessSourceFactory RASF = new RandomAccessSourceFactory();
    private static final long serialVersionUID = -3699893393067753664L;

    public SyntaxHighlightedStreamPane() {
        this.initAttributes();
        this.text = new ColorTextPane();
        this.setViewportView(this.text);
        JPopupMenu popupMenu = StreamPanelContextMenu.getContextMenu(this.text);
        this.text.add(popupMenu);
        this.text.addMouseListener(new ContextMenuMouseListener(popupMenu, this.text));
    }

    public void update(Observable observable, Object obj) {
        this.text.setText(null);
    }

    public void render(PdfObject object) {
        PRStream stream;
        if (object instanceof PRStream && (stream = (PRStream)object).get(PdfName.SUBTYPE) != PdfName.IMAGE && stream.get(PdfName.LENGTH1) == null) {
            String newline = "\n";
            byte[] bb = null;
            try {
                this.text.setText("");
                bb = PdfReader.getStreamBytes(stream);
                PRTokeniser tokeniser = new PRTokeniser(new RandomAccessFileOrArray(RASF.createSource(bb)));
                PdfContentParser ps = new PdfContentParser(tokeniser);
                ArrayList<PdfObject> tokens = new ArrayList<PdfObject>();
                while (ps.parse(tokens).size() > 0) {
                    String operator = tokens.get(tokens.size() - 1).toString();
                    StringBuilder operandssb = new StringBuilder();
                    for (int i2 = 0; i2 < tokens.size() - 1; ++i2) {
                        this.append(operandssb, tokens.get(i2));
                    }
                    String operands = operandssb.toString();
                    Map<Object, Object> attributes = attributemap.get(operator);
                    Map<Object, Object> attributesOperands = null;
                    if (matchingOperands) {
                        attributesOperands = attributes;
                    }
                    this.text.append(operands, attributesOperands);
                    this.text.append(operator + newline, attributes);
                }
            }
            catch (InvalidPdfException e2) {
                this.text.setText(new String(bb));
            }
            catch (IOException e3) {
                throw new ExceptionConverter(e3);
            }
            this.text.setCaretPosition(0);
        }
        if (object.type() == 7) {
            stream = (PRStream)object;
            if (stream.get(PdfName.SUBTYPE) == PdfName.IMAGE) {
                try {
                    if (!stream.get(PdfName.WIDTH).isNumber() && !stream.get(PdfName.HEIGHT).isNumber()) {
                        return;
                    }
                    PdfImageObject pimg = new PdfImageObject(stream);
                    BufferedImage img = pimg.getBufferedImage();
                    this.text.setText("");
                    StyledDocument doc = (StyledDocument)this.text.getDocument();
                    Style style = doc.addStyle("Image", null);
                    StyleConstants.setIcon(style, new ImageIcon(img));
                    try {
                        doc.insertString(doc.getLength(), "ignored text", style);
                        JButton saveImage = new JButton("Save Image");
                        final BufferedImage saveImg = img;
                        saveImage.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent event) {
                                try {
                                    FileDialog fileDialog = new FileDialog(new Frame(), "Save", 1);
                                    fileDialog.setFilenameFilter(new FilenameFilter(){

                                        public boolean accept(File dir, String name) {
                                            return name.endsWith(".jpg");
                                        }
                                    });
                                    fileDialog.setFile("Untitled.jpg");
                                    fileDialog.setVisible(true);
                                    ImageIO.write((RenderedImage)saveImg, "jpg", new File(fileDialog.getDirectory() + fileDialog.getFile()));
                                }
                                catch (Exception e2) {
                                    e2.printStackTrace();
                                }
                            }
                        });
                        this.text.append("\n", null);
                        this.text.insertComponent(saveImage);
                    }
                    catch (BadLocationException e4) {
                        e4.printStackTrace();
                    }
                }
                catch (IOException e5) {
                    e5.printStackTrace();
                }
            } else if (stream.get(PdfName.LENGTH1) != null) {
                try {
                    byte[] bytes = PdfReader.getStreamBytesRaw(stream);
                    this.text.setText(new String(bytes));
                    this.text.setCaretPosition(0);
                }
                catch (IOException e6) {
                    this.text.setText("");
                }
            }
        } else {
            this.update(null, null);
            return;
        }
        this.text.repaint();
        this.repaint();
    }

    protected void append(StringBuilder sb, PdfObject obj) {
        switch (obj.type()) {
            case 3: {
                PdfString str = (PdfString)obj;
                if (str.isHexWriting()) {
                    sb.append("<");
                    byte[] b2 = str.getBytes();
                    int len = b2.length;
                    for (int k2 = 0; k2 < len; ++k2) {
                        String hex = Integer.toHexString(b2[k2]);
                        if (hex.length() % 2 == 1) {
                            sb.append("0");
                        }
                        sb.append(hex);
                    }
                    sb.append("> ");
                    break;
                }
                sb.append("(");
                sb.append(obj);
                sb.append(") ");
                break;
            }
            case 6: {
                PdfDictionary dict = (PdfDictionary)obj;
                sb.append("<<");
                for (PdfName key : dict.getKeys()) {
                    sb.append(key);
                    sb.append(" ");
                    this.append(sb, dict.get(key));
                }
                sb.append(">> ");
                break;
            }
            default: {
                sb.append(obj);
                sb.append(" ");
            }
        }
    }

    protected void initAttributes() {
        attributemap = new HashMap<String, Map<Object, Object>>();
        HashMap<Object, Color> opConstructionPainting = new HashMap<Object, Color>();
        Color darkorange = new Color(255, 140, 0);
        opConstructionPainting.put(StyleConstants.Foreground, darkorange);
        opConstructionPainting.put(StyleConstants.Background, Color.WHITE);
        attributemap.put("m", opConstructionPainting);
        attributemap.put("l", opConstructionPainting);
        attributemap.put("c", opConstructionPainting);
        attributemap.put("v", opConstructionPainting);
        attributemap.put("y", opConstructionPainting);
        attributemap.put("h", opConstructionPainting);
        attributemap.put("re", opConstructionPainting);
        attributemap.put("S", opConstructionPainting);
        attributemap.put("s", opConstructionPainting);
        attributemap.put("f", opConstructionPainting);
        attributemap.put("F", opConstructionPainting);
        attributemap.put("f*", opConstructionPainting);
        attributemap.put("B", opConstructionPainting);
        attributemap.put("B*", opConstructionPainting);
        attributemap.put("b", opConstructionPainting);
        attributemap.put("b*", opConstructionPainting);
        attributemap.put("n", opConstructionPainting);
        attributemap.put("W", opConstructionPainting);
        attributemap.put("W*", opConstructionPainting);
        HashMap<Object, Serializable> graphicsdelim = new HashMap<Object, Serializable>();
        graphicsdelim.put(StyleConstants.Foreground, Color.WHITE);
        graphicsdelim.put(StyleConstants.Background, Color.RED);
        graphicsdelim.put(StyleConstants.Bold, Boolean.valueOf(true));
        attributemap.put("q", graphicsdelim);
        attributemap.put("Q", graphicsdelim);
        HashMap<Object, Color> graphics = new HashMap<Object, Color>();
        graphics.put(StyleConstants.Foreground, Color.RED);
        graphics.put(StyleConstants.Background, Color.WHITE);
        attributemap.put("w", graphics);
        attributemap.put("J", graphics);
        attributemap.put("j", graphics);
        attributemap.put("M", graphics);
        attributemap.put("d", graphics);
        attributemap.put("ri", graphics);
        attributemap.put("i", graphics);
        attributemap.put("gs", graphics);
        attributemap.put("cm", graphics);
        attributemap.put("g", graphics);
        attributemap.put("G", graphics);
        attributemap.put("rg", graphics);
        attributemap.put("RG", graphics);
        attributemap.put("k", graphics);
        attributemap.put("K", graphics);
        attributemap.put("cs", graphics);
        attributemap.put("CS", graphics);
        attributemap.put("sc", graphics);
        attributemap.put("SC", graphics);
        attributemap.put("scn", graphics);
        attributemap.put("SCN", graphics);
        attributemap.put("sh", graphics);
        HashMap<Object, Color> xObject = new HashMap<Object, Color>();
        xObject.put(StyleConstants.Foreground, Color.BLACK);
        xObject.put(StyleConstants.Background, Color.YELLOW);
        attributemap.put("Do", xObject);
        HashMap<Object, Serializable> inlineImage = new HashMap<Object, Serializable>();
        inlineImage.put(StyleConstants.Foreground, Color.BLACK);
        inlineImage.put(StyleConstants.Background, Color.YELLOW);
        inlineImage.put(StyleConstants.Italic, Boolean.valueOf(true));
        attributemap.put("BI", inlineImage);
        attributemap.put("EI", inlineImage);
        HashMap<Object, Serializable> textdelim = new HashMap<Object, Serializable>();
        textdelim.put(StyleConstants.Foreground, Color.WHITE);
        textdelim.put(StyleConstants.Background, Color.BLUE);
        textdelim.put(StyleConstants.Bold, Boolean.valueOf(true));
        attributemap.put("BT", textdelim);
        attributemap.put("ET", textdelim);
        HashMap<Object, Color> text = new HashMap<Object, Color>();
        text.put(StyleConstants.Foreground, Color.BLUE);
        text.put(StyleConstants.Background, Color.WHITE);
        attributemap.put("ID", text);
        attributemap.put("Tc", text);
        attributemap.put("Tw", text);
        attributemap.put("Tz", text);
        attributemap.put("TL", text);
        attributemap.put("Tf", text);
        attributemap.put("Tr", text);
        attributemap.put("Ts", text);
        attributemap.put("Td", text);
        attributemap.put("TD", text);
        attributemap.put("Tm", text);
        attributemap.put("T*", text);
        attributemap.put("Tj", text);
        attributemap.put("'", text);
        attributemap.put("\"", text);
        attributemap.put("TJ", text);
        HashMap<Object, Color> markedContent = new HashMap<Object, Color>();
        markedContent.put(StyleConstants.Foreground, Color.MAGENTA);
        markedContent.put(StyleConstants.Background, Color.WHITE);
        attributemap.put("BMC", markedContent);
        attributemap.put("BDC", markedContent);
        attributemap.put("EMC", markedContent);
    }
}

