/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.io.RASInputStream;
import com.itextpdf.text.io.RandomAccessSourceFactory;
import com.itextpdf.text.io.WindowRandomAccessSource;
import com.itextpdf.text.pdf.BaseField;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.ByteBuffer;
import com.itextpdf.text.pdf.CMYKColor;
import com.itextpdf.text.pdf.DocumentFont;
import com.itextpdf.text.pdf.ExtendedColor;
import com.itextpdf.text.pdf.FdfReader;
import com.itextpdf.text.pdf.FdfWriter;
import com.itextpdf.text.pdf.FontDetails;
import com.itextpdf.text.pdf.GrayColor;
import com.itextpdf.text.pdf.IntHashtable;
import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PRTokeniser;
import com.itextpdf.text.pdf.PdfAppearance;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfBoolean;
import com.itextpdf.text.pdf.PdfDate;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfEncodings;
import com.itextpdf.text.pdf.PdfFormField;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamperImp;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.PushbuttonField;
import com.itextpdf.text.pdf.RadioCheckField;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import com.itextpdf.text.pdf.TextField;
import com.itextpdf.text.pdf.XfaForm;
import com.itextpdf.text.pdf.XfdfReader;
import com.itextpdf.text.pdf.codec.Base64;
import com.itextpdf.text.pdf.security.PdfPKCS7;
import com.itextpdf.text.xml.XmlToTxt;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcroFields {
    PdfReader reader;
    PdfWriter writer;
    Map<String, Item> fields;
    private int topFirst;
    private HashMap<String, int[]> sigNames;
    private boolean append;
    public static final int DA_FONT = 0;
    public static final int DA_SIZE = 1;
    public static final int DA_COLOR = 2;
    private HashMap<Integer, BaseFont> extensionFonts = new HashMap();
    private XfaForm xfa;
    public static final int FIELD_TYPE_NONE = 0;
    public static final int FIELD_TYPE_PUSHBUTTON = 1;
    public static final int FIELD_TYPE_CHECKBOX = 2;
    public static final int FIELD_TYPE_RADIOBUTTON = 3;
    public static final int FIELD_TYPE_TEXT = 4;
    public static final int FIELD_TYPE_LIST = 5;
    public static final int FIELD_TYPE_COMBO = 6;
    public static final int FIELD_TYPE_SIGNATURE = 7;
    private boolean lastWasString;
    private boolean generateAppearances = true;
    private HashMap<String, BaseFont> localFonts = new HashMap();
    private float extraMarginLeft;
    private float extraMarginTop;
    private ArrayList<BaseFont> substitutionFonts;
    private ArrayList<String> orderedSignatureNames;
    private static final HashMap<String, String[]> stdFieldFontNames = new HashMap();
    private int totalRevisions;
    private Map<String, TextField> fieldCache;
    private static final PdfName[] buttonRemove;

    AcroFields(PdfReader reader, PdfWriter writer) {
        this.reader = reader;
        this.writer = writer;
        try {
            this.xfa = new XfaForm(reader);
        }
        catch (Exception e2) {
            throw new ExceptionConverter(e2);
        }
        if (writer instanceof PdfStamperImp) {
            this.append = ((PdfStamperImp)writer).isAppend();
        }
        this.fill();
    }

    void fill() {
        this.fields = new HashMap<String, Item>();
        PdfDictionary top = (PdfDictionary)PdfReader.getPdfObjectRelease(this.reader.getCatalog().get(PdfName.ACROFORM));
        if (top == null) {
            return;
        }
        PdfBoolean needappearances = top.getAsBoolean(PdfName.NEEDAPPEARANCES);
        if (needappearances == null || !needappearances.booleanValue()) {
            this.setGenerateAppearances(true);
        } else {
            this.setGenerateAppearances(false);
        }
        PdfArray arrfds = (PdfArray)PdfReader.getPdfObjectRelease(top.get(PdfName.FIELDS));
        if (arrfds == null || arrfds.size() == 0) {
            return;
        }
        for (int k2 = 1; k2 <= this.reader.getNumberOfPages(); ++k2) {
            PdfDictionary page = this.reader.getPageNRelease(k2);
            PdfArray annots = (PdfArray)PdfReader.getPdfObjectRelease(page.get(PdfName.ANNOTS), page);
            if (annots == null) continue;
            for (int j2 = 0; j2 < annots.size(); ++j2) {
                Item item;
                PdfDictionary annot = annots.getAsDict(j2);
                if (annot == null) {
                    PdfReader.releaseLastXrefPartial(annots.getAsIndirectObject(j2));
                    continue;
                }
                if (!PdfName.WIDGET.equals(annot.getAsName(PdfName.SUBTYPE))) {
                    PdfReader.releaseLastXrefPartial(annots.getAsIndirectObject(j2));
                    continue;
                }
                PdfDictionary widget = annot;
                PdfDictionary dic = new PdfDictionary();
                dic.putAll(annot);
                String name = "";
                PdfDictionary value = null;
                PdfObject lastV = null;
                while (annot != null) {
                    dic.mergeDifferent(annot);
                    PdfString t2 = annot.getAsString(PdfName.T);
                    if (t2 != null) {
                        name = t2.toUnicodeString() + "." + name;
                    }
                    if (lastV == null && annot.get(PdfName.V) != null) {
                        lastV = PdfReader.getPdfObjectRelease(annot.get(PdfName.V));
                    }
                    if (value == null && t2 != null) {
                        value = annot;
                        if (annot.get(PdfName.V) == null && lastV != null) {
                            value.put(PdfName.V, lastV);
                        }
                    }
                    annot = annot.getAsDict(PdfName.PARENT);
                }
                if (name.length() > 0) {
                    name = name.substring(0, name.length() - 1);
                }
                if ((item = this.fields.get(name)) == null) {
                    item = new Item();
                    this.fields.put(name, item);
                }
                if (value == null) {
                    item.addValue(widget);
                } else {
                    item.addValue(value);
                }
                item.addWidget(widget);
                item.addWidgetRef(annots.getAsIndirectObject(j2));
                if (top != null) {
                    dic.mergeDifferent(top);
                }
                item.addMerged(dic);
                item.addPage(k2);
                item.addTabOrder(j2);
            }
        }
        PdfNumber sigFlags = top.getAsNumber(PdfName.SIGFLAGS);
        if (sigFlags == null || (sigFlags.intValue() & 1) != 1) {
            return;
        }
        for (int j3 = 0; j3 < arrfds.size(); ++j3) {
            String name;
            PdfDictionary annot = arrfds.getAsDict(j3);
            if (annot == null) {
                PdfReader.releaseLastXrefPartial(arrfds.getAsIndirectObject(j3));
                continue;
            }
            if (!PdfName.WIDGET.equals(annot.getAsName(PdfName.SUBTYPE))) {
                PdfReader.releaseLastXrefPartial(arrfds.getAsIndirectObject(j3));
                continue;
            }
            PdfArray kids = (PdfArray)PdfReader.getPdfObjectRelease(annot.get(PdfName.KIDS));
            if (kids != null) continue;
            PdfDictionary dic = new PdfDictionary();
            dic.putAll(annot);
            PdfString t3 = annot.getAsString(PdfName.T);
            if (t3 == null || this.fields.containsKey(name = t3.toUnicodeString())) continue;
            Item item = new Item();
            this.fields.put(name, item);
            item.addValue(dic);
            item.addWidget(dic);
            item.addWidgetRef(arrfds.getAsIndirectObject(j3));
            item.addMerged(dic);
            item.addPage(-1);
            item.addTabOrder(-1);
        }
    }

    public String[] getAppearanceStates(String fieldName) {
        Item fd = this.fields.get(fieldName);
        if (fd == null) {
            return null;
        }
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        PdfDictionary vals = fd.getValue(0);
        PdfString stringOpt = vals.getAsString(PdfName.OPT);
        if (stringOpt != null) {
            names.add(stringOpt.toUnicodeString());
        } else {
            PdfArray arrayOpt = vals.getAsArray(PdfName.OPT);
            if (arrayOpt != null) {
                for (int k2 = 0; k2 < arrayOpt.size(); ++k2) {
                    PdfObject pdfObject = arrayOpt.getDirectObject(k2);
                    PdfString valStr = null;
                    switch (pdfObject.type()) {
                        case 5: {
                            PdfArray pdfArray = (PdfArray)pdfObject;
                            valStr = pdfArray.getAsString(1);
                            break;
                        }
                        case 3: {
                            valStr = (PdfString)pdfObject;
                        }
                    }
                    if (valStr == null) continue;
                    names.add(valStr.toUnicodeString());
                }
            }
        }
        for (int k3 = 0; k3 < fd.size(); ++k3) {
            PdfDictionary dic = fd.getWidget(k3);
            if ((dic = dic.getAsDict(PdfName.AP)) == null || (dic = dic.getAsDict(PdfName.N)) == null) continue;
            for (PdfName element : dic.getKeys()) {
                String name = PdfName.decodeName(element.toString());
                names.add(name);
            }
        }
        String[] out = new String[names.size()];
        return names.toArray(out);
    }

    private String[] getListOption(String fieldName, int idx) {
        Item fd = this.getFieldItem(fieldName);
        if (fd == null) {
            return null;
        }
        PdfArray ar = fd.getMerged(0).getAsArray(PdfName.OPT);
        if (ar == null) {
            return null;
        }
        String[] ret = new String[ar.size()];
        for (int k2 = 0; k2 < ar.size(); ++k2) {
            PdfObject obj = ar.getDirectObject(k2);
            try {
                if (obj.isArray()) {
                    obj = ((PdfArray)obj).getDirectObject(idx);
                }
                if (obj.isString()) {
                    ret[k2] = ((PdfString)obj).toUnicodeString();
                    continue;
                }
                ret[k2] = obj.toString();
                continue;
            }
            catch (Exception e2) {
                ret[k2] = "";
            }
        }
        return ret;
    }

    public String[] getListOptionExport(String fieldName) {
        return this.getListOption(fieldName, 0);
    }

    public String[] getListOptionDisplay(String fieldName) {
        return this.getListOption(fieldName, 1);
    }

    public boolean setListOption(String fieldName, String[] exportValues, String[] displayValues) {
        if (exportValues == null && displayValues == null) {
            return false;
        }
        if (exportValues != null && displayValues != null && exportValues.length != displayValues.length) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.export.and.the.display.array.must.have.the.same.size", new Object[0]));
        }
        int ftype = this.getFieldType(fieldName);
        if (ftype != 6 && ftype != 5) {
            return false;
        }
        Item fd = this.fields.get(fieldName);
        String[] sing = null;
        if (exportValues == null && displayValues != null) {
            sing = displayValues;
        } else if (exportValues != null && displayValues == null) {
            sing = exportValues;
        }
        PdfArray opt = new PdfArray();
        if (sing != null) {
            for (int k2 = 0; k2 < sing.length; ++k2) {
                opt.add(new PdfString(sing[k2], "UnicodeBig"));
            }
        } else {
            for (int k3 = 0; k3 < exportValues.length; ++k3) {
                PdfArray a2 = new PdfArray();
                a2.add(new PdfString(exportValues[k3], "UnicodeBig"));
                a2.add(new PdfString(displayValues[k3], "UnicodeBig"));
                opt.add(a2);
            }
        }
        fd.writeToAll(PdfName.OPT, opt, 5);
        return true;
    }

    public int getFieldType(String fieldName) {
        Item fd = this.getFieldItem(fieldName);
        if (fd == null) {
            return 0;
        }
        PdfDictionary merged = fd.getMerged(0);
        PdfName type = merged.getAsName(PdfName.FT);
        if (type == null) {
            return 0;
        }
        int ff = 0;
        PdfNumber ffo = merged.getAsNumber(PdfName.FF);
        if (ffo != null) {
            ff = ffo.intValue();
        }
        if (PdfName.BTN.equals(type)) {
            if ((ff & 0x10000) != 0) {
                return 1;
            }
            if ((ff & 0x8000) != 0) {
                return 3;
            }
            return 2;
        }
        if (PdfName.TX.equals(type)) {
            return 4;
        }
        if (PdfName.CH.equals(type)) {
            if ((ff & 0x20000) != 0) {
                return 6;
            }
            return 5;
        }
        if (PdfName.SIG.equals(type)) {
            return 7;
        }
        return 0;
    }

    public void exportAsFdf(FdfWriter writer) {
        for (Map.Entry<String, Item> entry : this.fields.entrySet()) {
            Item item = entry.getValue();
            String name = entry.getKey();
            PdfObject v2 = item.getMerged(0).get(PdfName.V);
            if (v2 == null) continue;
            String value = this.getField(name);
            if (this.lastWasString) {
                writer.setFieldAsString(name, value);
                continue;
            }
            writer.setFieldAsName(name, value);
        }
    }

    public boolean renameField(String oldName, String newName) {
        int idx2;
        int idx1 = oldName.lastIndexOf(46) + 1;
        if (idx1 != (idx2 = newName.lastIndexOf(46) + 1)) {
            return false;
        }
        if (!oldName.substring(0, idx1).equals(newName.substring(0, idx2))) {
            return false;
        }
        if (this.fields.containsKey(newName)) {
            return false;
        }
        Item item = this.fields.get(oldName);
        if (item == null) {
            return false;
        }
        newName = newName.substring(idx2);
        PdfString ss = new PdfString(newName, "UnicodeBig");
        item.writeToAll(PdfName.T, ss, 5);
        item.markUsed(this, 4);
        this.fields.remove(oldName);
        this.fields.put(newName, item);
        return true;
    }

    public static Object[] splitDAelements(String da) {
        try {
            PRTokeniser tk = new PRTokeniser(new RandomAccessFileOrArray(new RandomAccessSourceFactory().createSource(PdfEncodings.convertToBytes(da, null))));
            ArrayList<String> stack = new ArrayList<String>();
            Object[] ret = new Object[3];
            while (tk.nextToken()) {
                if (tk.getTokenType() == PRTokeniser.TokenType.COMMENT) continue;
                if (tk.getTokenType() == PRTokeniser.TokenType.OTHER) {
                    String operator = tk.getStringValue();
                    if (operator.equals("Tf")) {
                        if (stack.size() >= 2) {
                            ret[0] = stack.get(stack.size() - 2);
                            ret[1] = new Float((String)stack.get(stack.size() - 1));
                        }
                    } else if (operator.equals("g")) {
                        float gray;
                        if (stack.size() >= 1 && (gray = new Float((String)stack.get(stack.size() - 1)).floatValue()) != 0.0f) {
                            ret[2] = new GrayColor(gray);
                        }
                    } else if (operator.equals("rg")) {
                        if (stack.size() >= 3) {
                            float red = new Float((String)stack.get(stack.size() - 3)).floatValue();
                            float green = new Float((String)stack.get(stack.size() - 2)).floatValue();
                            float blue = new Float((String)stack.get(stack.size() - 1)).floatValue();
                            ret[2] = new BaseColor(red, green, blue);
                        }
                    } else if (operator.equals("k") && stack.size() >= 4) {
                        float cyan = new Float((String)stack.get(stack.size() - 4)).floatValue();
                        float magenta = new Float((String)stack.get(stack.size() - 3)).floatValue();
                        float yellow = new Float((String)stack.get(stack.size() - 2)).floatValue();
                        float black = new Float((String)stack.get(stack.size() - 1)).floatValue();
                        ret[2] = new CMYKColor(cyan, magenta, yellow, black);
                    }
                    stack.clear();
                    continue;
                }
                stack.add(tk.getStringValue());
            }
            return ret;
        }
        catch (IOException ioe) {
            throw new ExceptionConverter(ioe);
        }
    }

    public void decodeGenericDictionary(PdfDictionary merged, BaseField tx) throws IOException, DocumentException {
        PdfDictionary bs;
        PdfDictionary mk;
        int flags = 0;
        PdfString da = merged.getAsString(PdfName.DA);
        if (da != null) {
            PdfDictionary font;
            PdfDictionary dr;
            Object[] dab = AcroFields.splitDAelements(da.toUnicodeString());
            if (dab[1] != null) {
                tx.setFontSize(((Float)dab[1]).floatValue());
            }
            if (dab[2] != null) {
                tx.setTextColor((BaseColor)dab[2]);
            }
            if (dab[0] != null && (dr = merged.getAsDict(PdfName.DR)) != null && (font = dr.getAsDict(PdfName.FONT)) != null) {
                PdfObject po = font.get(new PdfName((String)dab[0]));
                if (po != null && po.type() == 10) {
                    PdfDictionary fo;
                    PdfDictionary fd;
                    PRIndirectReference por = (PRIndirectReference)po;
                    DocumentFont bp = new DocumentFont((PRIndirectReference)po, dr.getAsDict(PdfName.ENCODING));
                    tx.setFont(bp);
                    Integer porkey = por.getNumber();
                    BaseFont porf = this.extensionFonts.get(porkey);
                    if (porf == null && !this.extensionFonts.containsKey(porkey) && (fd = (fo = (PdfDictionary)PdfReader.getPdfObject(po)).getAsDict(PdfName.FONTDESCRIPTOR)) != null) {
                        PRStream prs = (PRStream)PdfReader.getPdfObject(fd.get(PdfName.FONTFILE2));
                        if (prs == null) {
                            prs = (PRStream)PdfReader.getPdfObject(fd.get(PdfName.FONTFILE3));
                        }
                        if (prs == null) {
                            this.extensionFonts.put(porkey, null);
                        } else {
                            try {
                                porf = BaseFont.createFont("font.ttf", "Identity-H", true, false, PdfReader.getStreamBytes(prs), null);
                            }
                            catch (Exception e2) {
                                // empty catch block
                            }
                            this.extensionFonts.put(porkey, porf);
                        }
                    }
                    if (tx instanceof TextField) {
                        ((TextField)tx).setExtensionFont(porf);
                    }
                } else {
                    BaseFont bf = this.localFonts.get(dab[0]);
                    if (bf == null) {
                        String[] fn = stdFieldFontNames.get(dab[0]);
                        if (fn != null) {
                            try {
                                String enc = "winansi";
                                if (fn.length > 1) {
                                    enc = fn[1];
                                }
                                bf = BaseFont.createFont(fn[0], enc, false);
                                tx.setFont(bf);
                            }
                            catch (Exception e3) {}
                        }
                    } else {
                        tx.setFont(bf);
                    }
                }
            }
        }
        if ((mk = merged.getAsDict(PdfName.MK)) != null) {
            PdfArray ar = mk.getAsArray(PdfName.BC);
            BaseColor border = this.getMKColor(ar);
            tx.setBorderColor(border);
            if (border != null) {
                tx.setBorderWidth(1.0f);
            }
            ar = mk.getAsArray(PdfName.BG);
            tx.setBackgroundColor(this.getMKColor(ar));
            PdfNumber rotation = mk.getAsNumber(PdfName.R);
            if (rotation != null) {
                tx.setRotation(rotation.intValue());
            }
        }
        PdfNumber nfl = merged.getAsNumber(PdfName.F);
        flags = 0;
        tx.setVisibility(2);
        if (nfl != null) {
            flags = nfl.intValue();
            if ((flags & 4) != 0 && (flags & 2) != 0) {
                tx.setVisibility(1);
            } else if ((flags & 4) != 0 && (flags & 0x20) != 0) {
                tx.setVisibility(3);
            } else if ((flags & 4) != 0) {
                tx.setVisibility(0);
            }
        }
        nfl = merged.getAsNumber(PdfName.FF);
        flags = 0;
        if (nfl != null) {
            flags = nfl.intValue();
        }
        tx.setOptions(flags);
        if ((flags & 0x1000000) != 0) {
            PdfNumber maxLen = merged.getAsNumber(PdfName.MAXLEN);
            int len = 0;
            if (maxLen != null) {
                len = maxLen.intValue();
            }
            tx.setMaxCharacterLength(len);
        }
        if ((nfl = merged.getAsNumber(PdfName.Q)) != null) {
            if (nfl.intValue() == 1) {
                tx.setAlignment(1);
            } else if (nfl.intValue() == 2) {
                tx.setAlignment(2);
            }
        }
        if ((bs = merged.getAsDict(PdfName.BS)) != null) {
            PdfName s2;
            PdfNumber w2 = bs.getAsNumber(PdfName.W);
            if (w2 != null) {
                tx.setBorderWidth(w2.floatValue());
            }
            if (PdfName.D.equals(s2 = bs.getAsName(PdfName.S))) {
                tx.setBorderStyle(1);
            } else if (PdfName.B.equals(s2)) {
                tx.setBorderStyle(2);
            } else if (PdfName.I.equals(s2)) {
                tx.setBorderStyle(3);
            } else if (PdfName.U.equals(s2)) {
                tx.setBorderStyle(4);
            }
        } else {
            PdfArray bd = merged.getAsArray(PdfName.BORDER);
            if (bd != null) {
                if (bd.size() >= 3) {
                    tx.setBorderWidth(bd.getAsNumber(2).floatValue());
                }
                if (bd.size() >= 4) {
                    tx.setBorderStyle(1);
                }
            }
        }
    }

    PdfAppearance getAppearance(PdfDictionary merged, String[] values, String fieldName) throws IOException, DocumentException {
        PdfName fieldType = merged.getAsName(PdfName.FT);
        if (PdfName.BTN.equals(fieldType)) {
            RadioCheckField field = new RadioCheckField(this.writer, null, null, null);
            this.decodeGenericDictionary(merged, field);
            PdfArray rect = merged.getAsArray(PdfName.RECT);
            Rectangle box = PdfReader.getNormalizedRectangle(rect);
            if (field.getRotation() == 90 || field.getRotation() == 270) {
                box = box.rotate();
            }
            field.setBox(box);
            field.setCheckType(3);
            return field.getAppearance(false, !merged.getAsName(PdfName.AS).equals(PdfName.Off));
        }
        this.topFirst = 0;
        String text = values.length > 0 ? values[0] : null;
        TextField tx = null;
        if (this.fieldCache == null || !this.fieldCache.containsKey(fieldName)) {
            tx = new TextField(this.writer, null, null);
            tx.setExtraMargin(this.extraMarginLeft, this.extraMarginTop);
            tx.setBorderWidth(0.0f);
            tx.setSubstitutionFonts(this.substitutionFonts);
            this.decodeGenericDictionary(merged, tx);
            PdfArray rect = merged.getAsArray(PdfName.RECT);
            Rectangle box = PdfReader.getNormalizedRectangle(rect);
            if (tx.getRotation() == 90 || tx.getRotation() == 270) {
                box = box.rotate();
            }
            tx.setBox(box);
            if (this.fieldCache != null) {
                this.fieldCache.put(fieldName, tx);
            }
        } else {
            tx = this.fieldCache.get(fieldName);
            tx.setWriter(this.writer);
        }
        if (PdfName.TX.equals(fieldType)) {
            if (values.length > 0 && values[0] != null) {
                tx.setText(values[0]);
            }
            return tx.getAppearance();
        }
        if (!PdfName.CH.equals(fieldType)) {
            throw new DocumentException(MessageLocalization.getComposedMessage("an.appearance.was.requested.without.a.variable.text.field", new Object[0]));
        }
        PdfArray opt = merged.getAsArray(PdfName.OPT);
        int flags = 0;
        PdfNumber nfl = merged.getAsNumber(PdfName.FF);
        if (nfl != null) {
            flags = nfl.intValue();
        }
        if ((flags & 0x20000) != 0 && opt == null) {
            tx.setText(text);
            return tx.getAppearance();
        }
        if (opt != null) {
            int k2;
            String[] choices = new String[opt.size()];
            String[] choicesExp = new String[opt.size()];
            for (k2 = 0; k2 < opt.size(); ++k2) {
                PdfObject obj = opt.getPdfObject(k2);
                if (obj.isString()) {
                    choices[k2] = choicesExp[k2] = ((PdfString)obj).toUnicodeString();
                    continue;
                }
                PdfArray a2 = (PdfArray)obj;
                choicesExp[k2] = a2.getAsString(0).toUnicodeString();
                choices[k2] = a2.getAsString(1).toUnicodeString();
            }
            if ((flags & 0x20000) != 0) {
                for (k2 = 0; k2 < choices.length; ++k2) {
                    if (!text.equals(choicesExp[k2])) continue;
                    text = choices[k2];
                    break;
                }
                tx.setText(text);
                return tx.getAppearance();
            }
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            block2: for (int k3 = 0; k3 < choicesExp.length; ++k3) {
                for (int j2 = 0; j2 < values.length; ++j2) {
                    String val = values[j2];
                    if (val == null || !val.equals(choicesExp[k3])) continue;
                    indexes.add(k3);
                    continue block2;
                }
            }
            tx.setChoices(choices);
            tx.setChoiceExports(choicesExp);
            tx.setChoiceSelections(indexes);
        }
        PdfAppearance app = tx.getListAppearance();
        this.topFirst = tx.getTopFirst();
        return app;
    }

    PdfAppearance getAppearance(PdfDictionary merged, String text, String fieldName) throws IOException, DocumentException {
        String[] valueArr = new String[]{text};
        return this.getAppearance(merged, valueArr, fieldName);
    }

    BaseColor getMKColor(PdfArray ar) {
        if (ar == null) {
            return null;
        }
        switch (ar.size()) {
            case 1: {
                return new GrayColor(ar.getAsNumber(0).floatValue());
            }
            case 3: {
                return new BaseColor(ExtendedColor.normalize(ar.getAsNumber(0).floatValue()), ExtendedColor.normalize(ar.getAsNumber(1).floatValue()), ExtendedColor.normalize(ar.getAsNumber(2).floatValue()));
            }
            case 4: {
                return new CMYKColor(ar.getAsNumber(0).floatValue(), ar.getAsNumber(1).floatValue(), ar.getAsNumber(2).floatValue(), ar.getAsNumber(3).floatValue());
            }
        }
        return null;
    }

    public String getFieldRichValue(String name) {
        if (this.xfa.isXfaPresent()) {
            return null;
        }
        Item item = this.fields.get(name);
        if (item == null) {
            return null;
        }
        PdfDictionary merged = item.getMerged(0);
        PdfString rich = merged.getAsString(PdfName.RV);
        String markup = null;
        if (rich != null) {
            markup = rich.toString();
        }
        return markup;
    }

    public String getField(String name) {
        if (this.xfa.isXfaPresent()) {
            if ((name = this.xfa.findFieldName(name, this)) == null) {
                return null;
            }
            name = XfaForm.Xml2Som.getShortName(name);
            return XfaForm.getNodeText(this.xfa.findDatasetsNode(name));
        }
        Item item = this.fields.get(name);
        if (item == null) {
            return null;
        }
        this.lastWasString = false;
        PdfDictionary mergedDict = item.getMerged(0);
        PdfObject v2 = PdfReader.getPdfObject(mergedDict.get(PdfName.V));
        if (v2 == null) {
            return "";
        }
        if (v2 instanceof PRStream) {
            try {
                byte[] valBytes = PdfReader.getStreamBytes((PRStream)v2);
                return new String(valBytes);
            }
            catch (IOException e2) {
                throw new ExceptionConverter(e2);
            }
        }
        PdfName type = mergedDict.getAsName(PdfName.FT);
        if (PdfName.BTN.equals(type)) {
            PdfNumber ff = mergedDict.getAsNumber(PdfName.FF);
            int flags = 0;
            if (ff != null) {
                flags = ff.intValue();
            }
            if ((flags & 0x10000) != 0) {
                return "";
            }
            String value = "";
            if (v2 instanceof PdfName) {
                value = PdfName.decodeName(v2.toString());
            } else if (v2 instanceof PdfString) {
                value = ((PdfString)v2).toUnicodeString();
            }
            PdfArray opts = item.getValue(0).getAsArray(PdfName.OPT);
            if (opts != null) {
                int idx = 0;
                try {
                    idx = Integer.parseInt(value);
                    PdfString ps = opts.getAsString(idx);
                    value = ps.toUnicodeString();
                    this.lastWasString = true;
                }
                catch (Exception e3) {
                    // empty catch block
                }
            }
            return value;
        }
        if (v2 instanceof PdfString) {
            this.lastWasString = true;
            return ((PdfString)v2).toUnicodeString();
        }
        if (v2 instanceof PdfName) {
            return PdfName.decodeName(v2.toString());
        }
        return "";
    }

    public String[] getListSelection(String name) {
        String s2 = this.getField(name);
        String[] ret = s2 == null ? new String[]{} : new String[]{s2};
        Item item = this.fields.get(name);
        if (item == null) {
            return ret;
        }
        PdfArray values = item.getMerged(0).getAsArray(PdfName.I);
        if (values == null) {
            return ret;
        }
        ret = new String[values.size()];
        String[] options = this.getListOptionExport(name);
        int idx = 0;
        ListIterator<PdfObject> i2 = values.listIterator();
        while (i2.hasNext()) {
            PdfNumber n2 = (PdfNumber)i2.next();
            ret[idx++] = options[n2.intValue()];
        }
        return ret;
    }

    public boolean setFieldProperty(String field, String name, Object value, int[] inst) {
        if (this.writer == null) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("this.acrofields.instance.is.read.only", new Object[0]));
        }
        try {
            Item item = this.fields.get(field);
            if (item == null) {
                return false;
            }
            InstHit hit = new InstHit(inst);
            if (name.equalsIgnoreCase("textfont")) {
                for (int k2 = 0; k2 < item.size(); ++k2) {
                    PdfDictionary fonts;
                    if (!hit.isHit(k2)) continue;
                    PdfDictionary merged = item.getMerged(k2);
                    PdfString da = merged.getAsString(PdfName.DA);
                    PdfDictionary dr = merged.getAsDict(PdfName.DR);
                    if (da == null) continue;
                    if (dr == null) {
                        dr = new PdfDictionary();
                        merged.put(PdfName.DR, dr);
                    }
                    Object[] dao = AcroFields.splitDAelements(da.toUnicodeString());
                    PdfAppearance cb = new PdfAppearance();
                    if (dao[0] == null) continue;
                    BaseFont bf = (BaseFont)value;
                    PdfName psn = PdfAppearance.stdFieldFontNames.get(bf.getPostscriptFontName());
                    if (psn == null) {
                        psn = new PdfName(bf.getPostscriptFontName());
                    }
                    if ((fonts = dr.getAsDict(PdfName.FONT)) == null) {
                        fonts = new PdfDictionary();
                        dr.put(PdfName.FONT, fonts);
                    }
                    PdfIndirectReference fref = (PdfIndirectReference)fonts.get(psn);
                    PdfDictionary top = this.reader.getCatalog().getAsDict(PdfName.ACROFORM);
                    this.markUsed(top);
                    dr = top.getAsDict(PdfName.DR);
                    if (dr == null) {
                        dr = new PdfDictionary();
                        top.put(PdfName.DR, dr);
                    }
                    this.markUsed(dr);
                    PdfDictionary fontsTop = dr.getAsDict(PdfName.FONT);
                    if (fontsTop == null) {
                        fontsTop = new PdfDictionary();
                        dr.put(PdfName.FONT, fontsTop);
                    }
                    this.markUsed(fontsTop);
                    PdfIndirectReference frefTop = (PdfIndirectReference)fontsTop.get(psn);
                    if (frefTop != null) {
                        if (fref == null) {
                            fonts.put(psn, frefTop);
                        }
                    } else if (fref == null) {
                        FontDetails fd;
                        if (bf.getFontType() == 4) {
                            fd = new FontDetails(null, ((DocumentFont)bf).getIndirectReference(), bf);
                        } else {
                            bf.setSubset(false);
                            fd = this.writer.addSimple(bf);
                            this.localFonts.put(psn.toString().substring(1), bf);
                        }
                        fontsTop.put(psn, fd.getIndirectReference());
                        fonts.put(psn, fd.getIndirectReference());
                    }
                    ByteBuffer buf = cb.getInternalBuffer();
                    buf.append(psn.getBytes()).append(' ').append(((Float)dao[1]).floatValue()).append(" Tf ");
                    if (dao[2] != null) {
                        cb.setColorFill((BaseColor)dao[2]);
                    }
                    PdfString s2 = new PdfString(cb.toString());
                    item.getMerged(k2).put(PdfName.DA, s2);
                    item.getWidget(k2).put(PdfName.DA, s2);
                    this.markUsed(item.getWidget(k2));
                }
            } else if (name.equalsIgnoreCase("textcolor")) {
                for (int k3 = 0; k3 < item.size(); ++k3) {
                    PdfDictionary merged;
                    PdfString da;
                    if (!hit.isHit(k3) || (da = (merged = item.getMerged(k3)).getAsString(PdfName.DA)) == null) continue;
                    Object[] dao = AcroFields.splitDAelements(da.toUnicodeString());
                    PdfAppearance cb = new PdfAppearance();
                    if (dao[0] == null) continue;
                    ByteBuffer buf = cb.getInternalBuffer();
                    buf.append(new PdfName((String)dao[0]).getBytes()).append(' ').append(((Float)dao[1]).floatValue()).append(" Tf ");
                    cb.setColorFill((BaseColor)value);
                    PdfString s3 = new PdfString(cb.toString());
                    item.getMerged(k3).put(PdfName.DA, s3);
                    item.getWidget(k3).put(PdfName.DA, s3);
                    this.markUsed(item.getWidget(k3));
                }
            } else if (name.equalsIgnoreCase("textsize")) {
                for (int k4 = 0; k4 < item.size(); ++k4) {
                    PdfDictionary merged;
                    PdfString da;
                    if (!hit.isHit(k4) || (da = (merged = item.getMerged(k4)).getAsString(PdfName.DA)) == null) continue;
                    Object[] dao = AcroFields.splitDAelements(da.toUnicodeString());
                    PdfAppearance cb = new PdfAppearance();
                    if (dao[0] == null) continue;
                    ByteBuffer buf = cb.getInternalBuffer();
                    buf.append(new PdfName((String)dao[0]).getBytes()).append(' ').append(((Float)value).floatValue()).append(" Tf ");
                    if (dao[2] != null) {
                        cb.setColorFill((BaseColor)dao[2]);
                    }
                    PdfString s4 = new PdfString(cb.toString());
                    item.getMerged(k4).put(PdfName.DA, s4);
                    item.getWidget(k4).put(PdfName.DA, s4);
                    this.markUsed(item.getWidget(k4));
                }
            } else if (name.equalsIgnoreCase("bgcolor") || name.equalsIgnoreCase("bordercolor")) {
                PdfName dname = name.equalsIgnoreCase("bgcolor") ? PdfName.BG : PdfName.BC;
                for (int k5 = 0; k5 < item.size(); ++k5) {
                    if (!hit.isHit(k5)) continue;
                    PdfDictionary merged = item.getMerged(k5);
                    PdfDictionary mk = merged.getAsDict(PdfName.MK);
                    if (mk == null) {
                        if (value == null) {
                            return true;
                        }
                        mk = new PdfDictionary();
                        item.getMerged(k5).put(PdfName.MK, mk);
                        item.getWidget(k5).put(PdfName.MK, mk);
                        this.markUsed(item.getWidget(k5));
                    } else {
                        this.markUsed(mk);
                    }
                    if (value == null) {
                        mk.remove(dname);
                        continue;
                    }
                    mk.put(dname, PdfFormField.getMKColor((BaseColor)value));
                }
            } else {
                return false;
            }
            return true;
        }
        catch (Exception e2) {
            throw new ExceptionConverter(e2);
        }
    }

    public boolean setFieldProperty(String field, String name, int value, int[] inst) {
        if (this.writer == null) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("this.acrofields.instance.is.read.only", new Object[0]));
        }
        Item item = this.fields.get(field);
        if (item == null) {
            return false;
        }
        InstHit hit = new InstHit(inst);
        if (name.equalsIgnoreCase("flags")) {
            PdfNumber num = new PdfNumber(value);
            for (int k2 = 0; k2 < item.size(); ++k2) {
                if (!hit.isHit(k2)) continue;
                item.getMerged(k2).put(PdfName.F, num);
                item.getWidget(k2).put(PdfName.F, num);
                this.markUsed(item.getWidget(k2));
            }
        } else if (name.equalsIgnoreCase("setflags")) {
            for (int k3 = 0; k3 < item.size(); ++k3) {
                if (!hit.isHit(k3)) continue;
                PdfNumber num = item.getWidget(k3).getAsNumber(PdfName.F);
                int val = 0;
                if (num != null) {
                    val = num.intValue();
                }
                num = new PdfNumber(val | value);
                item.getMerged(k3).put(PdfName.F, num);
                item.getWidget(k3).put(PdfName.F, num);
                this.markUsed(item.getWidget(k3));
            }
        } else if (name.equalsIgnoreCase("clrflags")) {
            for (int k4 = 0; k4 < item.size(); ++k4) {
                if (!hit.isHit(k4)) continue;
                PdfDictionary widget = item.getWidget(k4);
                PdfNumber num = widget.getAsNumber(PdfName.F);
                int val = 0;
                if (num != null) {
                    val = num.intValue();
                }
                num = new PdfNumber(val & ~value);
                item.getMerged(k4).put(PdfName.F, num);
                widget.put(PdfName.F, num);
                this.markUsed(widget);
            }
        } else if (name.equalsIgnoreCase("fflags")) {
            PdfNumber num = new PdfNumber(value);
            for (int k5 = 0; k5 < item.size(); ++k5) {
                if (!hit.isHit(k5)) continue;
                item.getMerged(k5).put(PdfName.FF, num);
                item.getValue(k5).put(PdfName.FF, num);
                this.markUsed(item.getValue(k5));
            }
        } else if (name.equalsIgnoreCase("setfflags")) {
            for (int k6 = 0; k6 < item.size(); ++k6) {
                if (!hit.isHit(k6)) continue;
                PdfDictionary valDict = item.getValue(k6);
                PdfNumber num = valDict.getAsNumber(PdfName.FF);
                int val = 0;
                if (num != null) {
                    val = num.intValue();
                }
                num = new PdfNumber(val | value);
                item.getMerged(k6).put(PdfName.FF, num);
                valDict.put(PdfName.FF, num);
                this.markUsed(valDict);
            }
        } else if (name.equalsIgnoreCase("clrfflags")) {
            for (int k7 = 0; k7 < item.size(); ++k7) {
                if (!hit.isHit(k7)) continue;
                PdfDictionary valDict = item.getValue(k7);
                PdfNumber num = valDict.getAsNumber(PdfName.FF);
                int val = 0;
                if (num != null) {
                    val = num.intValue();
                }
                num = new PdfNumber(val & ~value);
                item.getMerged(k7).put(PdfName.FF, num);
                valDict.put(PdfName.FF, num);
                this.markUsed(valDict);
            }
        } else {
            return false;
        }
        return true;
    }

    public void mergeXfaData(Node n2) throws IOException, DocumentException {
        XfaForm.Xml2SomDatasets data = new XfaForm.Xml2SomDatasets(n2);
        Iterator<String> i$ = data.getOrder().iterator();
        while (i$.hasNext()) {
            String string;
            String name = string = i$.next();
            String text = XfaForm.getNodeText(data.getName2Node().get(name));
            this.setField(name, text);
        }
    }

    public void setFields(FdfReader fdf) throws IOException, DocumentException {
        HashMap<String, PdfDictionary> fd = fdf.getFields();
        for (String f2 : fd.keySet()) {
            String v2 = fdf.getFieldValue(f2);
            if (v2 == null) continue;
            this.setField(f2, v2);
        }
    }

    public void setFields(XfdfReader xfdf) throws IOException, DocumentException {
        HashMap<String, String> fd = xfdf.getFields();
        for (String f2 : fd.keySet()) {
            List<String> l2;
            String v2 = xfdf.getFieldValue(f2);
            if (v2 != null) {
                this.setField(f2, v2);
            }
            if ((l2 = xfdf.getListValues(f2)) == null) continue;
            this.setListSelection(v2, l2.toArray(new String[l2.size()]));
        }
    }

    public boolean regenerateField(String name) throws IOException, DocumentException {
        String value = this.getField(name);
        return this.setField(name, value, value);
    }

    public boolean setField(String name, String value) throws IOException, DocumentException {
        return this.setField(name, value, null);
    }

    public boolean setFieldRichValue(String name, String richValue) throws DocumentException, IOException {
        if (this.writer == null) {
            throw new DocumentException(MessageLocalization.getComposedMessage("this.acrofields.instance.is.read.only", new Object[0]));
        }
        Item item = this.getFieldItem(name);
        if (item == null) {
            return false;
        }
        if (this.getFieldType(name) != 4) {
            return false;
        }
        PdfDictionary merged = item.getMerged(0);
        PdfNumber ffNum = merged.getAsNumber(PdfName.FF);
        int flagVal = 0;
        if (ffNum != null) {
            flagVal = ffNum.intValue();
        }
        if ((flagVal & 0x2000000) == 0) {
            return false;
        }
        PdfString richString = new PdfString(richValue);
        item.writeToAll(PdfName.RV, richString, 5);
        ByteArrayInputStream is = new ByteArrayInputStream(richValue.getBytes());
        PdfString valueString = new PdfString(XmlToTxt.parse(is));
        item.writeToAll(PdfName.V, valueString, 5);
        return true;
    }

    public boolean setField(String name, String value, String display) throws IOException, DocumentException {
        Item item;
        if (this.writer == null) {
            throw new DocumentException(MessageLocalization.getComposedMessage("this.acrofields.instance.is.read.only", new Object[0]));
        }
        if (this.xfa.isXfaPresent()) {
            if ((name = this.xfa.findFieldName(name, this)) == null) {
                return false;
            }
            String shortName = XfaForm.Xml2Som.getShortName(name);
            Node xn = this.xfa.findDatasetsNode(shortName);
            if (xn == null) {
                xn = this.xfa.getDatasetsSom().insertNode(this.xfa.getDatasetsNode(), shortName);
            }
            this.xfa.setNodeText(xn, value);
        }
        if ((item = this.fields.get(name)) == null) {
            return false;
        }
        PdfDictionary merged = item.getMerged(0);
        PdfName type = merged.getAsName(PdfName.FT);
        if (PdfName.TX.equals(type)) {
            PdfNumber maxLen = merged.getAsNumber(PdfName.MAXLEN);
            int len = 0;
            if (maxLen != null) {
                len = maxLen.intValue();
            }
            if (len > 0) {
                value = value.substring(0, Math.min(len, value.length()));
            }
        }
        if (display == null) {
            display = value;
        }
        if (PdfName.TX.equals(type) || PdfName.CH.equals(type)) {
            PdfString v2 = new PdfString(value, "UnicodeBig");
            for (int idx = 0; idx < item.size(); ++idx) {
                PdfDictionary valueDic = item.getValue(idx);
                valueDic.put(PdfName.V, v2);
                valueDic.remove(PdfName.I);
                this.markUsed(valueDic);
                merged = item.getMerged(idx);
                merged.remove(PdfName.I);
                merged.put(PdfName.V, v2);
                PdfDictionary widget = item.getWidget(idx);
                if (this.generateAppearances) {
                    PdfDictionary appDic;
                    PdfAppearance app = this.getAppearance(merged, display, name);
                    if (PdfName.CH.equals(type)) {
                        PdfNumber n2 = new PdfNumber(this.topFirst);
                        widget.put(PdfName.TI, n2);
                        merged.put(PdfName.TI, n2);
                    }
                    if ((appDic = widget.getAsDict(PdfName.AP)) == null) {
                        appDic = new PdfDictionary();
                        widget.put(PdfName.AP, appDic);
                        merged.put(PdfName.AP, appDic);
                    }
                    appDic.put(PdfName.N, app.getIndirectReference());
                    this.writer.releaseTemplate(app);
                } else {
                    widget.remove(PdfName.AP);
                    merged.remove(PdfName.AP);
                }
                this.markUsed(widget);
            }
            return true;
        }
        if (PdfName.BTN.equals(type)) {
            int vidx;
            PdfNumber ff = item.getMerged(0).getAsNumber(PdfName.FF);
            int flags = 0;
            if (ff != null) {
                flags = ff.intValue();
            }
            if ((flags & 0x10000) != 0) {
                Image img;
                try {
                    img = Image.getInstance(Base64.decode(value));
                }
                catch (Exception e2) {
                    return false;
                }
                PushbuttonField pb = this.getNewPushbuttonFromField(name);
                pb.setImage(img);
                this.replacePushbuttonField(name, pb.getField());
                return true;
            }
            PdfName v3 = new PdfName(value);
            ArrayList<String> lopt = new ArrayList<String>();
            PdfArray opts = item.getValue(0).getAsArray(PdfName.OPT);
            if (opts != null) {
                for (int k2 = 0; k2 < opts.size(); ++k2) {
                    PdfString valStr = opts.getAsString(k2);
                    if (valStr != null) {
                        lopt.add(valStr.toUnicodeString());
                        continue;
                    }
                    lopt.add(null);
                }
            }
            PdfName vt = (vidx = lopt.indexOf(value)) >= 0 ? new PdfName(String.valueOf(vidx)) : v3;
            for (int idx = 0; idx < item.size(); ++idx) {
                merged = item.getMerged(idx);
                PdfDictionary widget = item.getWidget(idx);
                PdfDictionary valDict = item.getValue(idx);
                this.markUsed(item.getValue(idx));
                valDict.put(PdfName.V, vt);
                merged.put(PdfName.V, vt);
                this.markUsed(widget);
                PdfDictionary appDic = widget.getAsDict(PdfName.AP);
                if (appDic == null) {
                    return false;
                }
                PdfDictionary normal = appDic.getAsDict(PdfName.N);
                if (this.isInAP(normal, vt) || normal == null) {
                    merged.put(PdfName.AS, vt);
                    widget.put(PdfName.AS, vt);
                } else {
                    merged.put(PdfName.AS, PdfName.Off);
                    widget.put(PdfName.AS, PdfName.Off);
                }
                if (!this.generateAppearances) continue;
                PdfAppearance app = this.getAppearance(merged, display, name);
                if (normal != null) {
                    normal.put(merged.getAsName(PdfName.AS), app.getIndirectReference());
                } else {
                    appDic.put(PdfName.N, app.getIndirectReference());
                }
                this.writer.releaseTemplate(app);
            }
            return true;
        }
        return false;
    }

    public boolean setListSelection(String name, String[] value) throws IOException, DocumentException {
        Item item = this.getFieldItem(name);
        if (item == null) {
            return false;
        }
        PdfDictionary merged = item.getMerged(0);
        PdfName type = merged.getAsName(PdfName.FT);
        if (!PdfName.CH.equals(type)) {
            return false;
        }
        String[] options = this.getListOptionExport(name);
        PdfArray array = new PdfArray();
        block0: for (String element : value) {
            for (int j2 = 0; j2 < options.length; ++j2) {
                if (!options[j2].equals(element)) continue;
                array.add(new PdfNumber(j2));
                continue block0;
            }
        }
        item.writeToAll(PdfName.I, array, 5);
        PdfArray vals = new PdfArray();
        for (int i2 = 0; i2 < value.length; ++i2) {
            vals.add(new PdfString(value[i2]));
        }
        item.writeToAll(PdfName.V, vals, 5);
        PdfAppearance app = this.getAppearance(merged, value, name);
        PdfDictionary apDic = new PdfDictionary();
        apDic.put(PdfName.N, app.getIndirectReference());
        item.writeToAll(PdfName.AP, apDic, 3);
        this.writer.releaseTemplate(app);
        item.markUsed(this, 6);
        return true;
    }

    boolean isInAP(PdfDictionary nDic, PdfName check) {
        return nDic != null && nDic.get(check) != null;
    }

    public Map<String, Item> getFields() {
        return this.fields;
    }

    public Item getFieldItem(String name) {
        if (this.xfa.isXfaPresent() && (name = this.xfa.findFieldName(name, this)) == null) {
            return null;
        }
        return this.fields.get(name);
    }

    public String getTranslatedFieldName(String name) {
        String namex;
        if (this.xfa.isXfaPresent() && (namex = this.xfa.findFieldName(name, this)) != null) {
            name = namex;
        }
        return name;
    }

    public List<FieldPosition> getFieldPositions(String name) {
        Item item = this.getFieldItem(name);
        if (item == null) {
            return null;
        }
        ArrayList<FieldPosition> ret = new ArrayList<FieldPosition>();
        for (int k2 = 0; k2 < item.size(); ++k2) {
            try {
                PdfDictionary wd = item.getWidget(k2);
                PdfArray rect = wd.getAsArray(PdfName.RECT);
                if (rect == null) continue;
                Rectangle r2 = PdfReader.getNormalizedRectangle(rect);
                int page = item.getPage(k2);
                int rotation = this.reader.getPageRotation(page);
                FieldPosition fp = new FieldPosition();
                fp.page = page;
                if (rotation != 0) {
                    Rectangle pageSize = this.reader.getPageSize(page);
                    switch (rotation) {
                        case 270: {
                            r2 = new Rectangle(pageSize.getTop() - r2.getBottom(), r2.getLeft(), pageSize.getTop() - r2.getTop(), r2.getRight());
                            break;
                        }
                        case 180: {
                            r2 = new Rectangle(pageSize.getRight() - r2.getLeft(), pageSize.getTop() - r2.getBottom(), pageSize.getRight() - r2.getRight(), pageSize.getTop() - r2.getTop());
                            break;
                        }
                        case 90: {
                            r2 = new Rectangle(r2.getBottom(), pageSize.getRight() - r2.getLeft(), r2.getTop(), pageSize.getRight() - r2.getRight());
                        }
                    }
                    r2.normalize();
                }
                fp.position = r2;
                ret.add(fp);
                continue;
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
        return ret;
    }

    private int removeRefFromArray(PdfArray array, PdfObject refo) {
        if (refo == null || !refo.isIndirect()) {
            return array.size();
        }
        PdfIndirectReference ref = (PdfIndirectReference)refo;
        for (int j2 = 0; j2 < array.size(); ++j2) {
            PdfObject obj = array.getPdfObject(j2);
            if (!obj.isIndirect() || ((PdfIndirectReference)obj).getNumber() != ref.getNumber()) continue;
            array.remove(j2--);
        }
        return array.size();
    }

    public boolean removeFieldsFromPage(int page) {
        if (page < 1) {
            return false;
        }
        String[] names = new String[this.fields.size()];
        this.fields.keySet().toArray(names);
        boolean found = false;
        for (int k2 = 0; k2 < names.length; ++k2) {
            boolean fr = this.removeField(names[k2], page);
            found = found || fr;
        }
        return found;
    }

    public boolean removeField(String name, int page) {
        Item item = this.getFieldItem(name);
        if (item == null) {
            return false;
        }
        PdfDictionary acroForm = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM), this.reader.getCatalog());
        if (acroForm == null) {
            return false;
        }
        PdfArray arrayf = acroForm.getAsArray(PdfName.FIELDS);
        if (arrayf == null) {
            return false;
        }
        for (int k2 = 0; k2 < item.size(); ++k2) {
            PdfArray kids;
            int pageV = item.getPage(k2);
            if (page != -1 && page != pageV) continue;
            PdfIndirectReference ref = item.getWidgetRef(k2);
            PdfDictionary wd = item.getWidget(k2);
            PdfDictionary pageDic = this.reader.getPageN(pageV);
            PdfArray annots = pageDic.getAsArray(PdfName.ANNOTS);
            if (annots != null) {
                if (this.removeRefFromArray(annots, ref) == 0) {
                    pageDic.remove(PdfName.ANNOTS);
                    this.markUsed(pageDic);
                } else {
                    this.markUsed(annots);
                }
            }
            PdfReader.killIndirect(ref);
            PdfIndirectReference kid = ref;
            while ((ref = wd.getAsIndirectObject(PdfName.PARENT)) != null && this.removeRefFromArray(kids = (wd = wd.getAsDict(PdfName.PARENT)).getAsArray(PdfName.KIDS), kid) == 0) {
                kid = ref;
                PdfReader.killIndirect(ref);
            }
            if (ref == null) {
                this.removeRefFromArray(arrayf, kid);
                this.markUsed(arrayf);
            }
            if (page == -1) continue;
            item.remove(k2);
            --k2;
        }
        if (page == -1 || item.size() == 0) {
            this.fields.remove(name);
        }
        return true;
    }

    public boolean removeField(String name) {
        return this.removeField(name, -1);
    }

    public boolean isGenerateAppearances() {
        return this.generateAppearances;
    }

    public void setGenerateAppearances(boolean generateAppearances) {
        this.generateAppearances = generateAppearances;
        PdfDictionary top = this.reader.getCatalog().getAsDict(PdfName.ACROFORM);
        if (generateAppearances) {
            top.remove(PdfName.NEEDAPPEARANCES);
        } else {
            top.put(PdfName.NEEDAPPEARANCES, PdfBoolean.PDFTRUE);
        }
    }

    public boolean clearSignatureField(String name) {
        this.sigNames = null;
        this.getSignatureNames();
        if (!this.sigNames.containsKey(name)) {
            return false;
        }
        Item sig = this.fields.get(name);
        sig.markUsed(this, 6);
        int n2 = sig.size();
        for (int k2 = 0; k2 < n2; ++k2) {
            AcroFields.clearSigDic(sig.getMerged(k2));
            AcroFields.clearSigDic(sig.getWidget(k2));
            AcroFields.clearSigDic(sig.getValue(k2));
        }
        return true;
    }

    private static void clearSigDic(PdfDictionary dic) {
        dic.remove(PdfName.AP);
        dic.remove(PdfName.AS);
        dic.remove(PdfName.V);
        dic.remove(PdfName.DV);
        dic.remove(PdfName.SV);
        dic.remove(PdfName.FF);
        dic.put(PdfName.F, new PdfNumber(4));
    }

    public ArrayList<String> getSignatureNames() {
        if (this.sigNames != null) {
            return new ArrayList<String>(this.orderedSignatureNames);
        }
        this.sigNames = new HashMap();
        this.orderedSignatureNames = new ArrayList();
        ArrayList<Object[]> sorter = new ArrayList<Object[]>();
        for (Map.Entry<String, Item> entry : this.fields.entrySet()) {
            int rangeSize;
            PdfArray ro;
            PdfString contents;
            PdfDictionary v2;
            Item item = entry.getValue();
            PdfDictionary merged = item.getMerged(0);
            if (!PdfName.SIG.equals(merged.get(PdfName.FT)) || (v2 = merged.getAsDict(PdfName.V)) == null || (contents = v2.getAsString(PdfName.CONTENTS)) == null || (ro = v2.getAsArray(PdfName.BYTERANGE)) == null || (rangeSize = ro.size()) < 2) continue;
            int length = ro.getAsNumber(rangeSize - 1).intValue() + ro.getAsNumber(rangeSize - 2).intValue();
            sorter.add(new Object[]{entry.getKey(), new int[]{length, 0}});
        }
        Collections.sort(sorter, new SorterComparator());
        if (!sorter.isEmpty()) {
            this.totalRevisions = (long)((int[])((Object[])sorter.get(sorter.size() - 1))[1])[0] == this.reader.getFileLength() ? sorter.size() : sorter.size() + 1;
            for (int k2 = 0; k2 < sorter.size(); ++k2) {
                Object[] objs = (Object[])sorter.get(k2);
                String name = (String)objs[0];
                int[] p2 = (int[])objs[1];
                p2[1] = k2 + 1;
                this.sigNames.put(name, p2);
                this.orderedSignatureNames.add(name);
            }
        }
        return new ArrayList<String>(this.orderedSignatureNames);
    }

    public ArrayList<String> getBlankSignatureNames() {
        this.getSignatureNames();
        ArrayList<String> sigs = new ArrayList<String>();
        for (Map.Entry<String, Item> entry : this.fields.entrySet()) {
            Item item = entry.getValue();
            PdfDictionary merged = item.getMerged(0);
            if (!PdfName.SIG.equals(merged.getAsName(PdfName.FT)) || this.sigNames.containsKey(entry.getKey())) continue;
            sigs.add(entry.getKey());
        }
        return sigs;
    }

    public PdfDictionary getSignatureDictionary(String name) {
        this.getSignatureNames();
        name = this.getTranslatedFieldName(name);
        if (!this.sigNames.containsKey(name)) {
            return null;
        }
        Item item = this.fields.get(name);
        PdfDictionary merged = item.getMerged(0);
        return merged.getAsDict(PdfName.V);
    }

    public PdfIndirectReference getNormalAppearance(String name) {
        this.getSignatureNames();
        name = this.getTranslatedFieldName(name);
        Item item = this.fields.get(name);
        if (item == null) {
            return null;
        }
        PdfDictionary merged = item.getMerged(0);
        PdfDictionary ap = merged.getAsDict(PdfName.AP);
        if (ap == null) {
            return null;
        }
        PdfIndirectReference ref = ap.getAsIndirectObject(PdfName.N);
        if (ref == null) {
            return null;
        }
        return ref;
    }

    public boolean signatureCoversWholeDocument(String name) {
        this.getSignatureNames();
        name = this.getTranslatedFieldName(name);
        if (!this.sigNames.containsKey(name)) {
            return false;
        }
        return (long)this.sigNames.get(name)[0] == this.reader.getFileLength();
    }

    public PdfPKCS7 verifySignature(String name) {
        return this.verifySignature(name, null);
    }

    public PdfPKCS7 verifySignature(String name, String provider) {
        PdfDictionary v2 = this.getSignatureDictionary(name);
        if (v2 == null) {
            return null;
        }
        try {
            PdfObject obj;
            PdfName sub = v2.getAsName(PdfName.SUBFILTER);
            PdfString contents = v2.getAsString(PdfName.CONTENTS);
            PdfPKCS7 pk = null;
            if (sub.equals(PdfName.ADBE_X509_RSA_SHA1)) {
                PdfString cert = v2.getAsString(PdfName.CERT);
                if (cert == null) {
                    cert = v2.getAsArray(PdfName.CERT).getAsString(0);
                }
                pk = new PdfPKCS7(contents.getOriginalBytes(), cert.getBytes(), provider);
            } else {
                pk = new PdfPKCS7(contents.getOriginalBytes(), sub, provider);
            }
            this.updateByteRange(pk, v2);
            PdfString str = v2.getAsString(PdfName.M);
            if (str != null) {
                pk.setSignDate(PdfDate.decode(str.toString()));
            }
            if ((obj = PdfReader.getPdfObject(v2.get(PdfName.NAME))) != null) {
                if (obj.isString()) {
                    pk.setSignName(((PdfString)obj).toUnicodeString());
                } else if (obj.isName()) {
                    pk.setSignName(PdfName.decodeName(obj.toString()));
                }
            }
            if ((str = v2.getAsString(PdfName.REASON)) != null) {
                pk.setReason(str.toUnicodeString());
            }
            if ((str = v2.getAsString(PdfName.LOCATION)) != null) {
                pk.setLocation(str.toUnicodeString());
            }
            return pk;
        }
        catch (Exception e2) {
            throw new ExceptionConverter(e2);
        }
    }

    private void updateByteRange(PdfPKCS7 pkcs7, PdfDictionary v2) {
        PdfArray b2 = v2.getAsArray(PdfName.BYTERANGE);
        RandomAccessFileOrArray rf = this.reader.getSafeFile();
        InputStream rg = null;
        try {
            int rd;
            rg = new RASInputStream(new RandomAccessSourceFactory().createRanged(rf.createSourceView(), b2.asLongArray()));
            byte[] buf = new byte[8192];
            while ((rd = rg.read(buf, 0, buf.length)) > 0) {
                pkcs7.update(buf, 0, rd);
            }
        }
        catch (Exception e2) {
            throw new ExceptionConverter(e2);
        }
        finally {
            try {
                if (rg != null) {
                    rg.close();
                }
            }
            catch (IOException e3) {
                throw new ExceptionConverter(e3);
            }
        }
    }

    private void markUsed(PdfObject obj) {
        if (!this.append) {
            return;
        }
        ((PdfStamperImp)this.writer).markUsed(obj);
    }

    public int getTotalRevisions() {
        this.getSignatureNames();
        return this.totalRevisions;
    }

    public int getRevision(String field) {
        this.getSignatureNames();
        field = this.getTranslatedFieldName(field);
        if (!this.sigNames.containsKey(field)) {
            return 0;
        }
        return this.sigNames.get(field)[1];
    }

    public InputStream extractRevision(String field) throws IOException {
        this.getSignatureNames();
        field = this.getTranslatedFieldName(field);
        if (!this.sigNames.containsKey(field)) {
            return null;
        }
        int length = this.sigNames.get(field)[0];
        RandomAccessFileOrArray raf = this.reader.getSafeFile();
        return new RASInputStream(new WindowRandomAccessSource(raf.createSourceView(), 0L, length));
    }

    public Map<String, TextField> getFieldCache() {
        return this.fieldCache;
    }

    public void setFieldCache(Map<String, TextField> fieldCache) {
        this.fieldCache = fieldCache;
    }

    public void setExtraMargin(float extraMarginLeft, float extraMarginTop) {
        this.extraMarginLeft = extraMarginLeft;
        this.extraMarginTop = extraMarginTop;
    }

    public void addSubstitutionFont(BaseFont font) {
        if (this.substitutionFonts == null) {
            this.substitutionFonts = new ArrayList();
        }
        this.substitutionFonts.add(font);
    }

    public ArrayList<BaseFont> getSubstitutionFonts() {
        return this.substitutionFonts;
    }

    public void setSubstitutionFonts(ArrayList<BaseFont> substitutionFonts) {
        this.substitutionFonts = substitutionFonts;
    }

    public XfaForm getXfa() {
        return this.xfa;
    }

    public void removeXfa() {
        PdfDictionary root = this.reader.getCatalog();
        PdfDictionary acroform = root.getAsDict(PdfName.ACROFORM);
        acroform.remove(PdfName.XFA);
        try {
            this.xfa = new XfaForm(this.reader);
        }
        catch (Exception e2) {
            throw new ExceptionConverter(e2);
        }
    }

    public PushbuttonField getNewPushbuttonFromField(String field) {
        return this.getNewPushbuttonFromField(field, 0);
    }

    public PushbuttonField getNewPushbuttonFromField(String field, int order) {
        try {
            if (this.getFieldType(field) != 1) {
                return null;
            }
            Item item = this.getFieldItem(field);
            if (order >= item.size()) {
                return null;
            }
            List<FieldPosition> pos = this.getFieldPositions(field);
            Rectangle box = pos.get((int)order).position;
            PushbuttonField newButton = new PushbuttonField(this.writer, box, null);
            PdfDictionary dic = item.getMerged(order);
            this.decodeGenericDictionary(dic, newButton);
            PdfDictionary mk = dic.getAsDict(PdfName.MK);
            if (mk != null) {
                PdfObject i2;
                PdfDictionary ifit;
                PdfNumber tp;
                PdfString text = mk.getAsString(PdfName.CA);
                if (text != null) {
                    newButton.setText(text.toUnicodeString());
                }
                if ((tp = mk.getAsNumber(PdfName.TP)) != null) {
                    newButton.setLayout(tp.intValue() + 1);
                }
                if ((ifit = mk.getAsDict(PdfName.IF)) != null) {
                    PdfBoolean fb;
                    PdfArray aj;
                    PdfName sw = ifit.getAsName(PdfName.SW);
                    if (sw != null) {
                        int scale = 1;
                        if (sw.equals(PdfName.B)) {
                            scale = 3;
                        } else if (sw.equals(PdfName.S)) {
                            scale = 4;
                        } else if (sw.equals(PdfName.N)) {
                            scale = 2;
                        }
                        newButton.setScaleIcon(scale);
                    }
                    if ((sw = ifit.getAsName(PdfName.S)) != null && sw.equals(PdfName.A)) {
                        newButton.setProportionalIcon(false);
                    }
                    if ((aj = ifit.getAsArray(PdfName.A)) != null && aj.size() == 2) {
                        float left = aj.getAsNumber(0).floatValue();
                        float bottom = aj.getAsNumber(1).floatValue();
                        newButton.setIconHorizontalAdjustment(left);
                        newButton.setIconVerticalAdjustment(bottom);
                    }
                    if ((fb = ifit.getAsBoolean(PdfName.FB)) != null && fb.booleanValue()) {
                        newButton.setIconFitToBounds(true);
                    }
                }
                if ((i2 = mk.get(PdfName.I)) != null && i2.isIndirect()) {
                    newButton.setIconReference((PRIndirectReference)i2);
                }
            }
            return newButton;
        }
        catch (Exception e2) {
            throw new ExceptionConverter(e2);
        }
    }

    public boolean replacePushbuttonField(String field, PdfFormField button) {
        return this.replacePushbuttonField(field, button, 0);
    }

    public boolean replacePushbuttonField(String field, PdfFormField button, int order) {
        if (this.getFieldType(field) != 1) {
            return false;
        }
        Item item = this.getFieldItem(field);
        if (order >= item.size()) {
            return false;
        }
        PdfDictionary merged = item.getMerged(order);
        PdfDictionary values = item.getValue(order);
        PdfDictionary widgets = item.getWidget(order);
        for (int k2 = 0; k2 < buttonRemove.length; ++k2) {
            merged.remove(buttonRemove[k2]);
            values.remove(buttonRemove[k2]);
            widgets.remove(buttonRemove[k2]);
        }
        for (PdfName element : button.getKeys()) {
            PdfName key = element;
            if (key.equals(PdfName.T)) continue;
            if (key.equals(PdfName.FF)) {
                values.put(key, button.get(key));
            } else {
                widgets.put(key, button.get(key));
            }
            merged.put(key, button.get(key));
            this.markUsed(values);
            this.markUsed(widgets);
        }
        return true;
    }

    public boolean doesSignatureFieldExist(String name) {
        return this.getBlankSignatureNames().contains(name) || this.getSignatureNames().contains(name);
    }

    static {
        stdFieldFontNames.put("CoBO", new String[]{"Courier-BoldOblique"});
        stdFieldFontNames.put("CoBo", new String[]{"Courier-Bold"});
        stdFieldFontNames.put("CoOb", new String[]{"Courier-Oblique"});
        stdFieldFontNames.put("Cour", new String[]{"Courier"});
        stdFieldFontNames.put("HeBO", new String[]{"Helvetica-BoldOblique"});
        stdFieldFontNames.put("HeBo", new String[]{"Helvetica-Bold"});
        stdFieldFontNames.put("HeOb", new String[]{"Helvetica-Oblique"});
        stdFieldFontNames.put("Helv", new String[]{"Helvetica"});
        stdFieldFontNames.put("Symb", new String[]{"Symbol"});
        stdFieldFontNames.put("TiBI", new String[]{"Times-BoldItalic"});
        stdFieldFontNames.put("TiBo", new String[]{"Times-Bold"});
        stdFieldFontNames.put("TiIt", new String[]{"Times-Italic"});
        stdFieldFontNames.put("TiRo", new String[]{"Times-Roman"});
        stdFieldFontNames.put("ZaDb", new String[]{"ZapfDingbats"});
        stdFieldFontNames.put("HySm", new String[]{"HYSMyeongJo-Medium", "UniKS-UCS2-H"});
        stdFieldFontNames.put("HyGo", new String[]{"HYGoThic-Medium", "UniKS-UCS2-H"});
        stdFieldFontNames.put("KaGo", new String[]{"HeiseiKakuGo-W5", "UniKS-UCS2-H"});
        stdFieldFontNames.put("KaMi", new String[]{"HeiseiMin-W3", "UniJIS-UCS2-H"});
        stdFieldFontNames.put("MHei", new String[]{"MHei-Medium", "UniCNS-UCS2-H"});
        stdFieldFontNames.put("MSun", new String[]{"MSung-Light", "UniCNS-UCS2-H"});
        stdFieldFontNames.put("STSo", new String[]{"STSong-Light", "UniGB-UCS2-H"});
        buttonRemove = new PdfName[]{PdfName.MK, PdfName.F, PdfName.FF, PdfName.Q, PdfName.BS, PdfName.BORDER};
    }

    public static class FieldPosition {
        public int page;
        public Rectangle position;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SorterComparator
    implements Comparator<Object[]> {
        private SorterComparator() {
        }

        @Override
        public int compare(Object[] o1, Object[] o2) {
            int n1 = ((int[])o1[1])[0];
            int n2 = ((int[])o2[1])[0];
            return n1 - n2;
        }
    }

    private static class InstHit {
        IntHashtable hits;

        public InstHit(int[] inst) {
            if (inst == null) {
                return;
            }
            this.hits = new IntHashtable();
            for (int k2 = 0; k2 < inst.length; ++k2) {
                this.hits.put(inst[k2], 1);
            }
        }

        public boolean isHit(int n2) {
            if (this.hits == null) {
                return true;
            }
            return this.hits.containsKey(n2);
        }
    }

    public static class Item {
        public static final int WRITE_MERGED = 1;
        public static final int WRITE_WIDGET = 2;
        public static final int WRITE_VALUE = 4;
        protected ArrayList<PdfDictionary> values = new ArrayList();
        protected ArrayList<PdfDictionary> widgets = new ArrayList();
        protected ArrayList<PdfIndirectReference> widget_refs = new ArrayList();
        protected ArrayList<PdfDictionary> merged = new ArrayList();
        protected ArrayList<Integer> page = new ArrayList();
        protected ArrayList<Integer> tabOrder = new ArrayList();

        public void writeToAll(PdfName key, PdfObject value, int writeFlags) {
            int i2;
            PdfDictionary curDict = null;
            if ((writeFlags & 1) != 0) {
                for (i2 = 0; i2 < this.merged.size(); ++i2) {
                    curDict = this.getMerged(i2);
                    curDict.put(key, value);
                }
            }
            if ((writeFlags & 2) != 0) {
                for (i2 = 0; i2 < this.widgets.size(); ++i2) {
                    curDict = this.getWidget(i2);
                    curDict.put(key, value);
                }
            }
            if ((writeFlags & 4) != 0) {
                for (i2 = 0; i2 < this.values.size(); ++i2) {
                    curDict = this.getValue(i2);
                    curDict.put(key, value);
                }
            }
        }

        public void markUsed(AcroFields parentFields, int writeFlags) {
            int i2;
            if ((writeFlags & 4) != 0) {
                for (i2 = 0; i2 < this.size(); ++i2) {
                    parentFields.markUsed(this.getValue(i2));
                }
            }
            if ((writeFlags & 2) != 0) {
                for (i2 = 0; i2 < this.size(); ++i2) {
                    parentFields.markUsed(this.getWidget(i2));
                }
            }
        }

        public int size() {
            return this.values.size();
        }

        void remove(int killIdx) {
            this.values.remove(killIdx);
            this.widgets.remove(killIdx);
            this.widget_refs.remove(killIdx);
            this.merged.remove(killIdx);
            this.page.remove(killIdx);
            this.tabOrder.remove(killIdx);
        }

        public PdfDictionary getValue(int idx) {
            return this.values.get(idx);
        }

        void addValue(PdfDictionary value) {
            this.values.add(value);
        }

        public PdfDictionary getWidget(int idx) {
            return this.widgets.get(idx);
        }

        void addWidget(PdfDictionary widget) {
            this.widgets.add(widget);
        }

        public PdfIndirectReference getWidgetRef(int idx) {
            return this.widget_refs.get(idx);
        }

        void addWidgetRef(PdfIndirectReference widgRef) {
            this.widget_refs.add(widgRef);
        }

        public PdfDictionary getMerged(int idx) {
            return this.merged.get(idx);
        }

        void addMerged(PdfDictionary mergeDict) {
            this.merged.add(mergeDict);
        }

        public Integer getPage(int idx) {
            return this.page.get(idx);
        }

        void addPage(int pg) {
            this.page.add(pg);
        }

        void forcePage(int idx, int pg) {
            this.page.set(idx, pg);
        }

        public Integer getTabOrder(int idx) {
            return this.tabOrder.get(idx);
        }

        void addTabOrder(int order) {
            this.tabOrder.add(order);
        }
    }
}

