/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.exceptions.UnsupportedPdfException;
import com.itextpdf.text.pdf.PdfBoolean;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.codec.TIFFFaxDecoder;
import com.itextpdf.text.pdf.codec.TIFFFaxDecompressor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterHandlers {
    private static final Map<PdfName, FilterHandler> defaults;

    public static Map<PdfName, FilterHandler> getDefaultFilterHandlers() {
        return defaults;
    }

    static {
        HashMap<PdfName, FilterHandler> map = new HashMap<PdfName, FilterHandler>();
        map.put(PdfName.FLATEDECODE, new Filter_FLATEDECODE());
        map.put(PdfName.FL, new Filter_FLATEDECODE());
        map.put(PdfName.ASCIIHEXDECODE, new Filter_ASCIIHEXDECODE());
        map.put(PdfName.AHX, new Filter_ASCIIHEXDECODE());
        map.put(PdfName.ASCII85DECODE, new Filter_ASCII85DECODE());
        map.put(PdfName.A85, new Filter_ASCII85DECODE());
        map.put(PdfName.LZWDECODE, new Filter_LZWDECODE());
        map.put(PdfName.CCITTFAXDECODE, new Filter_CCITTFAXDECODE());
        map.put(PdfName.CRYPT, new Filter_DoNothing());
        map.put(PdfName.RUNLENGTHDECODE, new Filter_RUNLENGTHDECODE());
        defaults = Collections.unmodifiableMap(map);
    }

    private static class Filter_RUNLENGTHDECODE
    implements FilterHandler {
        private Filter_RUNLENGTHDECODE() {
        }

        public byte[] decode(byte[] b2, PdfName filterName, PdfObject decodeParams, PdfDictionary streamDictionary) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int dupCount = -1;
            for (int i2 = 0; i2 < b2.length && (dupCount = b2[i2]) != -128; ++i2) {
                if (dupCount >= 0 && dupCount <= 127) {
                    int bytesToCopy = dupCount + 1;
                    baos.write(b2, i2, bytesToCopy);
                    i2 += bytesToCopy;
                    continue;
                }
                ++i2;
                for (int j2 = 0; j2 < 1 - dupCount; ++j2) {
                    baos.write(b2[i2]);
                }
            }
            return baos.toByteArray();
        }
    }

    private static class Filter_DoNothing
    implements FilterHandler {
        private Filter_DoNothing() {
        }

        public byte[] decode(byte[] b2, PdfName filterName, PdfObject decodeParams, PdfDictionary streamDictionary) throws IOException {
            return b2;
        }
    }

    private static class Filter_CCITTFAXDECODE
    implements FilterHandler {
        private Filter_CCITTFAXDECODE() {
        }

        public byte[] decode(byte[] b2, PdfName filterName, PdfObject decodeParams, PdfDictionary streamDictionary) throws IOException {
            PdfNumber wn = (PdfNumber)PdfReader.getPdfObjectRelease(streamDictionary.get(PdfName.WIDTH));
            PdfNumber hn = (PdfNumber)PdfReader.getPdfObjectRelease(streamDictionary.get(PdfName.HEIGHT));
            if (wn == null || hn == null) {
                throw new UnsupportedPdfException(MessageLocalization.getComposedMessage("filter.ccittfaxdecode.is.only.supported.for.images", new Object[0]));
            }
            int width = wn.intValue();
            int height = hn.intValue();
            PdfDictionary param = decodeParams instanceof PdfDictionary ? (PdfDictionary)decodeParams : null;
            int k2 = 0;
            boolean blackIs1 = false;
            boolean byteAlign = false;
            if (param != null) {
                PdfBoolean bo;
                PdfNumber kn = param.getAsNumber(PdfName.K);
                if (kn != null) {
                    k2 = kn.intValue();
                }
                if ((bo = param.getAsBoolean(PdfName.BLACKIS1)) != null) {
                    blackIs1 = bo.booleanValue();
                }
                if ((bo = param.getAsBoolean(PdfName.ENCODEDBYTEALIGN)) != null) {
                    byteAlign = bo.booleanValue();
                }
            }
            byte[] outBuf = new byte[(width + 7) / 8 * height];
            TIFFFaxDecompressor decoder = new TIFFFaxDecompressor();
            if (k2 == 0 || k2 > 0) {
                int tiffT4Options = k2 > 0 ? 1 : 0;
                decoder.SetOptions(1, 3, tiffT4Options |= byteAlign ? 4 : 0, 0);
                decoder.decodeRaw(outBuf, b2, width, height);
                if (decoder.fails > 0) {
                    byte[] outBuf2 = new byte[(width + 7) / 8 * height];
                    int oldFails = decoder.fails;
                    decoder.SetOptions(1, 2, tiffT4Options, 0);
                    decoder.decodeRaw(outBuf2, b2, width, height);
                    if (decoder.fails < oldFails) {
                        outBuf = outBuf2;
                    }
                }
            } else {
                TIFFFaxDecoder deca = new TIFFFaxDecoder(1, width, height);
                deca.decodeT6(outBuf, b2, 0, height, 0L);
            }
            if (!blackIs1) {
                int len = outBuf.length;
                int t2 = 0;
                while (t2 < len) {
                    int n2 = t2++;
                    outBuf[n2] = (byte)(outBuf[n2] ^ 0xFF);
                }
            }
            b2 = outBuf;
            return b2;
        }
    }

    private static class Filter_LZWDECODE
    implements FilterHandler {
        private Filter_LZWDECODE() {
        }

        public byte[] decode(byte[] b2, PdfName filterName, PdfObject decodeParams, PdfDictionary streamDictionary) throws IOException {
            b2 = PdfReader.LZWDecode(b2);
            b2 = PdfReader.decodePredictor(b2, decodeParams);
            return b2;
        }
    }

    private static class Filter_ASCII85DECODE
    implements FilterHandler {
        private Filter_ASCII85DECODE() {
        }

        public byte[] decode(byte[] b2, PdfName filterName, PdfObject decodeParams, PdfDictionary streamDictionary) throws IOException {
            b2 = PdfReader.ASCII85Decode(b2);
            return b2;
        }
    }

    private static class Filter_ASCIIHEXDECODE
    implements FilterHandler {
        private Filter_ASCIIHEXDECODE() {
        }

        public byte[] decode(byte[] b2, PdfName filterName, PdfObject decodeParams, PdfDictionary streamDictionary) throws IOException {
            b2 = PdfReader.ASCIIHexDecode(b2);
            return b2;
        }
    }

    private static class Filter_FLATEDECODE
    implements FilterHandler {
        private Filter_FLATEDECODE() {
        }

        public byte[] decode(byte[] b2, PdfName filterName, PdfObject decodeParams, PdfDictionary streamDictionary) throws IOException {
            b2 = PdfReader.FlateDecode(b2);
            b2 = PdfReader.decodePredictor(b2, decodeParams);
            return b2;
        }
    }

    public static interface FilterHandler {
        public byte[] decode(byte[] var1, PdfName var2, PdfObject var3, PdfDictionary var4) throws IOException;
    }
}

