/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.error_messages.MessageLocalization;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongHashtable
implements Cloneable {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public LongHashtable() {
        this(150, 0.75f);
    }

    public LongHashtable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public LongHashtable(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("illegal.capacity.1", initialCapacity));
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("illegal.load.1", String.valueOf(loadFactor)));
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(long value) {
        Entry[] tab = this.table;
        int i2 = tab.length;
        while (i2-- > 0) {
            Entry e2 = tab[i2];
            while (e2 != null) {
                if (e2.value == value) {
                    return true;
                }
                e2 = e2.next;
            }
        }
        return false;
    }

    public boolean containsValue(long value) {
        return this.contains(value);
    }

    public boolean containsKey(long key) {
        Entry[] tab = this.table;
        int hash = (int)(key ^ key >>> 32);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e2 = tab[index];
        while (e2 != null) {
            if (e2.hash == hash && e2.key == key) {
                return true;
            }
            e2 = e2.next;
        }
        return false;
    }

    public long get(long key) {
        Entry[] tab = this.table;
        int hash = (int)(key ^ key >>> 32);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e2 = tab[index];
        while (e2 != null) {
            if (e2.hash == hash && e2.key == key) {
                return e2.value;
            }
            e2 = e2.next;
        }
        return 0L;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i2 = oldCapacity;
        while (i2-- > 0) {
            Entry old = oldMap[i2];
            while (old != null) {
                Entry e2 = old;
                old = old.next;
                int index = (e2.hash & Integer.MAX_VALUE) % newCapacity;
                e2.next = newMap[index];
                newMap[index] = e2;
            }
        }
    }

    public long put(long key, long value) {
        Entry[] tab = this.table;
        int hash = (int)(key ^ key >>> 32);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e2 = tab[index];
        while (e2 != null) {
            if (e2.hash == hash && e2.key == key) {
                long old = e2.value;
                e2.value = value;
                return old;
            }
            e2 = e2.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = e2 = new Entry(hash, key, value, tab[index]);
        ++this.count;
        return 0L;
    }

    public long remove(long key) {
        Entry[] tab = this.table;
        int hash = (int)(key ^ key >>> 32);
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e2 = tab[index];
        Entry prev = null;
        while (e2 != null) {
            if (e2.hash == hash && e2.key == key) {
                if (prev != null) {
                    prev.next = e2.next;
                } else {
                    tab[index] = e2.next;
                }
                --this.count;
                long oldValue = e2.value;
                e2.value = 0L;
                return oldValue;
            }
            prev = e2;
            e2 = e2.next;
        }
        return 0L;
    }

    public void clear() {
        Entry[] tab = this.table;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.count = 0;
    }

    public Iterator<Entry> getEntryIterator() {
        return new LongHashtableIterator(this.table);
    }

    public long[] toOrderedKeys() {
        long[] res = this.getKeys();
        Arrays.sort(res);
        return res;
    }

    public long[] getKeys() {
        long[] res = new long[this.count];
        int ptr = 0;
        int index = this.table.length;
        Entry entry = null;
        while (true) {
            if (entry == null) {
                while (index-- > 0 && (entry = this.table[index]) == null) {
                }
            }
            if (entry == null) break;
            Entry e2 = entry;
            entry = e2.next;
            res[ptr++] = e2.key;
        }
        return res;
    }

    public long getOneKey() {
        if (this.count == 0) {
            return 0L;
        }
        int index = this.table.length;
        Entry entry = null;
        while (index-- > 0 && (entry = this.table[index]) == null) {
        }
        if (entry == null) {
            return 0L;
        }
        return entry.key;
    }

    public Object clone() {
        try {
            LongHashtable t2 = (LongHashtable)super.clone();
            t2.table = new Entry[this.table.length];
            int i2 = this.table.length;
            while (i2-- > 0) {
                t2.table[i2] = this.table[i2] != null ? (Entry)this.table[i2].clone() : null;
            }
            return t2;
        }
        catch (CloneNotSupportedException e2) {
            throw new InternalError();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LongHashtableIterator
    implements Iterator<Entry> {
        int index;
        Entry[] table;
        Entry entry;

        LongHashtableIterator(Entry[] table) {
            this.table = table;
            this.index = table.length;
        }

        @Override
        public boolean hasNext() {
            if (this.entry != null) {
                return true;
            }
            while (this.index-- > 0) {
                this.entry = this.table[this.index];
                if (this.entry == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public Entry next() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = this.table[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                Entry e2 = this.entry;
                this.entry = e2.next;
                return e2;
            }
            throw new NoSuchElementException(MessageLocalization.getComposedMessage("inthashtableiterator", new Object[0]));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("remove.not.supported", new Object[0]));
        }
    }

    static class Entry {
        int hash;
        long key;
        long value;
        Entry next;

        protected Entry(int hash, long key, long value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        public long getKey() {
            return this.key;
        }

        public long getValue() {
            return this.value;
        }

        protected Object clone() {
            Entry entry = new Entry(this.hash, this.key, this.value, this.next != null ? (Entry)this.next.clone() : null);
            return entry;
        }
    }
}

