/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.log.Counter;
import com.itextpdf.text.log.CounterFactory;
import com.itextpdf.text.pdf.ICC_Profile;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfAConformanceException;
import com.itextpdf.text.pdf.PdfAConformanceLevel;
import com.itextpdf.text.pdf.PdfAStamper;
import com.itextpdf.text.pdf.PdfATtfUnicodeWriter;
import com.itextpdf.text.pdf.PdfAWriter;
import com.itextpdf.text.pdf.PdfAction;
import com.itextpdf.text.pdf.PdfAnnotation;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectObject;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStamperImp;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.TtfUnicodeWriter;
import com.itextpdf.text.pdf.interfaces.PdfAConformance;
import com.itextpdf.text.pdf.interfaces.PdfIsoConformance;
import com.itextpdf.text.pdf.internal.PdfAChecker;
import com.itextpdf.text.pdf.internal.PdfAConformanceImp;
import com.itextpdf.text.xml.xmp.PdfAXmpWriter;
import com.itextpdf.text.xml.xmp.XmpWriter;
import com.itextpdf.xmp.XMPMeta;
import com.itextpdf.xmp.impl.XMPMetaParser;
import com.itextpdf.xmp.properties.XMPProperty;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfAStamperImp
extends PdfStamperImp {
    protected Counter COUNTER = CounterFactory.getCounter(PdfAStamper.class);

    PdfAStamperImp(PdfReader reader, OutputStream os, char pdfVersion, boolean append, PdfAConformanceLevel conformanceLevel) throws DocumentException, IOException {
        super(reader, os, pdfVersion, append);
        ((PdfAConformance)this.pdfIsoConformance).setConformanceLevel(conformanceLevel);
        PdfAWriter.setPdfVersion(this, conformanceLevel);
        this.readPdfAInfo();
    }

    @Override
    protected void readColorProfile() {
        PdfArray outputIntents = this.reader.getCatalog().getAsArray(PdfName.OUTPUTINTENTS);
        if (outputIntents != null && outputIntents.size() > 0) {
            PdfStream iccProfileStream = null;
            for (int i2 = 0; i2 < outputIntents.size(); ++i2) {
                PdfDictionary outputIntentDictionary = outputIntents.getAsDict(i2);
                if (outputIntentDictionary == null) continue;
                PdfName gts = outputIntentDictionary.getAsName(PdfName.S);
                if ((iccProfileStream == null || PdfName.GTS_PDFA1.equals(gts)) && (iccProfileStream = outputIntentDictionary.getAsStream(PdfName.DESTOUTPUTPROFILE)) != null && PdfName.GTS_PDFA1.equals(gts)) break;
            }
            if (iccProfileStream instanceof PRStream) {
                try {
                    this.colorProfile = ICC_Profile.getInstance(PdfReader.getStreamBytes((PRStream)iccProfileStream));
                }
                catch (IOException exc) {
                    throw new ExceptionConverter(exc);
                }
            }
        }
    }

    @Override
    public void setOutputIntents(String outputConditionIdentifier, String outputCondition, String registryName, String info, ICC_Profile colorProfile) throws IOException {
        PdfDictionary d2;
        super.setOutputIntents(outputConditionIdentifier, outputCondition, registryName, info, colorProfile);
        PdfArray a2 = this.extraCatalog.getAsArray(PdfName.OUTPUTINTENTS);
        if (a2 != null && (d2 = a2.getAsDict(0)) != null) {
            d2.put(PdfName.S, PdfName.GTS_PDFA1);
        }
    }

    @Override
    public void setPDFXConformance(int pdfx) {
        throw new PdfAConformanceException(MessageLocalization.getComposedMessage("pdfx.conformance.cannot.be.set.for.PdfAStamperImp.instance", new Object[0]));
    }

    @Override
    protected TtfUnicodeWriter getTtfUnicodeWriter() {
        if (this.ttfUnicodeWriter == null) {
            this.ttfUnicodeWriter = new PdfATtfUnicodeWriter(this, ((PdfAConformance)this.pdfIsoConformance).getConformanceLevel());
        }
        return this.ttfUnicodeWriter;
    }

    @Override
    protected XmpWriter createXmpWriter(ByteArrayOutputStream baos, PdfDictionary info) throws IOException {
        return new PdfAXmpWriter((OutputStream)baos, info, ((PdfAConformance)this.pdfIsoConformance).getConformanceLevel(), (PdfWriter)this);
    }

    @Override
    protected XmpWriter createXmpWriter(ByteArrayOutputStream baos, HashMap<String, String> info) throws IOException {
        return new PdfAXmpWriter((OutputStream)baos, info, ((PdfAConformance)this.pdfIsoConformance).getConformanceLevel(), (PdfWriter)this);
    }

    @Override
    protected PdfIsoConformance initPdfIsoConformance() {
        return new PdfAConformanceImp(this);
    }

    @Override
    protected Counter getCounter() {
        return this.COUNTER;
    }

    private void readPdfAInfo() {
        byte[] metadata = null;
        XMPMeta xmpMeta = null;
        XMPProperty pdfaidConformance = null;
        XMPProperty pdfaidPart = null;
        try {
            metadata = this.reader.getMetadata();
            xmpMeta = XMPMetaParser.parse(metadata, null);
            pdfaidConformance = xmpMeta.getProperty("http://www.aiim.org/pdfa/ns/id/", "pdfaid:conformance");
            pdfaidPart = xmpMeta.getProperty("http://www.aiim.org/pdfa/ns/id/", "pdfaid:part");
        }
        catch (Throwable e2) {
            throw new PdfAConformanceException(MessageLocalization.getComposedMessage("only.pdfa.documents.can.be.opened.in.PdfAStamper", new Object[0]));
        }
        if (pdfaidConformance == null || pdfaidPart == null) {
            throw new PdfAConformanceException(MessageLocalization.getComposedMessage("only.pdfa.documents.can.be.opened.in.PdfAStamper", new Object[0]));
        }
        switch (((PdfAConformance)this.pdfIsoConformance).getConformanceLevel()) {
            case PDF_A_1A: 
            case PDF_A_1B: {
                if ("1".equals(pdfaidPart.getValue())) break;
                throw new PdfAConformanceException(MessageLocalization.getComposedMessage("only.pdfa.1.documents.can.be.opened.in.PdfAStamper", "1"));
            }
            case PDF_A_2A: 
            case PDF_A_2B: 
            case PDF_A_2U: {
                if ("2".equals(pdfaidPart.getValue())) break;
                throw new PdfAConformanceException(MessageLocalization.getComposedMessage("only.pdfa.1.documents.can.be.opened.in.PdfAStamper", "2"));
            }
            case PDF_A_3A: 
            case PDF_A_3B: 
            case PDF_A_3U: {
                if ("3".equals(pdfaidPart.getValue())) break;
                throw new PdfAConformanceException(MessageLocalization.getComposedMessage("only.pdfa.1.documents.can.be.opened.in.PdfAStamper", "3"));
            }
        }
    }

    @Override
    protected void cacheObject(PdfIndirectObject iobj) {
        this.getPdfAChecker().cacheObject(iobj.getIndirectReference(), iobj.object);
    }

    private PdfAChecker getPdfAChecker() {
        return ((PdfAConformanceImp)this.pdfIsoConformance).getPdfAChecker();
    }

    @Override
    protected void close(Map<String, String> moreInfo) throws IOException {
        super.close(moreInfo);
        this.getPdfAChecker().close(this);
    }

    @Override
    public PdfAnnotation createAnnotation(Rectangle rect, PdfName subtype) {
        PdfAnnotation a2 = super.createAnnotation(rect, subtype);
        if (!PdfName.POPUP.equals(subtype)) {
            a2.put(PdfName.F, new PdfNumber(4));
        }
        return a2;
    }

    @Override
    public PdfAnnotation createAnnotation(float llx, float lly, float urx, float ury, PdfString title, PdfString content, PdfName subtype) {
        PdfAnnotation a2 = super.createAnnotation(llx, lly, urx, ury, title, content, subtype);
        if (!PdfName.POPUP.equals(subtype)) {
            a2.put(PdfName.F, new PdfNumber(4));
        }
        return a2;
    }

    @Override
    public PdfAnnotation createAnnotation(float llx, float lly, float urx, float ury, PdfAction action, PdfName subtype) {
        PdfAnnotation a2 = super.createAnnotation(llx, lly, urx, ury, action, subtype);
        if (!PdfName.POPUP.equals(subtype)) {
            a2.put(PdfName.F, new PdfNumber(4));
        }
        return a2;
    }
}

