/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.AccessibleElementId;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.ElementListener;
import com.itextpdf.text.Image;
import com.itextpdf.text.LargeElement;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.api.Spaceable;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.text.pdf.PdfArtifact;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPHeaderCell;
import com.itextpdf.text.pdf.PdfPRow;
import com.itextpdf.text.pdf.PdfPTableBody;
import com.itextpdf.text.pdf.PdfPTableEvent;
import com.itextpdf.text.pdf.PdfPTableFooter;
import com.itextpdf.text.pdf.PdfPTableHeader;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.events.PdfPTableEventForwarder;
import com.itextpdf.text.pdf.interfaces.IAccessibleElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfPTable
implements LargeElement,
Spaceable,
IAccessibleElement {
    private final Logger LOGGER = LoggerFactory.getLogger(PdfPTable.class);
    public static final int BASECANVAS = 0;
    public static final int BACKGROUNDCANVAS = 1;
    public static final int LINECANVAS = 2;
    public static final int TEXTCANVAS = 3;
    protected ArrayList<PdfPRow> rows = new ArrayList();
    protected float totalHeight = 0.0f;
    protected PdfPCell[] currentRow;
    protected int currentColIdx = 0;
    protected PdfPCell defaultCell = new PdfPCell((Phrase)null);
    protected float totalWidth = 0.0f;
    protected float[] relativeWidths;
    protected float[] absoluteWidths;
    protected PdfPTableEvent tableEvent;
    protected int headerRows;
    protected float widthPercentage = 80.0f;
    private int horizontalAlignment = 1;
    private boolean skipFirstHeader = false;
    private boolean skipLastFooter = false;
    protected boolean isColspan = false;
    protected int runDirection = 0;
    private boolean lockedWidth = false;
    private boolean splitRows = true;
    protected float spacingBefore;
    protected float spacingAfter;
    private boolean[] extendLastRow = new boolean[]{false, false};
    private boolean headersInEvent;
    private boolean splitLate = true;
    private boolean keepTogether;
    protected boolean complete = true;
    private int footerRows;
    protected boolean rowCompleted = true;
    protected boolean loopCheck = true;
    protected boolean rowsNotChecked = true;
    protected PdfName role = PdfName.TABLE;
    protected HashMap<PdfName, PdfObject> accessibleAttributes = null;
    protected AccessibleElementId id = new AccessibleElementId();
    private PdfPTableHeader header = null;
    private PdfPTableBody body = null;
    private PdfPTableFooter footer = null;
    private int numberOfWrittenRows;

    protected PdfPTable() {
    }

    public PdfPTable(float[] relativeWidths) {
        if (relativeWidths == null) {
            throw new NullPointerException(MessageLocalization.getComposedMessage("the.widths.array.in.pdfptable.constructor.can.not.be.null", new Object[0]));
        }
        if (relativeWidths.length == 0) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.widths.array.in.pdfptable.constructor.can.not.have.zero.length", new Object[0]));
        }
        this.relativeWidths = new float[relativeWidths.length];
        System.arraycopy(relativeWidths, 0, this.relativeWidths, 0, relativeWidths.length);
        this.absoluteWidths = new float[relativeWidths.length];
        this.calculateWidths();
        this.currentRow = new PdfPCell[this.absoluteWidths.length];
        this.keepTogether = false;
    }

    public PdfPTable(int numColumns) {
        if (numColumns <= 0) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.number.of.columns.in.pdfptable.constructor.must.be.greater.than.zero", new Object[0]));
        }
        this.relativeWidths = new float[numColumns];
        for (int k2 = 0; k2 < numColumns; ++k2) {
            this.relativeWidths[k2] = 1.0f;
        }
        this.absoluteWidths = new float[this.relativeWidths.length];
        this.calculateWidths();
        this.currentRow = new PdfPCell[this.absoluteWidths.length];
        this.keepTogether = false;
    }

    public PdfPTable(PdfPTable table) {
        int k2;
        this.copyFormat(table);
        for (k2 = 0; k2 < this.currentRow.length && table.currentRow[k2] != null; ++k2) {
            this.currentRow[k2] = new PdfPCell(table.currentRow[k2]);
        }
        for (k2 = 0; k2 < table.rows.size(); ++k2) {
            PdfPRow row = table.rows.get(k2);
            if (row != null) {
                row = new PdfPRow(row);
            }
            this.rows.add(row);
        }
    }

    public void init() {
        this.LOGGER.info("Initialize row and cell heights");
        for (PdfPRow row : this.getRows()) {
            if (row == null) continue;
            row.calculated = false;
            for (PdfPCell cell : row.getCells()) {
                if (cell == null) continue;
                cell.setCalculatedHeight(0.0f);
            }
        }
    }

    public static PdfPTable shallowCopy(PdfPTable table) {
        PdfPTable nt = new PdfPTable();
        nt.copyFormat(table);
        return nt;
    }

    protected void copyFormat(PdfPTable sourceTable) {
        this.rowsNotChecked = sourceTable.rowsNotChecked;
        this.relativeWidths = new float[sourceTable.getNumberOfColumns()];
        this.absoluteWidths = new float[sourceTable.getNumberOfColumns()];
        System.arraycopy(sourceTable.relativeWidths, 0, this.relativeWidths, 0, this.getNumberOfColumns());
        System.arraycopy(sourceTable.absoluteWidths, 0, this.absoluteWidths, 0, this.getNumberOfColumns());
        this.totalWidth = sourceTable.totalWidth;
        this.totalHeight = sourceTable.totalHeight;
        this.currentColIdx = 0;
        this.tableEvent = sourceTable.tableEvent;
        this.runDirection = sourceTable.runDirection;
        this.defaultCell = sourceTable.defaultCell instanceof PdfPHeaderCell ? new PdfPHeaderCell((PdfPHeaderCell)sourceTable.defaultCell) : new PdfPCell(sourceTable.defaultCell);
        this.currentRow = new PdfPCell[sourceTable.currentRow.length];
        this.isColspan = sourceTable.isColspan;
        this.splitRows = sourceTable.splitRows;
        this.spacingAfter = sourceTable.spacingAfter;
        this.spacingBefore = sourceTable.spacingBefore;
        this.headerRows = sourceTable.headerRows;
        this.footerRows = sourceTable.footerRows;
        this.lockedWidth = sourceTable.lockedWidth;
        this.extendLastRow = sourceTable.extendLastRow;
        this.headersInEvent = sourceTable.headersInEvent;
        this.widthPercentage = sourceTable.widthPercentage;
        this.splitLate = sourceTable.splitLate;
        this.skipFirstHeader = sourceTable.skipFirstHeader;
        this.skipLastFooter = sourceTable.skipLastFooter;
        this.horizontalAlignment = sourceTable.horizontalAlignment;
        this.keepTogether = sourceTable.keepTogether;
        this.complete = sourceTable.complete;
        this.loopCheck = sourceTable.loopCheck;
        this.id = sourceTable.id;
        this.role = sourceTable.role;
        if (sourceTable.accessibleAttributes != null) {
            this.accessibleAttributes = new HashMap<PdfName, PdfObject>(sourceTable.accessibleAttributes);
        }
        this.header = sourceTable.getHeader();
        this.body = sourceTable.getBody();
        this.footer = sourceTable.getFooter();
    }

    public void setWidths(float[] relativeWidths) throws DocumentException {
        if (relativeWidths.length != this.getNumberOfColumns()) {
            throw new DocumentException(MessageLocalization.getComposedMessage("wrong.number.of.columns", new Object[0]));
        }
        this.relativeWidths = new float[relativeWidths.length];
        System.arraycopy(relativeWidths, 0, this.relativeWidths, 0, relativeWidths.length);
        this.absoluteWidths = new float[relativeWidths.length];
        this.totalHeight = 0.0f;
        this.calculateWidths();
        this.calculateHeights();
    }

    public void setWidths(int[] relativeWidths) throws DocumentException {
        float[] tb = new float[relativeWidths.length];
        for (int k2 = 0; k2 < relativeWidths.length; ++k2) {
            tb[k2] = relativeWidths[k2];
        }
        this.setWidths(tb);
    }

    protected void calculateWidths() {
        int k2;
        if (this.totalWidth <= 0.0f) {
            return;
        }
        float total = 0.0f;
        int numCols = this.getNumberOfColumns();
        for (k2 = 0; k2 < numCols; ++k2) {
            total += this.relativeWidths[k2];
        }
        for (k2 = 0; k2 < numCols; ++k2) {
            this.absoluteWidths[k2] = this.totalWidth * this.relativeWidths[k2] / total;
        }
    }

    public void setTotalWidth(float totalWidth) {
        if (this.totalWidth == totalWidth) {
            return;
        }
        this.totalWidth = totalWidth;
        this.totalHeight = 0.0f;
        this.calculateWidths();
        this.calculateHeights();
    }

    public void setTotalWidth(float[] columnWidth) throws DocumentException {
        if (columnWidth.length != this.getNumberOfColumns()) {
            throw new DocumentException(MessageLocalization.getComposedMessage("wrong.number.of.columns", new Object[0]));
        }
        this.totalWidth = 0.0f;
        for (int k2 = 0; k2 < columnWidth.length; ++k2) {
            this.totalWidth += columnWidth[k2];
        }
        this.setWidths(columnWidth);
    }

    public void setWidthPercentage(float[] columnWidth, Rectangle pageSize) throws DocumentException {
        if (columnWidth.length != this.getNumberOfColumns()) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("wrong.number.of.columns", new Object[0]));
        }
        float totalWidth = 0.0f;
        for (int k2 = 0; k2 < columnWidth.length; ++k2) {
            totalWidth += columnWidth[k2];
        }
        this.widthPercentage = totalWidth / (pageSize.getRight() - pageSize.getLeft()) * 100.0f;
        this.setWidths(columnWidth);
    }

    public float getTotalWidth() {
        return this.totalWidth;
    }

    public float calculateHeights() {
        if (this.totalWidth <= 0.0f) {
            return 0.0f;
        }
        this.totalHeight = 0.0f;
        for (int k2 = 0; k2 < this.rows.size(); ++k2) {
            this.totalHeight += this.getRowHeight(k2, true);
        }
        return this.totalHeight;
    }

    public void resetColumnCount(int newColCount) {
        if (newColCount <= 0) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.number.of.columns.in.pdfptable.constructor.must.be.greater.than.zero", new Object[0]));
        }
        this.relativeWidths = new float[newColCount];
        for (int k2 = 0; k2 < newColCount; ++k2) {
            this.relativeWidths[k2] = 1.0f;
        }
        this.absoluteWidths = new float[this.relativeWidths.length];
        this.calculateWidths();
        this.currentRow = new PdfPCell[this.absoluteWidths.length];
        this.totalHeight = 0.0f;
    }

    public PdfPCell getDefaultCell() {
        return this.defaultCell;
    }

    public PdfPCell addCell(PdfPCell cell) {
        int rdir;
        this.rowCompleted = false;
        PdfPCell ncell = cell instanceof PdfPHeaderCell ? new PdfPHeaderCell((PdfPHeaderCell)cell) : new PdfPCell(cell);
        int colspan = ncell.getColspan();
        colspan = Math.max(colspan, 1);
        colspan = Math.min(colspan, this.currentRow.length - this.currentColIdx);
        ncell.setColspan(colspan);
        if (colspan != 1) {
            this.isColspan = true;
        }
        if ((rdir = ncell.getRunDirection()) == 0) {
            ncell.setRunDirection(this.runDirection);
        }
        this.skipColsWithRowspanAbove();
        boolean cellAdded = false;
        if (this.currentColIdx < this.currentRow.length) {
            this.currentRow[this.currentColIdx] = ncell;
            this.currentColIdx += colspan;
            cellAdded = true;
        }
        this.skipColsWithRowspanAbove();
        while (this.currentColIdx >= this.currentRow.length) {
            int numCols = this.getNumberOfColumns();
            if (this.runDirection == 3) {
                PdfPCell[] rtlRow = new PdfPCell[numCols];
                int rev = this.currentRow.length;
                for (int k2 = 0; k2 < this.currentRow.length; ++k2) {
                    PdfPCell rcell = this.currentRow[k2];
                    int cspan = rcell.getColspan();
                    rtlRow[rev -= cspan] = rcell;
                    k2 += cspan - 1;
                }
                this.currentRow = rtlRow;
            }
            PdfPRow row = new PdfPRow(this.currentRow);
            if (this.totalWidth > 0.0f) {
                row.setWidths(this.absoluteWidths);
                this.totalHeight += row.getMaxHeights();
            }
            this.rows.add(row);
            this.currentRow = new PdfPCell[numCols];
            this.currentColIdx = 0;
            this.skipColsWithRowspanAbove();
            this.rowCompleted = true;
        }
        if (!cellAdded) {
            this.currentRow[this.currentColIdx] = ncell;
            this.currentColIdx += colspan;
        }
        return ncell;
    }

    private void skipColsWithRowspanAbove() {
        int direction = 1;
        if (this.runDirection == 3) {
            direction = -1;
        }
        while (this.rowSpanAbove(this.rows.size(), this.currentColIdx)) {
            this.currentColIdx += direction;
        }
    }

    PdfPCell cellAt(int row, int col) {
        PdfPCell[] cells = this.rows.get(row).getCells();
        for (int i2 = 0; i2 < cells.length; ++i2) {
            if (cells[i2] == null || col < i2 || col >= i2 + cells[i2].getColspan()) continue;
            return cells[i2];
        }
        return null;
    }

    boolean rowSpanAbove(int currRow, int currCol) {
        if (currCol >= this.getNumberOfColumns() || currCol < 0 || currRow < 1) {
            return false;
        }
        int row = currRow - 1;
        PdfPRow aboveRow = this.rows.get(row);
        if (aboveRow == null) {
            return false;
        }
        PdfPCell aboveCell = this.cellAt(row, currCol);
        while (aboveCell == null && row > 0) {
            if ((aboveRow = this.rows.get(--row)) == null) {
                return false;
            }
            aboveCell = this.cellAt(row, currCol);
        }
        int distance = currRow - row;
        if (aboveCell.getRowspan() == 1 && distance > 1) {
            int col = currCol - 1;
            aboveRow = this.rows.get(row + 1);
            --distance;
            aboveCell = aboveRow.getCells()[col];
            while (aboveCell == null && col > 0) {
                aboveCell = aboveRow.getCells()[--col];
            }
        }
        return aboveCell != null && aboveCell.getRowspan() > distance;
    }

    public void addCell(String text) {
        this.addCell(new Phrase(text));
    }

    public void addCell(PdfPTable table) {
        this.defaultCell.setTable(table);
        PdfPCell newCell = this.addCell(this.defaultCell);
        newCell.id = new AccessibleElementId();
        this.defaultCell.setTable(null);
    }

    public void addCell(Image image) {
        this.defaultCell.setImage(image);
        PdfPCell newCell = this.addCell(this.defaultCell);
        newCell.id = new AccessibleElementId();
        this.defaultCell.setImage(null);
    }

    public void addCell(Phrase phrase) {
        this.defaultCell.setPhrase(phrase);
        PdfPCell newCell = this.addCell(this.defaultCell);
        newCell.id = new AccessibleElementId();
        this.defaultCell.setPhrase(null);
    }

    public float writeSelectedRows(int rowStart, int rowEnd, float xPos, float yPos, PdfContentByte[] canvases) {
        return this.writeSelectedRows(0, -1, rowStart, rowEnd, xPos, yPos, canvases);
    }

    public float writeSelectedRows(int colStart, int colEnd, int rowStart, int rowEnd, float xPos, float yPos, PdfContentByte[] canvases) {
        return this.writeSelectedRows(colStart, colEnd, rowStart, rowEnd, xPos, yPos, canvases, true);
    }

    public float writeSelectedRows(int colStart, int colEnd, int rowStart, int rowEnd, float xPos, float yPos, PdfContentByte[] canvases, boolean reusable) {
        if (this.totalWidth <= 0.0f) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("the.table.width.must.be.greater.than.zero", new Object[0]));
        }
        int totalRows = this.rows.size();
        if (rowStart < 0) {
            rowStart = 0;
        }
        if (rowStart >= (rowEnd = rowEnd < 0 ? totalRows : Math.min(rowEnd, totalRows))) {
            return yPos;
        }
        int totalCols = this.getNumberOfColumns();
        colStart = colStart < 0 ? 0 : Math.min(colStart, totalCols);
        colEnd = colEnd < 0 ? totalCols : Math.min(colEnd, totalCols);
        this.LOGGER.info(String.format("Writing row %s to %s; column %s to %s", rowStart, rowEnd, colStart, colEnd));
        float yPosStart = yPos;
        PdfPTableBody currentBlock = null;
        if (this.rowsNotChecked) {
            this.getFittingRows(Float.MAX_VALUE, rowStart);
        }
        ArrayList<PdfPRow> rows = this.getRows(rowStart, rowEnd);
        int k2 = rowStart;
        for (PdfPRow row : rows) {
            if (this.getHeader().rows != null && this.getHeader().rows.contains(row) && currentBlock == null) {
                currentBlock = this.openTableBlock(this.getHeader(), canvases[3]);
            } else if (this.getBody().rows != null && this.getBody().rows.contains(row) && currentBlock == null) {
                currentBlock = this.openTableBlock(this.getBody(), canvases[3]);
            } else if (this.getFooter().rows != null && this.getFooter().rows.contains(row) && currentBlock == null) {
                currentBlock = this.openTableBlock(this.getFooter(), canvases[3]);
            }
            if (row != null) {
                row.writeCells(colStart, colEnd, xPos, yPos, canvases, reusable);
                yPos -= row.getMaxHeights();
            }
            if (this.getHeader().rows != null && this.getHeader().rows.contains(row) && (k2 == rowEnd - 1 || !this.getHeader().rows.contains(rows.get(k2 + 1)))) {
                currentBlock = this.closeTableBlock(this.getHeader(), canvases[3]);
            } else if (this.getBody().rows != null && this.getBody().rows.contains(row) && (k2 == rowEnd - 1 || !this.getBody().rows.contains(rows.get(k2 + 1)))) {
                currentBlock = this.closeTableBlock(this.getBody(), canvases[3]);
            } else if (this.getFooter().rows != null && this.getFooter().rows.contains(row) && (k2 == rowEnd - 1 || !this.getFooter().rows.contains(rows.get(k2 + 1)))) {
                currentBlock = this.closeTableBlock(this.getFooter(), canvases[3]);
            }
            ++k2;
        }
        if (this.tableEvent != null && colStart == 0 && colEnd == totalCols) {
            float[] heights = new float[rowEnd - rowStart + 1];
            heights[0] = yPosStart;
            for (k2 = rowStart; k2 < rowEnd; ++k2) {
                PdfPRow row;
                row = (PdfPRow)rows.get(k2);
                float hr = 0.0f;
                if (row != null) {
                    hr = row.getMaxHeights();
                }
                heights[k2 - rowStart + 1] = heights[k2 - rowStart] - hr;
            }
            this.tableEvent.tableLayout(this, this.getEventWidths(xPos, rowStart, rowEnd, this.headersInEvent), heights, this.headersInEvent ? this.headerRows : 0, rowStart, canvases);
        }
        return yPos;
    }

    private PdfPTableBody openTableBlock(PdfPTableBody block, PdfContentByte canvas) {
        if (canvas.writer.getStandardStructElems().contains(block.getRole())) {
            canvas.openMCBlock(block);
            return block;
        }
        return null;
    }

    private PdfPTableBody closeTableBlock(PdfPTableBody block, PdfContentByte canvas) {
        if (canvas.writer.getStandardStructElems().contains(block.getRole())) {
            canvas.closeMCBlock(block);
        }
        return null;
    }

    public float writeSelectedRows(int rowStart, int rowEnd, float xPos, float yPos, PdfContentByte canvas) {
        return this.writeSelectedRows(0, -1, rowStart, rowEnd, xPos, yPos, canvas);
    }

    public float writeSelectedRows(int colStart, int colEnd, int rowStart, int rowEnd, float xPos, float yPos, PdfContentByte canvas) {
        return this.writeSelectedRows(colStart, colEnd, rowStart, rowEnd, xPos, yPos, canvas, true);
    }

    public float writeSelectedRows(int colStart, int colEnd, int rowStart, int rowEnd, float xPos, float yPos, PdfContentByte canvas, boolean reusable) {
        boolean clip;
        int totalCols = this.getNumberOfColumns();
        colStart = colStart < 0 ? 0 : Math.min(colStart, totalCols);
        colEnd = colEnd < 0 ? totalCols : Math.min(colEnd, totalCols);
        boolean bl = clip = colStart != 0 || colEnd != totalCols;
        if (clip) {
            float w2 = 0.0f;
            for (int k2 = colStart; k2 < colEnd; ++k2) {
                w2 += this.absoluteWidths[k2];
            }
            canvas.saveState();
            float lx = colStart == 0 ? 10000.0f : 0.0f;
            float rx = colEnd == totalCols ? 10000.0f : 0.0f;
            canvas.rectangle(xPos - lx, -10000.0f, w2 + lx + rx, 20000.0f);
            canvas.clip();
            canvas.newPath();
        }
        PdfContentByte[] canvases = PdfPTable.beginWritingRows(canvas);
        float y = this.writeSelectedRows(colStart, colEnd, rowStart, rowEnd, xPos, yPos, canvases, reusable);
        PdfPTable.endWritingRows(canvases);
        if (clip) {
            canvas.restoreState();
        }
        return y;
    }

    public static PdfContentByte[] beginWritingRows(PdfContentByte canvas) {
        return new PdfContentByte[]{canvas, canvas.getDuplicate(), canvas.getDuplicate(), canvas.getDuplicate()};
    }

    public static void endWritingRows(PdfContentByte[] canvases) {
        PdfContentByte canvas = canvases[0];
        PdfArtifact artifact = new PdfArtifact();
        canvas.openMCBlock(artifact);
        canvas.saveState();
        canvas.add(canvases[1]);
        canvas.restoreState();
        canvas.saveState();
        canvas.setLineCap(2);
        canvas.resetRGBColorStroke();
        canvas.add(canvases[2]);
        canvas.restoreState();
        canvas.closeMCBlock(artifact);
        canvas.add(canvases[3]);
    }

    public int size() {
        return this.rows.size();
    }

    public float getTotalHeight() {
        return this.totalHeight;
    }

    public float getRowHeight(int idx) {
        return this.getRowHeight(idx, false);
    }

    protected float getRowHeight(int idx, boolean firsttime) {
        if (this.totalWidth <= 0.0f || idx < 0 || idx >= this.rows.size()) {
            return 0.0f;
        }
        PdfPRow row = this.rows.get(idx);
        if (row == null) {
            return 0.0f;
        }
        if (firsttime) {
            row.setWidths(this.absoluteWidths);
        }
        float height = row.getMaxHeights();
        for (int i2 = 0; i2 < this.relativeWidths.length; ++i2) {
            if (!this.rowSpanAbove(idx, i2)) continue;
            int rs = 1;
            while (this.rowSpanAbove(idx - rs, i2)) {
                ++rs;
            }
            PdfPRow tmprow = this.rows.get(idx - rs);
            PdfPCell cell = tmprow.getCells()[i2];
            float tmp = 0.0f;
            if (cell != null && cell.getRowspan() == rs + 1) {
                tmp = cell.getMaxHeight();
                while (rs > 0) {
                    tmp -= this.getRowHeight(idx - rs);
                    --rs;
                }
            }
            if (!(tmp > height)) continue;
            height = tmp;
        }
        row.setMaxHeights(height);
        return height;
    }

    public float getRowspanHeight(int rowIndex, int cellIndex) {
        if (this.totalWidth <= 0.0f || rowIndex < 0 || rowIndex >= this.rows.size()) {
            return 0.0f;
        }
        PdfPRow row = this.rows.get(rowIndex);
        if (row == null || cellIndex >= row.getCells().length) {
            return 0.0f;
        }
        PdfPCell cell = row.getCells()[cellIndex];
        if (cell == null) {
            return 0.0f;
        }
        float rowspanHeight = 0.0f;
        for (int j2 = 0; j2 < cell.getRowspan(); ++j2) {
            rowspanHeight += this.getRowHeight(rowIndex + j2);
        }
        return rowspanHeight;
    }

    public boolean hasRowspan(int rowIdx) {
        PdfPRow previousRow;
        if (rowIdx < this.rows.size() && this.getRow(rowIdx).hasRowspan()) {
            return true;
        }
        PdfPRow pdfPRow = previousRow = rowIdx > 0 ? this.getRow(rowIdx - 1) : null;
        if (previousRow != null && previousRow.hasRowspan()) {
            return true;
        }
        for (int i2 = 0; i2 < this.getNumberOfColumns(); ++i2) {
            if (!this.rowSpanAbove(rowIdx - 1, i2)) continue;
            return true;
        }
        return false;
    }

    public void normalizeHeadersFooters() {
        if (this.footerRows > this.headerRows) {
            this.footerRows = this.headerRows;
        }
    }

    public float getHeaderHeight() {
        float total = 0.0f;
        int size = Math.min(this.rows.size(), this.headerRows);
        for (int k2 = 0; k2 < size; ++k2) {
            PdfPRow row = this.rows.get(k2);
            if (row == null) continue;
            total += row.getMaxHeights();
        }
        return total;
    }

    public float getFooterHeight() {
        float total = 0.0f;
        int start = Math.max(0, this.headerRows - this.footerRows);
        int size = Math.min(this.rows.size(), this.headerRows);
        for (int k2 = start; k2 < size; ++k2) {
            PdfPRow row = this.rows.get(k2);
            if (row == null) continue;
            total += row.getMaxHeights();
        }
        return total;
    }

    public boolean deleteRow(int rowNumber) {
        PdfPRow row;
        if (rowNumber < 0 || rowNumber >= this.rows.size()) {
            return false;
        }
        if (this.totalWidth > 0.0f && (row = this.rows.get(rowNumber)) != null) {
            this.totalHeight -= row.getMaxHeights();
        }
        this.rows.remove(rowNumber);
        if (rowNumber < this.headerRows) {
            --this.headerRows;
            if (rowNumber >= this.headerRows - this.footerRows) {
                --this.footerRows;
            }
        }
        return true;
    }

    public boolean deleteLastRow() {
        return this.deleteRow(this.rows.size() - 1);
    }

    public void deleteBodyRows() {
        ArrayList<PdfPRow> rows2 = new ArrayList<PdfPRow>();
        for (int k2 = 0; k2 < this.headerRows; ++k2) {
            rows2.add(this.rows.get(k2));
        }
        this.rows = rows2;
        this.totalHeight = 0.0f;
        if (this.totalWidth > 0.0f) {
            this.totalHeight = this.getHeaderHeight();
        }
    }

    public int getNumberOfColumns() {
        return this.relativeWidths.length;
    }

    public int getHeaderRows() {
        return this.headerRows;
    }

    public void setHeaderRows(int headerRows) {
        if (headerRows < 0) {
            headerRows = 0;
        }
        this.headerRows = headerRows;
    }

    @Override
    public List<Chunk> getChunks() {
        return new ArrayList<Chunk>();
    }

    @Override
    public int type() {
        return 23;
    }

    @Override
    public boolean isContent() {
        return true;
    }

    @Override
    public boolean isNestable() {
        return true;
    }

    @Override
    public boolean process(ElementListener listener) {
        try {
            return listener.add(this);
        }
        catch (DocumentException de) {
            return false;
        }
    }

    public String getSummary() {
        return this.getAccessibleAttribute(PdfName.SUMMARY).toString();
    }

    public void setSummary(String summary) {
        this.setAccessibleAttribute(PdfName.SUMMARY, new PdfString(summary));
    }

    public float getWidthPercentage() {
        return this.widthPercentage;
    }

    public void setWidthPercentage(float widthPercentage) {
        this.widthPercentage = widthPercentage;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public PdfPRow getRow(int idx) {
        return this.rows.get(idx);
    }

    public ArrayList<PdfPRow> getRows() {
        return this.rows;
    }

    public int getLastCompletedRowIndex() {
        return this.rows.size() - 1;
    }

    public void setBreakPoints(int ... breakPoints) {
        this.keepRowsTogether(0, this.rows.size());
        for (int i2 = 0; i2 < breakPoints.length; ++i2) {
            this.getRow(breakPoints[i2]).setMayNotBreak(false);
        }
    }

    public void keepRowsTogether(int[] rows) {
        for (int i2 = 0; i2 < rows.length; ++i2) {
            this.getRow(rows[i2]).setMayNotBreak(true);
        }
    }

    public void keepRowsTogether(int start, int end) {
        if (start < end) {
            while (start < end) {
                this.getRow(start).setMayNotBreak(true);
                ++start;
            }
        }
    }

    public void keepRowsTogether(int start) {
        this.keepRowsTogether(start, this.rows.size());
    }

    public ArrayList<PdfPRow> getRows(int start, int end) {
        ArrayList<PdfPRow> list = new ArrayList<PdfPRow>();
        if (start < 0 || end > this.size()) {
            return list;
        }
        for (int i2 = start; i2 < end; ++i2) {
            list.add(this.adjustCellsInRow(i2, end));
        }
        return list;
    }

    protected PdfPRow adjustCellsInRow(int start, int end) {
        PdfPRow row = this.getRow(start);
        if (row.isAdjusted()) {
            return row;
        }
        row = new PdfPRow(row);
        PdfPCell[] cells = row.getCells();
        for (int i2 = 0; i2 < cells.length; ++i2) {
            PdfPCell cell = cells[i2];
            if (cell == null || cell.getRowspan() == 1) continue;
            int stop = Math.min(end, start + cell.getRowspan());
            float extra = 0.0f;
            for (int k2 = start + 1; k2 < stop; ++k2) {
                extra += this.getRow(k2).getMaxHeights();
            }
            row.setExtraHeight(i2, extra);
        }
        row.setAdjusted(true);
        return row;
    }

    public void setTableEvent(PdfPTableEvent event) {
        if (event == null) {
            this.tableEvent = null;
        } else if (this.tableEvent == null) {
            this.tableEvent = event;
        } else if (this.tableEvent instanceof PdfPTableEventForwarder) {
            ((PdfPTableEventForwarder)this.tableEvent).addTableEvent(event);
        } else {
            PdfPTableEventForwarder forward = new PdfPTableEventForwarder();
            forward.addTableEvent(this.tableEvent);
            forward.addTableEvent(event);
            this.tableEvent = forward;
        }
    }

    public PdfPTableEvent getTableEvent() {
        return this.tableEvent;
    }

    public float[] getAbsoluteWidths() {
        return this.absoluteWidths;
    }

    float[][] getEventWidths(float xPos, int firstRow, int lastRow, boolean includeHeaders) {
        if (includeHeaders) {
            firstRow = Math.max(firstRow, this.headerRows);
            lastRow = Math.max(lastRow, this.headerRows);
        }
        float[][] widths = new float[(includeHeaders ? this.headerRows : 0) + lastRow - firstRow][];
        if (this.isColspan) {
            int n2 = 0;
            if (includeHeaders) {
                for (int k2 = 0; k2 < this.headerRows; ++k2) {
                    PdfPRow row = this.rows.get(k2);
                    if (row == null) {
                        ++n2;
                        continue;
                    }
                    widths[n2++] = row.getEventWidth(xPos, this.absoluteWidths);
                }
            }
            while (firstRow < lastRow) {
                PdfPRow row = this.rows.get(firstRow);
                if (row == null) {
                    ++n2;
                } else {
                    widths[n2++] = row.getEventWidth(xPos, this.absoluteWidths);
                }
                ++firstRow;
            }
        } else {
            int k3;
            int numCols = this.getNumberOfColumns();
            float[] width = new float[numCols + 1];
            width[0] = xPos;
            for (k3 = 0; k3 < numCols; ++k3) {
                width[k3 + 1] = width[k3] + this.absoluteWidths[k3];
            }
            for (k3 = 0; k3 < widths.length; ++k3) {
                widths[k3] = width;
            }
        }
        return widths;
    }

    public boolean isSkipFirstHeader() {
        return this.skipFirstHeader;
    }

    public boolean isSkipLastFooter() {
        return this.skipLastFooter;
    }

    public void setSkipFirstHeader(boolean skipFirstHeader) {
        this.skipFirstHeader = skipFirstHeader;
    }

    public void setSkipLastFooter(boolean skipLastFooter) {
        this.skipLastFooter = skipLastFooter;
    }

    public void setRunDirection(int runDirection) {
        switch (runDirection) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.runDirection = runDirection;
                break;
            }
            default: {
                throw new RuntimeException(MessageLocalization.getComposedMessage("invalid.run.direction.1", runDirection));
            }
        }
    }

    public int getRunDirection() {
        return this.runDirection;
    }

    public boolean isLockedWidth() {
        return this.lockedWidth;
    }

    public void setLockedWidth(boolean lockedWidth) {
        this.lockedWidth = lockedWidth;
    }

    public boolean isSplitRows() {
        return this.splitRows;
    }

    public void setSplitRows(boolean splitRows) {
        this.splitRows = splitRows;
    }

    @Override
    public void setSpacingBefore(float spacing) {
        this.spacingBefore = spacing;
    }

    @Override
    public void setSpacingAfter(float spacing) {
        this.spacingAfter = spacing;
    }

    public float spacingBefore() {
        return this.spacingBefore;
    }

    public float spacingAfter() {
        return this.spacingAfter;
    }

    public boolean isExtendLastRow() {
        return this.extendLastRow[0];
    }

    public void setExtendLastRow(boolean extendLastRows) {
        this.extendLastRow[0] = extendLastRows;
        this.extendLastRow[1] = extendLastRows;
    }

    public void setExtendLastRow(boolean extendLastRows, boolean extendFinalRow) {
        this.extendLastRow[0] = extendLastRows;
        this.extendLastRow[1] = extendFinalRow;
    }

    public boolean isExtendLastRow(boolean newPageFollows) {
        if (newPageFollows) {
            return this.extendLastRow[0];
        }
        return this.extendLastRow[1];
    }

    public boolean isHeadersInEvent() {
        return this.headersInEvent;
    }

    public void setHeadersInEvent(boolean headersInEvent) {
        this.headersInEvent = headersInEvent;
    }

    public boolean isSplitLate() {
        return this.splitLate;
    }

    public void setSplitLate(boolean splitLate) {
        this.splitLate = splitLate;
    }

    public void setKeepTogether(boolean keepTogether) {
        this.keepTogether = keepTogether;
    }

    public boolean getKeepTogether() {
        return this.keepTogether;
    }

    public int getFooterRows() {
        return this.footerRows;
    }

    public void setFooterRows(int footerRows) {
        if (footerRows < 0) {
            footerRows = 0;
        }
        this.footerRows = footerRows;
    }

    public void completeRow() {
        while (!this.rowCompleted) {
            this.addCell(this.defaultCell);
        }
    }

    @Override
    public void flushContent() {
        this.deleteBodyRows();
        if (this.numberOfWrittenRows > 0) {
            this.setSkipFirstHeader(true);
        }
    }

    void addNumberOfRowsWritten(int numberOfWrittenRows) {
        this.numberOfWrittenRows += numberOfWrittenRows;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    @Override
    public float getSpacingBefore() {
        return this.spacingBefore;
    }

    @Override
    public float getSpacingAfter() {
        return this.spacingAfter;
    }

    public boolean isLoopCheck() {
        return this.loopCheck;
    }

    public void setLoopCheck(boolean loopCheck) {
        this.loopCheck = loopCheck;
    }

    @Override
    public PdfObject getAccessibleAttribute(PdfName key) {
        if (this.accessibleAttributes != null) {
            return this.accessibleAttributes.get(key);
        }
        return null;
    }

    @Override
    public void setAccessibleAttribute(PdfName key, PdfObject value) {
        if (this.accessibleAttributes == null) {
            this.accessibleAttributes = new HashMap();
        }
        this.accessibleAttributes.put(key, value);
    }

    @Override
    public HashMap<PdfName, PdfObject> getAccessibleAttributes() {
        return this.accessibleAttributes;
    }

    @Override
    public PdfName getRole() {
        return this.role;
    }

    @Override
    public void setRole(PdfName role) {
        this.role = role;
    }

    @Override
    public AccessibleElementId getId() {
        return this.id;
    }

    @Override
    public void setId(AccessibleElementId id) {
        this.id = id;
    }

    @Override
    public boolean isInline() {
        return false;
    }

    public PdfPTableHeader getHeader() {
        if (this.header == null) {
            this.header = new PdfPTableHeader();
        }
        return this.header;
    }

    public PdfPTableBody getBody() {
        if (this.body == null) {
            this.body = new PdfPTableBody();
        }
        return this.body;
    }

    public PdfPTableFooter getFooter() {
        if (this.footer == null) {
            this.footer = new PdfPTableFooter();
        }
        return this.footer;
    }

    public int getCellStartRowIndex(int rowIdx, int colIdx) {
        int lastRow;
        for (lastRow = rowIdx; this.getRow(lastRow).getCells()[colIdx] == null && lastRow > 0; --lastRow) {
        }
        return lastRow;
    }

    public FittingRows getFittingRows(float availableHeight, int startIdx) {
        int k2;
        this.LOGGER.info(String.format("getFittingRows(%s, %s)", Float.valueOf(availableHeight), startIdx));
        assert (this.getRow(startIdx).getCells()[0] != null);
        int cols = this.getNumberOfColumns();
        ColumnMeasurementState[] states = new ColumnMeasurementState[cols];
        for (int i2 = 0; i2 < cols; ++i2) {
            states[i2] = new ColumnMeasurementState();
        }
        float completedRowsHeight = 0.0f;
        float totalHeight = 0.0f;
        HashMap<Integer, Float> correctedHeightsForLastRow = new HashMap<Integer, Float>();
        for (k2 = startIdx; k2 < this.size(); ++k2) {
            ColumnMeasurementState state;
            PdfPRow row = this.getRow(k2);
            float rowHeight = row.getMaxRowHeightsWithoutCalculating();
            float maxCompletedRowsHeight = 0.0f;
            for (int i3 = 0; i3 < cols; i3 += state.colspan) {
                PdfPCell cell = row.getCells()[i3];
                state = states[i3];
                if (cell == null) {
                    state.consumeRowspan(completedRowsHeight, rowHeight);
                } else {
                    state.beginCell(cell, completedRowsHeight, rowHeight);
                    this.LOGGER.info(String.format("Height after beginCell: %s (cell: %s)", Float.valueOf(state.height), Float.valueOf(cell.getMaxHeight())));
                }
                if (state.cellEnds() && state.height > maxCompletedRowsHeight) {
                    maxCompletedRowsHeight = state.height;
                }
                for (int j2 = 1; j2 < state.colspan; ++j2) {
                    states[i3 + j2].height = state.height;
                }
            }
            float maxTotalHeight = 0.0f;
            for (ColumnMeasurementState state2 : states) {
                if (!(state2.height > maxTotalHeight)) continue;
                maxTotalHeight = state2.height;
            }
            row.setFinalMaxHeights(maxCompletedRowsHeight - completedRowsHeight);
            float remainingHeight = availableHeight - (this.isSplitLate() ? maxTotalHeight : maxCompletedRowsHeight);
            if (remainingHeight < 0.0f) break;
            correctedHeightsForLastRow.put(k2, Float.valueOf(maxTotalHeight - completedRowsHeight));
            completedRowsHeight = maxCompletedRowsHeight;
            totalHeight = maxTotalHeight;
        }
        this.rowsNotChecked = false;
        return new FittingRows(startIdx, k2 - 1, totalHeight, completedRowsHeight, correctedHeightsForLastRow);
    }

    public static class ColumnMeasurementState {
        public float height = 0.0f;
        public int rowspan = 1;
        public int colspan = 1;

        public void beginCell(PdfPCell cell, float completedRowsHeight, float rowHeight) {
            this.rowspan = cell.getRowspan();
            this.colspan = cell.getColspan();
            this.height = completedRowsHeight + Math.max(cell.getMaxHeight(), rowHeight);
        }

        public void consumeRowspan(float completedRowsHeight, float rowHeight) {
            --this.rowspan;
        }

        public boolean cellEnds() {
            return this.rowspan == 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FittingRows {
        public final int firstRow;
        public final int lastRow;
        public final float height;
        public final float completedRowsHeight;
        private final Map<Integer, Float> correctedHeightsForLastRow;

        public FittingRows(int firstRow, int lastRow, float height, float completedRowsHeight, Map<Integer, Float> correctedHeightsForLastRow) {
            this.firstRow = firstRow;
            this.lastRow = lastRow;
            this.height = height;
            this.completedRowsHeight = completedRowsHeight;
            this.correctedHeightsForLastRow = correctedHeightsForLastRow;
        }

        public void correctLastRowChosen(PdfPTable table, int k2) {
            PdfPRow row = table.getRow(k2);
            Float value = this.correctedHeightsForLastRow.get(k2);
            if (value != null) {
                row.setFinalMaxHeights(value.floatValue());
            }
        }
    }
}

