/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.CFFFontSubset;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectObject;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import com.itextpdf.text.pdf.TrueTypeFontUnicode;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class TtfUnicodeWriter {
    protected PdfWriter writer = null;

    public TtfUnicodeWriter(PdfWriter writer) {
        this.writer = writer;
    }

    public void writeFont(TrueTypeFontUnicode font, PdfIndirectReference ref, Object[] params, byte[] rotbits) throws DocumentException, IOException {
        byte[] b2;
        HashMap longTag = (HashMap)params[0];
        font.addRangeUni(longTag, true, font.subset);
        int[][] metrics = (int[][])longTag.values().toArray((T[])new int[0][]);
        Arrays.sort(metrics, font);
        PdfIndirectReference ind_font = null;
        PdfDictionary pobj = null;
        PdfIndirectObject obj = null;
        if (font.cff) {
            b2 = font.readCffFont();
            if (font.subset || font.subsetRanges != null) {
                CFFFontSubset cff = new CFFFontSubset(new RandomAccessFileOrArray(b2), longTag);
                b2 = cff.Process(cff.getNames()[0]);
            }
            pobj = new BaseFont.StreamFont(b2, "CIDFontType0C", font.compressionLevel);
            obj = this.writer.addToBody(pobj);
            ind_font = obj.getIndirectReference();
        } else {
            b2 = font.subset || font.directoryOffset != 0 ? font.getSubSet(new HashSet(longTag.keySet()), true) : font.getFullFont();
            int[] lengths = new int[]{b2.length};
            pobj = new BaseFont.StreamFont(b2, lengths, font.compressionLevel);
            obj = this.writer.addToBody(pobj);
            ind_font = obj.getIndirectReference();
        }
        String subsetPrefix = "";
        if (font.subset) {
            subsetPrefix = font.createSubsetPrefix();
        }
        PdfDictionary dic = font.getFontDescriptor(ind_font, subsetPrefix, null);
        obj = this.writer.addToBody(dic);
        ind_font = obj.getIndirectReference();
        pobj = font.getCIDFontType2(ind_font, subsetPrefix, (Object[])metrics);
        obj = this.writer.addToBody(pobj);
        ind_font = obj.getIndirectReference();
        pobj = font.getToUnicode((Object[])metrics);
        PdfIndirectReference toUnicodeRef = null;
        if (pobj != null) {
            obj = this.writer.addToBody(pobj);
            toUnicodeRef = obj.getIndirectReference();
        }
        pobj = font.getFontBaseType(ind_font, subsetPrefix, toUnicodeRef);
        this.writer.addToBody((PdfObject)pobj, ref);
    }
}

