/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.internal;

import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.AFRelationshipValue;
import com.itextpdf.text.pdf.PdfAConformanceException;
import com.itextpdf.text.pdf.PdfAConformanceLevel;
import com.itextpdf.text.pdf.PdfFileSpecification;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.internal.PdfA3Checker;
import com.itextpdf.xmp.XMPException;
import com.itextpdf.xmp.XMPMeta;
import java.util.ArrayList;
import java.util.List;

public class ZugferdChecker
extends PdfA3Checker {
    private List<PdfFileSpecification> attachments = new ArrayList<PdfFileSpecification>();

    ZugferdChecker(PdfAConformanceLevel conformanceLevel) {
        super(conformanceLevel);
    }

    protected void checkFileSpec(PdfWriter writer, int key, Object obj1) {
        super.checkFileSpec(writer, key, obj1);
        this.attachments.add((PdfFileSpecification)obj1);
    }

    public void close(PdfWriter writer) {
        super.close(writer);
        boolean ok = false;
        XMPMeta xmpMeta = writer.getXmpWriter().getXmpMeta();
        try {
            String docFileName = xmpMeta.getPropertyString("urn:ferd:pdfa:CrossIndustryDocument:invoice:1p0#", "DocumentFileName");
            for (PdfFileSpecification attachment : this.attachments) {
                if (!docFileName.equals(attachment.getAsString(PdfName.UF).toString())) continue;
                PdfName relationship = attachment.getAsName(PdfName.AFRELATIONSHIP);
                if (!AFRelationshipValue.Alternative.equals(relationship)) {
                    this.attachments.clear();
                    throw new PdfAConformanceException(attachment, MessageLocalization.getComposedMessage("afrelationship.value.shall.be.alternative", new Object[0]));
                }
                ok = true;
                break;
            }
        }
        catch (XMPException e2) {
            this.attachments.clear();
            throw new ExceptionConverter(e2);
        }
        this.attachments.clear();
        if (!ok) {
            throw new PdfAConformanceException(xmpMeta, MessageLocalization.getComposedMessage("zugferd.xmp.schema.shall.contain.attachment.name", new Object[0]));
        }
    }
}

