/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml;

import com.itextpdf.tool.xml.Pipeline;
import com.itextpdf.tool.xml.PipelineException;
import com.itextpdf.tool.xml.ProcessObject;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.parser.XMLParserListener;
import com.itextpdf.tool.xml.pipeline.ctx.WorkerContextImpl;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLWorker
implements XMLParserListener {
    private final Pipeline<?> rootpPipe;
    private static ThreadLocal<WorkerContextImpl> context = new ThreadLocal<WorkerContextImpl>(){

        @Override
        protected WorkerContextImpl initialValue() {
            return new WorkerContextImpl();
        }
    };
    private final boolean parseHtml;

    public XMLWorker(Pipeline<?> pipeline, boolean parseHtml) {
        this.parseHtml = parseHtml;
        this.rootpPipe = pipeline;
    }

    @Override
    public void init() {
        Pipeline<?> p2 = this.rootpPipe;
        try {
            while ((p2 = p2.init(this.getLocalWC())) != null) {
            }
        }
        catch (PipelineException e2) {
            throw new RuntimeWorkerException(e2);
        }
    }

    @Override
    public void startElement(String tag, Map<String, String> attr, String ns) {
        Tag t2 = this.createTag(tag, attr, ns);
        WorkerContext ctx = this.getLocalWC();
        if (null != ctx.getCurrentTag()) {
            ctx.getCurrentTag().addChild(t2);
        }
        ctx.setCurrentTag(t2);
        Pipeline<?> wp = this.rootpPipe;
        ProcessObject po = new ProcessObject();
        try {
            while (null != (wp = wp.open(ctx, t2, po))) {
            }
        }
        catch (PipelineException e2) {
            throw new RuntimeWorkerException(e2);
        }
    }

    protected Tag createTag(String tag, Map<String, String> attr, String ns) {
        if (this.parseHtml) {
            tag = tag.toLowerCase();
        }
        Tag t2 = new Tag(tag, attr, ns);
        return t2;
    }

    @Override
    public void endElement(String tag, String ns) {
        String thetag = null;
        thetag = this.parseHtml ? tag.toLowerCase() : tag;
        WorkerContext ctx = this.getLocalWC();
        if (null != ctx.getCurrentTag() && !thetag.equals(ctx.getCurrentTag().getName())) {
            throw new RuntimeWorkerException(String.format(LocaleMessages.getInstance().getMessage("tag.invalidnesting"), thetag, ctx.getCurrentTag().getName()));
        }
        Pipeline<?> wp = this.rootpPipe;
        ProcessObject po = new ProcessObject();
        try {
            while (null != (wp = wp.close(ctx, ctx.getCurrentTag(), po))) {
            }
        }
        catch (PipelineException e2) {
            throw new RuntimeWorkerException(e2);
        }
        finally {
            if (null != ctx.getCurrentTag()) {
                ctx.setCurrentTag(ctx.getCurrentTag().getParent());
            }
        }
    }

    @Override
    public void text(String text) {
        WorkerContext ctx = this.getLocalWC();
        if (null != ctx.getCurrentTag() && text.length() > 0) {
            Pipeline<?> wp = this.rootpPipe;
            ProcessObject po = new ProcessObject();
            try {
                while (null != (wp = wp.content(ctx, ctx.getCurrentTag(), text, po))) {
                }
            }
            catch (PipelineException e2) {
                throw new RuntimeWorkerException(e2);
            }
        }
    }

    @Override
    public void unknownText(String text) {
    }

    @Override
    public void comment(String comment) {
    }

    @Override
    public void close() {
        context.remove();
    }

    protected Tag getCurrentTag() {
        return this.getLocalWC().getCurrentTag();
    }

    protected WorkerContext getLocalWC() {
        return context.get();
    }
}

