/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml;

import com.itextpdf.text.Document;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.FontProvider;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.tool.xml.ElementHandler;
import com.itextpdf.tool.xml.ElementList;
import com.itextpdf.tool.xml.XMLWorker;
import com.itextpdf.tool.xml.XMLWorkerFontProvider;
import com.itextpdf.tool.xml.css.CSSFileWrapper;
import com.itextpdf.tool.xml.css.CssFile;
import com.itextpdf.tool.xml.css.CssFileProcessor;
import com.itextpdf.tool.xml.css.CssFilesImpl;
import com.itextpdf.tool.xml.css.StyleAttrCSSResolver;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.html.CssAppliersImpl;
import com.itextpdf.tool.xml.html.TagProcessorFactory;
import com.itextpdf.tool.xml.html.Tags;
import com.itextpdf.tool.xml.parser.XMLParser;
import com.itextpdf.tool.xml.pipeline.css.CSSResolver;
import com.itextpdf.tool.xml.pipeline.css.CssResolverPipeline;
import com.itextpdf.tool.xml.pipeline.end.ElementHandlerPipeline;
import com.itextpdf.tool.xml.pipeline.end.PdfWriterPipeline;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipeline;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

public class XMLWorkerHelper {
    private static XMLWorkerHelper myself = new XMLWorkerHelper();
    private TagProcessorFactory tpf;
    private CssFile defaultCssFile;

    public static synchronized XMLWorkerHelper getInstance() {
        return myself;
    }

    private XMLWorkerHelper() {
    }

    public static synchronized CssFile getCSS(InputStream in) {
        CSSFileWrapper cssFile = null;
        if (null != in) {
            CssFileProcessor cssFileProcessor = new CssFileProcessor();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            try {
                int length;
                char[] buffer = new char[8192];
                while ((length = br.read(buffer)) > 0) {
                    for (int i2 = 0; i2 < length; ++i2) {
                        cssFileProcessor.process(buffer[i2]);
                    }
                }
                cssFile = new CSSFileWrapper(cssFileProcessor.getCss(), true);
            }
            catch (IOException e2) {
                throw new RuntimeWorkerException(e2);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException e3) {
                    throw new RuntimeWorkerException(e3);
                }
            }
        }
        return cssFile;
    }

    public synchronized CssFile getDefaultCSS() {
        if (null == this.defaultCssFile) {
            this.defaultCssFile = XMLWorkerHelper.getCSS(XMLWorkerHelper.class.getResourceAsStream("/default.css"));
        }
        return this.defaultCssFile;
    }

    public void parseXHtml(ElementHandler d2, Reader in) throws IOException {
        CssFilesImpl cssFiles = new CssFilesImpl();
        cssFiles.add(this.getDefaultCSS());
        StyleAttrCSSResolver cssResolver = new StyleAttrCSSResolver(cssFiles);
        HtmlPipelineContext hpc = new HtmlPipelineContext(null);
        hpc.setAcceptUnknown(true).autoBookmark(true).setTagFactory(this.getDefaultTagProcessorFactory());
        CssResolverPipeline pipeline = new CssResolverPipeline(cssResolver, new HtmlPipeline(hpc, new ElementHandlerPipeline(d2, null)));
        XMLWorker worker = new XMLWorker(pipeline, true);
        XMLParser p2 = new XMLParser();
        p2.addListener(worker);
        p2.parse(in);
    }

    public void parseXHtml(PdfWriter writer, Document doc, Reader in) throws IOException {
        CssFilesImpl cssFiles = new CssFilesImpl();
        cssFiles.add(this.getDefaultCSS());
        StyleAttrCSSResolver cssResolver = new StyleAttrCSSResolver(cssFiles);
        HtmlPipelineContext hpc = new HtmlPipelineContext(null);
        hpc.setAcceptUnknown(true).autoBookmark(true).setTagFactory(this.getDefaultTagProcessorFactory());
        CssResolverPipeline pipeline = new CssResolverPipeline(cssResolver, new HtmlPipeline(hpc, new PdfWriterPipeline(doc, writer)));
        XMLWorker worker = new XMLWorker(pipeline, true);
        XMLParser p2 = new XMLParser();
        p2.addListener(worker);
        p2.parse(in);
    }

    public void parseXHtml(PdfWriter writer, Document doc, InputStream in) throws IOException {
        this.parseXHtml(writer, doc, in, XMLWorkerHelper.class.getResourceAsStream("/default.css"), null, new XMLWorkerFontProvider());
    }

    public void parseXHtml(PdfWriter writer, Document doc, InputStream in, Charset charset) throws IOException {
        this.parseXHtml(writer, doc, in, XMLWorkerHelper.class.getResourceAsStream("/default.css"), charset);
    }

    public void parseXHtml(PdfWriter writer, Document doc, InputStream in, InputStream inCssFile, Charset charset, FontProvider fontProvider) throws IOException {
        CssFilesImpl cssFiles = new CssFilesImpl();
        if (inCssFile != null) {
            cssFiles.add(XMLWorkerHelper.getCSS(inCssFile));
        } else {
            cssFiles.add(this.getDefaultCSS());
        }
        StyleAttrCSSResolver cssResolver = new StyleAttrCSSResolver(cssFiles);
        HtmlPipelineContext hpc = new HtmlPipelineContext(new CssAppliersImpl(fontProvider));
        hpc.setAcceptUnknown(true).autoBookmark(true).setTagFactory(this.getDefaultTagProcessorFactory());
        HtmlPipeline htmlPipeline = new HtmlPipeline(hpc, new PdfWriterPipeline(doc, writer));
        CssResolverPipeline pipeline = new CssResolverPipeline(cssResolver, htmlPipeline);
        XMLWorker worker = new XMLWorker(pipeline, true);
        XMLParser p2 = new XMLParser(true, worker, charset);
        if (charset != null) {
            p2.parse(in, charset);
        } else {
            p2.parse(in);
        }
    }

    public void parseXHtml(PdfWriter writer, Document doc, InputStream in, InputStream inCssFile) throws IOException {
        this.parseXHtml(writer, doc, in, inCssFile, null, new XMLWorkerFontProvider());
    }

    public void parseXHtml(PdfWriter writer, Document doc, InputStream in, InputStream inCssFile, FontProvider fontProvider) throws IOException {
        this.parseXHtml(writer, doc, in, inCssFile, null, fontProvider);
    }

    public void parseXHtml(PdfWriter writer, Document doc, InputStream in, InputStream inCssFile, Charset charset) throws IOException {
        this.parseXHtml(writer, doc, in, inCssFile, charset, new XMLWorkerFontProvider());
    }

    public void parseXHtml(ElementHandler d2, InputStream in, Charset charset) throws IOException {
        CssFilesImpl cssFiles = new CssFilesImpl();
        cssFiles.add(this.getDefaultCSS());
        StyleAttrCSSResolver cssResolver = new StyleAttrCSSResolver(cssFiles);
        HtmlPipelineContext hpc = new HtmlPipelineContext(null);
        hpc.setAcceptUnknown(true).autoBookmark(true).setTagFactory(this.getDefaultTagProcessorFactory());
        CssResolverPipeline pipeline = new CssResolverPipeline(cssResolver, new HtmlPipeline(hpc, new ElementHandlerPipeline(d2, null)));
        XMLWorker worker = new XMLWorker(pipeline, true);
        XMLParser p2 = new XMLParser(true, worker, charset);
        if (charset != null) {
            p2.parse(in, charset);
        } else {
            p2.parse(in);
        }
    }

    public CSSResolver getDefaultCssResolver(boolean addDefaultCss) {
        StyleAttrCSSResolver resolver = new StyleAttrCSSResolver();
        if (addDefaultCss) {
            resolver.addCss(this.getDefaultCSS());
        }
        return resolver;
    }

    protected synchronized TagProcessorFactory getDefaultTagProcessorFactory() {
        if (null == this.tpf) {
            this.tpf = Tags.getHtmlTagProcessorFactory();
        }
        return this.tpf;
    }

    public static ElementList parseToElementList(String html, String css) throws IOException {
        StyleAttrCSSResolver cssResolver = new StyleAttrCSSResolver();
        if (css != null) {
            CssFile cssFile = XMLWorkerHelper.getCSS(new ByteArrayInputStream(css.getBytes()));
            cssResolver.addCss(cssFile);
        }
        CssAppliersImpl cssAppliers = new CssAppliersImpl(FontFactory.getFontImp());
        HtmlPipelineContext htmlContext = new HtmlPipelineContext(cssAppliers);
        htmlContext.setTagFactory(Tags.getHtmlTagProcessorFactory());
        htmlContext.autoBookmark(false);
        ElementList elements = new ElementList();
        ElementHandlerPipeline end = new ElementHandlerPipeline(elements, null);
        HtmlPipeline htmlPipeline = new HtmlPipeline(htmlContext, end);
        CssResolverPipeline cssPipeline = new CssResolverPipeline(cssResolver, htmlPipeline);
        XMLWorker worker = new XMLWorker(cssPipeline, true);
        XMLParser p2 = new XMLParser(worker);
        p2.parse(new ByteArrayInputStream(html.getBytes()));
        return elements;
    }
}

