/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css.apply;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactoryImp;
import com.itextpdf.text.FontProvider;
import com.itextpdf.text.html.HtmlUtilities;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.css.FontSizeTranslator;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ChunkCssApplier {
    public static final List<String> BOLD = Arrays.asList("bold", "bolder", "600", "700", "800", "900");
    protected final CssUtils utils = CssUtils.getInstance();
    protected FontProvider fontProvider;

    public ChunkCssApplier() {
        this(null);
    }

    public ChunkCssApplier(FontProvider fontProvider) {
        this.fontProvider = fontProvider != null ? fontProvider : new FontFactoryImp();
    }

    public Chunk apply(Chunk c2, Tag t2) {
        String xfaVertScale;
        Font f2 = this.applyFontStyles(t2);
        float size = f2.getSize();
        Map<String, String> rules = t2.getCSS();
        for (Map.Entry<String, String> entry : rules.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if ("font-style".equalsIgnoreCase(key)) {
                if (!value.equalsIgnoreCase("oblique")) continue;
                c2.setSkew(0.0f, 12.0f);
                continue;
            }
            if ("letter-spacing".equalsIgnoreCase(key)) {
                String letterSpacing = rules.get("letter-spacing");
                float letterSpacingValue = 0.0f;
                if (this.utils.isRelativeValue(value)) {
                    letterSpacingValue = this.utils.parseRelativeValue(letterSpacing, f2.getSize());
                } else if (this.utils.isMetricValue(value)) {
                    letterSpacingValue = this.utils.parsePxInCmMmPcToPt(letterSpacing);
                }
                c2.setCharacterSpacing(letterSpacingValue);
                continue;
            }
            if (null == rules.get("xfa-font-horizontal-scale")) continue;
            c2.setHorizontalScaling(Float.parseFloat(rules.get("xfa-font-horizontal-scale").replace("%", "")) / 100.0f);
        }
        if (null != rules.get("vertical-align")) {
            String value = rules.get("vertical-align");
            if (value.equalsIgnoreCase("super") || value.equalsIgnoreCase("top") || value.equalsIgnoreCase("text-top")) {
                c2.setTextRise((float)((double)(size / 2.0f) + 0.5));
            } else if (value.equalsIgnoreCase("sub") || value.equalsIgnoreCase("bottom") || value.equalsIgnoreCase("text-bottom")) {
                c2.setTextRise(-size / 2.0f);
            } else {
                c2.setTextRise(this.utils.parsePxInCmMmPcToPt(value));
            }
        }
        if (null != (xfaVertScale = rules.get("xfa-font-vertical-scale")) && xfaVertScale.contains("%")) {
            size *= Float.parseFloat(xfaVertScale.replace("%", "")) / 100.0f;
            c2.setHorizontalScaling(100.0f / Float.parseFloat(xfaVertScale.replace("%", "")));
        }
        if (null != rules.get("text-decoration")) {
            String[] splitValues;
            for (String value : splitValues = rules.get("text-decoration").split("\\s+")) {
                if ("underline".equalsIgnoreCase(value)) {
                    c2.setUnderline(0.75f, -size / 8.0f);
                }
                if (!"line-through".equalsIgnoreCase(value)) continue;
                c2.setUnderline(0.75f, size / 4.0f);
            }
        }
        if (null != rules.get("background-color")) {
            c2.setBackground(HtmlUtilities.decodeColor(rules.get("background-color")));
        }
        f2.setSize(size);
        c2.setFont(f2);
        Float leading = null;
        if (rules.get("line-height") != null) {
            String value = rules.get("line-height");
            if (this.utils.isNumericValue(value)) {
                leading = Float.valueOf(Float.parseFloat(value) * c2.getFont().getSize());
            } else if (this.utils.isRelativeValue(value)) {
                leading = Float.valueOf(this.utils.parseRelativeValue(value, c2.getFont().getSize()));
            } else if (this.utils.isMetricValue(value)) {
                leading = Float.valueOf(this.utils.parsePxInCmMmPcToPt(value));
            }
        }
        if (leading != null) {
            c2.setLineHeight(leading.floatValue());
        }
        return c2;
    }

    public Font applyFontStyles(Tag t2) {
        String fontName = null;
        String encoding = "Cp1252";
        float size = new FontSizeTranslator().getFontSize(t2);
        int style = -1;
        BaseColor color = null;
        Map<String, String> rules = t2.getCSS();
        for (Map.Entry<String, String> entry : rules.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if ("font-weight".equalsIgnoreCase(key)) {
                if ("bold".contains(value)) {
                    if (style == 2) {
                        style = 3;
                        continue;
                    }
                    style = 1;
                    continue;
                }
                if (style == 3) {
                    style = 2;
                    continue;
                }
                if (style != 1) continue;
                style = 0;
                continue;
            }
            if ("font-style".equalsIgnoreCase(key)) {
                if (!value.equalsIgnoreCase("italic")) continue;
                if (style == 1) {
                    style = 3;
                    continue;
                }
                style = 2;
                continue;
            }
            if ("font-family".equalsIgnoreCase(key)) {
                fontName = value;
                continue;
            }
            if (!"color".equalsIgnoreCase(key)) continue;
            color = HtmlUtilities.decodeColor(value);
        }
        if (fontName != null) {
            if (fontName.contains(",")) {
                String[] fonts = fontName.split(",");
                Font firstFont = null;
                for (String s2 : fonts) {
                    if (!this.fontProvider.isRegistered(s2 = this.utils.trimAndRemoveQuoutes(s2))) continue;
                    Font f2 = this.fontProvider.getFont(s2, encoding, true, size, style, color);
                    if (f2 != null && (style == 0 || style == -1 || (f2.getStyle() & style) == 0)) {
                        return f2;
                    }
                    if (firstFont != null) continue;
                    firstFont = f2;
                }
                if (firstFont != null) {
                    return firstFont;
                }
                fontName = fonts.length > 0 ? this.utils.trimAndRemoveQuoutes(fontName.split(",")[0]) : null;
            } else {
                fontName = this.utils.trimAndRemoveQuoutes(fontName);
            }
        }
        return this.fontProvider.getFont(fontName, encoding, true, size, style, color);
    }

    public float getWidestWord(Chunk c2) {
        String[] words = c2.getContent().split("\\s");
        float widestWord = 0.0f;
        for (int i2 = 0; i2 < words.length; ++i2) {
            Chunk word = new Chunk(words[i2]);
            this.copyChunkStyles(c2, word);
            if (!(word.getWidthPoint() > widestWord)) continue;
            widestWord = word.getWidthPoint();
        }
        return widestWord;
    }

    public void copyChunkStyles(Chunk source, Chunk target) {
        target.setFont(source.getFont());
        target.setAttributes(source.getAttributes());
        target.setCharacterSpacing(source.getCharacterSpacing());
        target.setHorizontalScaling(source.getHorizontalScaling());
        target.setHorizontalScaling(source.getHorizontalScaling());
    }

    public FontProvider getFontProvider() {
        return this.fontProvider;
    }

    public void setFontProvider(FontProvider fontProvider) {
        this.fontProvider = fontProvider;
    }
}

