/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.html;

import com.itextpdf.text.Chunk;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLUtils {
    private static List<Chunk> sanitize(String str, boolean preserveWhiteSpace, boolean replaceNonBreakableSpaces) {
        StringBuilder builder = new StringBuilder();
        StringBuilder whitespaceBuilder = new StringBuilder();
        char[] chars = str.toCharArray();
        ArrayList<Chunk> chunkList = new ArrayList<Chunk>();
        boolean isWhitespace = chars.length > 0 ? Character.isWhitespace(chars[0]) : true;
        for (char c2 : chars) {
            if (isWhitespace && !Character.isWhitespace(c2)) {
                if (builder.length() == 0) {
                    chunkList.add(Chunk.createWhitespace(builder.toString(), preserveWhiteSpace));
                } else {
                    builder.append(" ");
                }
                whitespaceBuilder = new StringBuilder();
            }
            if (isWhitespace = Character.isWhitespace(c2)) {
                whitespaceBuilder.append(c2);
                continue;
            }
            builder.append(c2);
        }
        if (builder.length() > 0) {
            chunkList.add(new Chunk(replaceNonBreakableSpaces ? builder.toString().replace(Character.valueOf('\u00a0').charValue(), Character.valueOf(' ').charValue()) : builder.toString()));
        }
        if (whitespaceBuilder.length() > 0) {
            chunkList.add(Chunk.createWhitespace(whitespaceBuilder.toString(), preserveWhiteSpace));
        }
        return chunkList;
    }

    public static List<Chunk> sanitize(String str, boolean preserveWhiteSpace) {
        return HTMLUtils.sanitize(str, preserveWhiteSpace, false);
    }

    public static List<Chunk> sanitizeInline(String str, boolean preserveWhiteSpace) {
        return HTMLUtils.sanitize(str, preserveWhiteSpace, false);
    }

    public static List<Chunk> sanitizeInline(String str, boolean preserveWhiteSpace, boolean replaceNonBreakableSpaces) {
        return HTMLUtils.sanitize(str, preserveWhiteSpace, replaceNonBreakableSpaces);
    }
}

