/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.pipeline.html;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.tool.xml.NoCustomContextException;
import com.itextpdf.tool.xml.Pipeline;
import com.itextpdf.tool.xml.PipelineException;
import com.itextpdf.tool.xml.ProcessObject;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.pipeline.AbstractPipeline;
import com.itextpdf.tool.xml.pipeline.ctx.MapContext;
import com.itextpdf.tool.xml.pipeline.ctx.WorkerContextImpl;
import com.itextpdf.tool.xml.pipeline.end.PdfWriterPipeline;
import com.itextpdf.tool.xml.pipeline.html.FileMaker;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipeline;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoDocPipeline
extends AbstractPipeline {
    private final FileMaker fm;
    private final String tag;
    private final String opentag;
    private final Rectangle pagesize;

    public AutoDocPipeline(FileMaker fm, String tag, String opentag, Rectangle pagesize) {
        super(null);
        this.fm = fm;
        this.tag = tag;
        this.opentag = opentag;
        this.pagesize = pagesize;
    }

    @Override
    public Pipeline<?> open(WorkerContext context, Tag t2, ProcessObject po) throws PipelineException {
        try {
            Document d2;
            MapContext cc;
            String tagName = t2.getName();
            if (this.tag.equals(tagName)) {
                cc = (MapContext)context.get(PdfWriterPipeline.class.getName());
                d2 = new Document(this.pagesize);
                try {
                    OutputStream os = this.fm.getStream();
                    cc.put("DOCUMENT", d2);
                    cc.put("WRITER", PdfWriter.getInstance(d2, os));
                }
                catch (IOException e2) {
                    throw new PipelineException(e2);
                }
                catch (DocumentException e3) {
                    throw new PipelineException(e3);
                }
            }
            if (t2.getName().equalsIgnoreCase(this.opentag)) {
                cc = (MapContext)context.get(PdfWriterPipeline.class.getName());
                d2 = (Document)cc.get("DOCUMENT");
                CssUtils cssUtils = CssUtils.getInstance();
                float pageWidth = d2.getPageSize().getWidth();
                float marginLeft = 0.0f;
                float marginRight = 0.0f;
                float marginTop = 0.0f;
                float marginBottom = 0.0f;
                Map<String, String> css = t2.getCSS();
                for (Map.Entry<String, String> entry : css.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    if (key.equalsIgnoreCase("margin-left")) {
                        marginLeft = cssUtils.parseValueToPt(value, pageWidth);
                        continue;
                    }
                    if (key.equalsIgnoreCase("margin-right")) {
                        marginRight = cssUtils.parseValueToPt(value, pageWidth);
                        continue;
                    }
                    if (key.equalsIgnoreCase("margin-top")) {
                        marginTop = cssUtils.parseValueToPt(value, pageWidth);
                        continue;
                    }
                    if (!key.equalsIgnoreCase("margin-bottom")) continue;
                    marginBottom = cssUtils.parseValueToPt(value, pageWidth);
                }
                d2.setMargins(marginLeft, marginRight, marginTop, marginBottom);
                d2.open();
            }
        }
        catch (NoCustomContextException e4) {
            throw new PipelineException(LocaleMessages.getInstance().getMessage("pipeline.autodoc.missingdep"), e4);
        }
        return this.getNext();
    }

    @Override
    public Pipeline<?> close(WorkerContext context, Tag t2, ProcessObject po) throws PipelineException {
        String tagName = t2.getName();
        if (this.tag.equals(tagName)) {
            try {
                MapContext cc = (MapContext)context.get(PdfWriterPipeline.class.getName());
                Document d2 = (Document)cc.get("DOCUMENT");
                d2.close();
            }
            catch (NoCustomContextException e2) {
                throw new PipelineException("AutoDocPipeline depends on PdfWriterPipeline.", e2);
            }
            try {
                HtmlPipelineContext hpc = (HtmlPipelineContext)context.get(HtmlPipeline.class.getName());
                HtmlPipelineContext clone = hpc.clone();
                clone.setPageSize(this.pagesize);
                ((WorkerContextImpl)context).put(HtmlPipeline.class.getName(), clone);
            }
            catch (NoCustomContextException e3) {
            }
            catch (CloneNotSupportedException e4) {
                // empty catch block
            }
        }
        return this.getNext();
    }
}

