/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.draw;

import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.draw.VerticalPositionMark;
import java.awt.Color;

public class LineSeparator
extends VerticalPositionMark {
    protected float lineWidth = 1.0f;
    protected float percentage = 100.0f;
    protected Color lineColor;
    protected int alignment = 1;

    public LineSeparator(float f2, float f3, Color color, int n2, float f4) {
        this.lineWidth = f2;
        this.percentage = f3;
        this.lineColor = color;
        this.alignment = n2;
        this.offset = f4;
    }

    public LineSeparator() {
    }

    public void draw(PdfContentByte pdfContentByte, float f2, float f3, float f4, float f5, float f6) {
        pdfContentByte.saveState();
        this.drawLine(pdfContentByte, f2, f4, f6);
        pdfContentByte.restoreState();
    }

    public void drawLine(PdfContentByte pdfContentByte, float f2, float f3, float f4) {
        float f5;
        float f6 = this.getPercentage() < 0.0f ? -this.getPercentage() : (f3 - f2) * this.getPercentage() / 100.0f;
        switch (this.getAlignment()) {
            case 0: {
                f5 = 0.0f;
                break;
            }
            case 2: {
                f5 = f3 - f2 - f6;
                break;
            }
            default: {
                f5 = (f3 - f2 - f6) / 2.0f;
            }
        }
        pdfContentByte.setLineWidth(this.getLineWidth());
        if (this.getLineColor() != null) {
            pdfContentByte.setColorStroke(this.getLineColor());
        }
        pdfContentByte.moveTo(f5 + f2, f4 + this.offset);
        pdfContentByte.lineTo(f5 + f6 + f2, f4 + this.offset);
        pdfContentByte.stroke();
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float f2) {
        this.lineWidth = f2;
    }

    public float getPercentage() {
        return this.percentage;
    }

    public void setPercentage(float f2) {
        this.percentage = f2;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n2) {
        this.alignment = n2;
    }
}

