/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap;

import com.sun.mail.iap.ByteArray;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.imap.IMAPMessage;
import com.sun.mail.imap.protocol.BODY;
import com.sun.mail.imap.protocol.IMAPProtocol;
import java.io.IOException;
import java.io.InputStream;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.MessagingException;

public class IMAPInputStream
extends InputStream {
    private IMAPMessage msg;
    private String section;
    private int pos;
    private int blksize;
    private int max;
    private byte[] buf;
    private int bufcount;
    private int bufpos;
    private boolean peek;

    public IMAPInputStream(IMAPMessage iMAPMessage, String string, int n2, boolean bl) {
        this.msg = iMAPMessage;
        this.section = string;
        this.max = n2;
        this.peek = bl;
        this.pos = 0;
        this.blksize = iMAPMessage.getFetchBlockSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fill() throws IOException {
        ByteArray byteArray;
        int n2;
        if (this.max != -1 && this.pos >= this.max) {
            if (this.pos == 0) {
                this.checkSeen();
            }
            return;
        }
        BODY bODY = null;
        Object object = this.msg.getMessageCacheLock();
        synchronized (object) {
            if (this.msg.isExpunged()) {
                throw new IOException("No content for expunged message");
            }
            int n3 = this.msg.getSequenceNumber();
            n2 = this.blksize;
            if (this.max != -1 && this.pos + this.blksize > this.max) {
                n2 = this.max - this.pos;
            }
            try {
                IMAPProtocol iMAPProtocol = this.msg.getProtocol();
                bODY = this.peek ? iMAPProtocol.peekBody(n3, this.section, this.pos, n2) : iMAPProtocol.fetchBody(n3, this.section, this.pos, n2);
            }
            catch (ProtocolException protocolException) {
                throw new IOException(protocolException.getMessage());
            }
            catch (FolderClosedException folderClosedException) {
                throw new IOException(folderClosedException.getMessage());
            }
        }
        if (bODY == null || (byteArray = bODY.getByteArray()) == null) {
            throw new IOException("No content");
        }
        if (this.pos == 0) {
            this.checkSeen();
        }
        this.buf = byteArray.getBytes();
        this.bufpos = byteArray.getStart();
        n2 = byteArray.getCount();
        this.bufcount = this.bufpos + n2;
        this.pos += n2;
    }

    public synchronized int read() throws IOException {
        if (this.bufpos >= this.bufcount) {
            this.fill();
            if (this.bufpos >= this.bufcount) {
                return -1;
            }
        }
        return this.buf[this.bufpos++] & 0xFF;
    }

    public synchronized int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.bufcount - this.bufpos;
        if (n4 <= 0) {
            this.fill();
            n4 = this.bufcount - this.bufpos;
            if (n4 <= 0) {
                return -1;
            }
        }
        int n5 = n4 < n3 ? n4 : n3;
        System.arraycopy(this.buf, this.bufpos, byArray, n2, n5);
        this.bufpos += n5;
        return n5;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public synchronized int available() throws IOException {
        return this.bufcount - this.bufpos;
    }

    private void checkSeen() {
        if (this.peek) {
            return;
        }
        try {
            Folder folder = this.msg.getFolder();
            if (folder != null && folder.getMode() != 1 && !this.msg.isSet(Flags.Flag.SEEN)) {
                this.msg.setFlag(Flags.Flag.SEEN, true);
            }
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }
}

