/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TraceInputStream
extends FilterInputStream {
    private boolean trace = false;
    private boolean quote = false;
    private OutputStream traceOut;

    public TraceInputStream(InputStream inputStream, OutputStream outputStream) {
        super(inputStream);
        this.traceOut = outputStream;
    }

    public void setTrace(boolean bl) {
        this.trace = bl;
    }

    public void setQuote(boolean bl) {
        this.quote = bl;
    }

    public int read() throws IOException {
        int n2 = this.in.read();
        if (this.trace && n2 != -1) {
            if (this.quote) {
                this.writeByte(n2);
            } else {
                this.traceOut.write(n2);
            }
        }
        return n2;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.in.read(byArray, n2, n3);
        if (this.trace && n4 != -1) {
            if (this.quote) {
                int n5 = 0;
                while (n5 < n4) {
                    this.writeByte(byArray[n2 + n5]);
                    ++n5;
                }
            } else {
                this.traceOut.write(byArray, n2, n4);
            }
        }
        return n4;
    }

    private final void writeByte(int n2) throws IOException {
        if ((n2 &= 0xFF) > 127) {
            this.traceOut.write(77);
            this.traceOut.write(45);
            n2 &= 0x7F;
        }
        if (n2 == 13) {
            this.traceOut.write(92);
            this.traceOut.write(114);
        } else if (n2 == 10) {
            this.traceOut.write(92);
            this.traceOut.write(110);
            this.traceOut.write(10);
        } else if (n2 == 9) {
            this.traceOut.write(92);
            this.traceOut.write(116);
        } else if (n2 < 32) {
            this.traceOut.write(94);
            this.traceOut.write(64 + n2);
        } else {
            this.traceOut.write(n2);
        }
    }
}

