/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.mail.internet.MailDateParser;

public class MailDateFormat
extends SimpleDateFormat {
    private static final long serialVersionUID = -8148227605210628779L;
    static boolean debug = false;
    private static TimeZone tz = TimeZone.getTimeZone("GMT");
    private static Calendar cal = new GregorianCalendar(tz);

    public MailDateFormat() {
        super("EEE, d MMM yyyy HH:mm:ss 'XXXXX' (z)", Locale.US);
    }

    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        int n2 = stringBuffer.length();
        super.format(date, stringBuffer, fieldPosition);
        int n3 = 0;
        n3 = n2 + 25;
        while (stringBuffer.charAt(n3) != 'X') {
            ++n3;
        }
        this.calendar.clear();
        this.calendar.setTime(date);
        int n4 = this.calendar.get(15) + this.calendar.get(16);
        if (n4 < 0) {
            stringBuffer.setCharAt(n3++, '-');
            n4 = -n4;
        } else {
            stringBuffer.setCharAt(n3++, '+');
        }
        int n5 = n4 / 60 / 1000;
        int n6 = n5 / 60;
        int n7 = n5 % 60;
        stringBuffer.setCharAt(n3++, Character.forDigit(n6 / 10, 10));
        stringBuffer.setCharAt(n3++, Character.forDigit(n6 % 10, 10));
        stringBuffer.setCharAt(n3++, Character.forDigit(n7 / 10, 10));
        stringBuffer.setCharAt(n3++, Character.forDigit(n7 % 10, 10));
        return stringBuffer;
    }

    public Date parse(String string, ParsePosition parsePosition) {
        return MailDateFormat.parseDate(string.toCharArray(), parsePosition, this.isLenient());
    }

    private static Date parseDate(char[] cArray, ParsePosition parsePosition, boolean bl) {
        try {
            MailDateParser mailDateParser;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            block11: {
                n8 = -1;
                n7 = -1;
                n6 = -1;
                n5 = 0;
                n4 = 0;
                n3 = 0;
                n2 = 0;
                mailDateParser = new MailDateParser(cArray);
                mailDateParser.skipUntilNumber();
                n8 = mailDateParser.parseNumber();
                if (!mailDateParser.skipIfChar('-')) {
                    mailDateParser.skipWhiteSpace();
                }
                n7 = mailDateParser.parseMonth();
                if (!mailDateParser.skipIfChar('-')) {
                    mailDateParser.skipWhiteSpace();
                }
                if ((n6 = mailDateParser.parseNumber()) < 50) {
                    n6 += 2000;
                } else if (n6 < 100) {
                    n6 += 1900;
                }
                mailDateParser.skipWhiteSpace();
                n5 = mailDateParser.parseNumber();
                mailDateParser.skipChar(':');
                n4 = mailDateParser.parseNumber();
                if (mailDateParser.skipIfChar(':')) {
                    n3 = mailDateParser.parseNumber();
                }
                try {
                    mailDateParser.skipWhiteSpace();
                    n2 = mailDateParser.parseTimeZone();
                }
                catch (ParseException parseException) {
                    if (!debug) break block11;
                    System.out.println("No timezone? : '" + cArray + "'");
                }
            }
            parsePosition.setIndex(mailDateParser.getIndex());
            Date date = MailDateFormat.ourUTC(n6, n7, n8, n5, n4, n3, n2, bl);
            return date;
        }
        catch (Exception exception) {
            if (debug) {
                System.out.println("Bad date: '" + cArray + "'");
                exception.printStackTrace();
            }
            parsePosition.setIndex(1);
            return null;
        }
    }

    private static synchronized Date ourUTC(int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        cal.clear();
        cal.setLenient(bl);
        cal.set(1, n2);
        cal.set(2, n3);
        cal.set(5, n4);
        cal.set(11, n5);
        cal.set(12, n6 + n8);
        cal.set(13, n7);
        return cal.getTime();
    }

    public void setCalendar(Calendar calendar) {
        throw new RuntimeException("Method setCalendar() shouldn't be called");
    }

    public void setNumberFormat(NumberFormat numberFormat) {
        throw new RuntimeException("Method setNumberFormat() shouldn't be called");
    }
}

