/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class ParameterList {
    private Map list = new LinkedHashMap();
    private static boolean encodeParameters = false;
    private static boolean decodeParameters = false;
    private static boolean decodeParametersStrict = false;
    private static final char[] hex;

    public ParameterList() {
    }

    public ParameterList(String string) throws ParseException {
        HeaderTokenizer.Token token;
        HeaderTokenizer headerTokenizer = new HeaderTokenizer(string, "()<>@,;:\\\"\t []/?=");
        while (true) {
            int n2;
            if ((n2 = (token = headerTokenizer.next()).getType()) == -4) {
                return;
            }
            if ((char)n2 != ';') break;
            token = headerTokenizer.next();
            if (token.getType() == -4) {
                return;
            }
            if (token.getType() != -1) {
                throw new ParseException("Expected parameter name, got \"" + token.getValue() + "\"");
            }
            String string2 = token.getValue().toLowerCase();
            token = headerTokenizer.next();
            if ((char)token.getType() != '=') {
                throw new ParseException("Expected '=', got \"" + token.getValue() + "\"");
            }
            token = headerTokenizer.next();
            n2 = token.getType();
            if (n2 != -1 && n2 != -2) {
                throw new ParseException("Expected parameter value, got \"" + token.getValue() + "\"");
            }
            String string3 = token.getValue();
            if (decodeParameters && string2.endsWith("*")) {
                string2 = string2.substring(0, string2.length() - 1);
                this.list.put(string2, this.decodeValue(string3));
                continue;
            }
            this.list.put(string2, string3);
        }
        throw new ParseException("Expected ';', got \"" + token.getValue() + "\"");
    }

    public int size() {
        return this.list.size();
    }

    public String get(String string) {
        Object v2 = this.list.get(string.trim().toLowerCase());
        String string2 = v2 instanceof Value ? ((Value)v2).value : (String)v2;
        return string2;
    }

    public void set(String string, String string2) {
        this.list.put(string.trim().toLowerCase(), string2);
    }

    public void set(String string, String string2, String string3) {
        if (encodeParameters) {
            Value value = this.encodeValue(string2, string3);
            if (value != null) {
                this.list.put(string.trim().toLowerCase(), value);
            } else {
                this.set(string, string2);
            }
        } else {
            this.set(string, string2);
        }
    }

    public void remove(String string) {
        this.list.remove(string.trim().toLowerCase());
    }

    public Enumeration getNames() {
        return new ParamEnum(this.list.keySet().iterator());
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.list.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = (String)iterator.next();
            Object v2 = this.list.get(string2);
            if (v2 instanceof Value) {
                string = ((Value)v2).encodedValue;
                string2 = string2 + '*';
            } else {
                string = (String)v2;
            }
            string = this.quote(string);
            stringBuffer.append("; ");
            int n3 = string2.length() + string.length() + 1;
            if ((n2 += 2) + n3 > 76) {
                stringBuffer.append("\r\n\t");
                n2 = 8;
            }
            stringBuffer.append(string2).append('=');
            if ((n2 += string2.length() + 1) + string.length() > 76) {
                String string3 = MimeUtility.fold(n2, string);
                stringBuffer.append(string3);
                int n4 = string3.lastIndexOf(10);
                if (n4 >= 0) {
                    n2 += string3.length() - n4 - 1;
                    continue;
                }
                n2 += string3.length();
                continue;
            }
            stringBuffer.append(string);
            n2 += string.length();
        }
        return stringBuffer.toString();
    }

    private String quote(String string) {
        return MimeUtility.quote(string, "()<>@,;:\\\"\t []/?=");
    }

    private Value encodeValue(String string, String string2) {
        byte[] byArray;
        if (MimeUtility.checkAscii(string) == 1) {
            return null;
        }
        try {
            byArray = string.getBytes(MimeUtility.javaCharset(string2));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length + string2.length() + 2);
        stringBuffer.append(string2).append("''");
        int n2 = 0;
        while (n2 < byArray.length) {
            char c2 = (char)(byArray[n2] & 0xFF);
            if (c2 <= ' ' || c2 >= '\u007f' || c2 == '*' || c2 == '\'' || c2 == '%' || "()<>@,;:\\\"\t []/?=".indexOf(c2) >= 0) {
                stringBuffer.append('%').append(hex[c2 >> 4]).append(hex[c2 & 0xF]);
            } else {
                stringBuffer.append(c2);
            }
            ++n2;
        }
        Value value = new Value();
        value.value = string;
        value.encodedValue = stringBuffer.toString();
        return value;
    }

    private Value decodeValue(String string) throws ParseException {
        Value value;
        block12: {
            value = new Value();
            value.encodedValue = string;
            value.value = string;
            try {
                int n2 = string.indexOf(39);
                if (n2 <= 0) {
                    if (decodeParametersStrict) {
                        throw new ParseException("Missing charset in encoded value: " + string);
                    }
                    return value;
                }
                String string2 = string.substring(0, n2);
                int n3 = string.indexOf(39, n2 + 1);
                if (n3 < 0) {
                    if (decodeParametersStrict) {
                        throw new ParseException("Missing language in encoded value: " + string);
                    }
                    return value;
                }
                String string3 = string.substring(n2 + 1, n3);
                string = string.substring(n3 + 1);
                byte[] byArray = new byte[string.length()];
                n2 = 0;
                int n4 = 0;
                while (n2 < string.length()) {
                    char c2 = string.charAt(n2);
                    if (c2 == '%') {
                        String string4 = string.substring(n2 + 1, n2 + 3);
                        c2 = (char)Integer.parseInt(string4, 16);
                        n2 += 2;
                    }
                    byArray[n4++] = (byte)c2;
                    ++n2;
                }
                value.value = new String(byArray, 0, n4, MimeUtility.javaCharset(string2));
            }
            catch (NumberFormatException numberFormatException) {
                if (decodeParametersStrict) {
                    throw new ParseException(numberFormatException.toString());
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (decodeParametersStrict) {
                    throw new ParseException(unsupportedEncodingException.toString());
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                if (!decodeParametersStrict) break block12;
                throw new ParseException(stringIndexOutOfBoundsException.toString());
            }
        }
        return value;
    }

    static {
        try {
            String string = System.getProperty("mail.mime.encodeparameters");
            encodeParameters = string != null && string.equalsIgnoreCase("true");
            string = System.getProperty("mail.mime.decodeparameters");
            decodeParameters = string != null && string.equalsIgnoreCase("true");
            string = System.getProperty("mail.mime.decodeparameters.strict");
            decodeParametersStrict = string != null && string.equalsIgnoreCase("true");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }

    private static class ParamEnum
    implements Enumeration {
        private Iterator it;

        ParamEnum(Iterator iterator) {
            this.it = iterator;
        }

        public boolean hasMoreElements() {
            return this.it.hasNext();
        }

        public Object nextElement() {
            return this.it.next();
        }
    }

    private static class Value {
        String value;
        String encodedValue;

        private Value() {
        }
    }
}

