/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import net.sf.jasperreports.compilers.JavaScriptCompiledData;
import net.sf.jasperreports.engine.JRRuntimeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.DefiningClassLoader;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.optimizer.Codegen;

public class JavaScriptClassLoader
extends DefiningClassLoader {
    private static final Log log = LogFactory.getLog(JavaScriptClassLoader.class);
    public static final String EXCEPTION_MESSAGE_KEY_INSTANCE_ERROR = "compilers.javascript.instance.error";
    public static final String EXCEPTION_MESSAGE_KEY_LOAD_ERROR = "compilers.javascript.load.error";

    public JavaScriptClassLoader() {
        super(Codegen.class.getClassLoader());
    }

    public Script createScript(int classIndex, JavaScriptCompiledData compiledData) {
        JavaScriptCompiledData.CompiledClass compiledClass = compiledData.getCompiledClass(classIndex);
        Class<? extends Script> scriptClass = this.loadExpressionClass(compiledClass);
        try {
            Script script = scriptClass.newInstance();
            return script;
        }
        catch (InstantiationException e2) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_INSTANCE_ERROR, new Object[]{compiledClass.getClassName()}, e2);
        }
        catch (IllegalAccessException e3) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_INSTANCE_ERROR, new Object[]{compiledClass.getClassName()}, e3);
        }
    }

    protected synchronized Class<? extends Script> loadExpressionClass(JavaScriptCompiledData.CompiledClass compiledClass) {
        String className = compiledClass.getClassName();
        Class scriptClass = this.findLoadedClass(className);
        if (scriptClass == null) {
            if (log.isDebugEnabled()) {
                log.debug("loading script class " + className);
            }
            try {
                scriptClass = this.defineClass(className, compiledClass.getClassBytes());
                this.linkClass(scriptClass);
            }
            catch (SecurityException e2) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_LOAD_ERROR, new Object[]{className}, e2);
            }
            catch (IllegalArgumentException e3) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_LOAD_ERROR, new Object[]{className}, e3);
            }
        }
        return scriptClass;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + '@' + ((Object)((Object)this)).hashCode();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (log.isDebugEnabled()) {
            log.debug("finalized " + (Object)((Object)this));
        }
    }
}

