/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.compilers.JavaScriptCompileData;
import net.sf.jasperreports.compilers.JavaScriptEvaluatorScope;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JasperReportsContextAware;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.functions.FunctionsUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaScriptEvaluator
extends JREvaluator
implements JasperReportsContextAware {
    public static final String PROPERTY_OPTIMIZATION_LEVEL = "net.sf.jasperreports.javascript.evaluator.optimization.level";
    public static final String EXCEPTION_MESSAGE_KEY_EVALUATOR_LOAD_ERROR = "compilers.javascript.evaluator.load.error";
    private static final Log log = LogFactory.getLog(JavaScriptEvaluator.class);
    private final JasperReportsContext jrContext;
    private final JavaScriptCompileData compileData;
    private FunctionsUtil functionsUtil;
    private JavaScriptEvaluatorScope evaluatorScope;
    private Map<String, Class<?>> loadedTypes = new HashMap();

    public JavaScriptEvaluator(JasperReportsContext jrContext, JavaScriptCompileData compileData) {
        this.jrContext = jrContext;
        this.compileData = compileData;
    }

    @Override
    public void setJasperReportsContext(JasperReportsContext context) {
        this.functionsUtil = FunctionsUtil.getInstance(context);
    }

    @Override
    protected void customizedInit(Map<String, JRFillParameter> parametersMap, Map<String, JRFillField> fieldsMap, Map<String, JRFillVariable> variablesMap) throws JRException {
        this.evaluatorScope = new JavaScriptEvaluatorScope(this.jrContext, this, this.functionsUtil);
        this.evaluatorScope.init(parametersMap, fieldsMap, variablesMap);
    }

    @Override
    protected Object evaluate(int id) throws Throwable {
        JavaScriptCompileData.Expression expression = this.getExpression(id);
        return this.evaluateExpression(expression.getDefaultExpression());
    }

    @Override
    protected Object evaluateEstimated(int id) throws Throwable {
        JavaScriptCompileData.Expression expression = this.getExpression(id);
        return this.evaluateExpression(expression.getEstimatedExpression());
    }

    @Override
    protected Object evaluateOld(int id) throws Throwable {
        JavaScriptCompileData.Expression expression = this.getExpression(id);
        return this.evaluateExpression(expression.getOldExpression());
    }

    protected JavaScriptCompileData.Expression getExpression(int id) {
        return this.compileData.getExpression(id);
    }

    protected Object evaluateExpression(String type, String expression) {
        return this.evaluateExpression(expression);
    }

    protected Object evaluateExpression(String expression) {
        return this.evaluatorScope.evaluateExpression(expression);
    }

    protected Class<?> getTypeClass(String type) {
        Class<?> typeClass = this.loadedTypes.get(type);
        if (typeClass == null) {
            try {
                typeClass = JRClassLoader.loadClassForName(type);
            }
            catch (ClassNotFoundException e2) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_EVALUATOR_LOAD_ERROR, new Object[]{type}, e2);
            }
            this.loadedTypes.put(type, typeClass);
        }
        return typeClass;
    }
}

