/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.iconlabel;

import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBasePrintFrame;
import net.sf.jasperreports.engine.export.GenericElementPdfHandler;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterContext;

public class IconLabelElementPdfHandler
implements GenericElementPdfHandler {
    @Override
    public void exportElement(JRPdfExporterContext exporterContext, JRGenericPrintElement element) {
        JRPrintText labelPrintText = (JRPrintText)element.getParameterValue("labelTextElement");
        if (labelPrintText == null) {
            return;
        }
        JRBasePrintFrame frame = new JRBasePrintFrame(element.getDefaultStyleProvider());
        frame.setX(element.getX());
        frame.setY(element.getY());
        frame.setWidth(element.getWidth());
        frame.setHeight(element.getHeight());
        frame.setStyle(element.getStyle());
        frame.setBackcolor(element.getBackcolor());
        frame.setForecolor(element.getForecolor());
        frame.setMode(element.getModeValue());
        JRLineBox lineBox = (JRLineBox)element.getParameterValue("lineBox");
        if (lineBox != null) {
            frame.copyBox(lineBox);
        }
        frame.addElement(labelPrintText);
        JRPrintText iconPrintText = (JRPrintText)element.getParameterValue("iconTextElement");
        if (iconPrintText != null) {
            frame.addElement(iconPrintText);
        }
        JRPdfExporter exporter = (JRPdfExporter)exporterContext.getExporterRef();
        try {
            exporter.exportFrame(frame);
        }
        catch (Exception e2) {
            throw new JRRuntimeException(e2);
        }
    }

    @Override
    public boolean toExport(JRGenericPrintElement element) {
        return true;
    }
}

