/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.list;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractSvgRenderer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;

public class UnusedSpaceImageRenderer
extends JRAbstractSvgRenderer {
    private static final long serialVersionUID = 1L;
    private static final Color FILL = new Color(224, 224, 224, 128);
    public static final UnusedSpaceImageRenderer INSTANCE = new UnusedSpaceImageRenderer();
    private final Shape clip;
    private final int lineGap = 15;
    private final int lineWidth = 10;

    public UnusedSpaceImageRenderer() {
        this(null);
    }

    public UnusedSpaceImageRenderer(Shape clip) {
        this.clip = clip;
    }

    @Override
    public void render(Graphics2D grx, Rectangle2D rectangle) throws JRException {
        this.render(DefaultJasperReportsContext.getInstance(), grx, rectangle);
    }

    @Override
    public void render(JasperReportsContext jasperReportsContext, Graphics2D grx, Rectangle2D rectangle) throws JRException {
        Graphics2D graphics = (Graphics2D)grx.create();
        graphics.translate(rectangle.getX(), rectangle.getY());
        graphics.setColor(FILL);
        if (this.clip != null) {
            graphics.clip(this.clip);
        }
        int width = (int)rectangle.getWidth();
        int limit = width + (int)rectangle.getHeight();
        int increment = 25;
        int reverseOffset = (width - 13) % increment;
        for (int x2 = 0; x2 <= limit; x2 += increment) {
            graphics.fillPolygon(new int[]{x2, x2 + 10, 0, 0}, new int[]{0, 0, x2 + 10, x2}, 4);
            graphics.fillPolygon(new int[]{width - x2 - reverseOffset, width - x2 - 10 - reverseOffset, width, width}, new int[]{0, 0, x2 + 10, x2}, 4);
        }
    }
}

