/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.interactive;

import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabBucket;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabDataset;
import net.sf.jasperreports.engine.analytics.dataset.BucketOrder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CrosstabOrderAttributes {
    private static final Log log = LogFactory.getLog(CrosstabOrderAttributes.class);
    private JRDesignCrosstab crosstab;
    private boolean dataPreSorted;
    private BucketOrder[] rowGroupOrders;
    private BucketOrder[] colGroupOrders;
    private String orderByColumnProp;

    public CrosstabOrderAttributes(JRDesignCrosstab crosstab) {
        this.crosstab = crosstab;
        this.dataPreSorted = crosstab.getDataset().isDataPreSorted();
        JRCrosstabRowGroup[] rowGroups = crosstab.getRowGroups();
        this.rowGroupOrders = new BucketOrder[rowGroups.length];
        for (int i2 = 0; i2 < rowGroups.length; ++i2) {
            this.rowGroupOrders[i2] = rowGroups[i2].getBucket().getOrder();
        }
        JRCrosstabColumnGroup[] colGroups = crosstab.getColumnGroups();
        this.colGroupOrders = new BucketOrder[colGroups.length];
        for (int i3 = 0; i3 < colGroups.length; ++i3) {
            this.colGroupOrders[i3] = colGroups[i3].getBucket().getOrder();
        }
        this.orderByColumnProp = crosstab.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.order.by.column");
        if (log.isDebugEnabled()) {
            log.debug("crosstab " + crosstab.getUUID() + " has order attributes " + this.toString());
        }
    }

    public void prepareSorting() {
        if (this.dataPreSorted) {
            if (log.isDebugEnabled()) {
                log.debug("crosstab " + this.crosstab.getUUID() + " has the presorted flag set, converting to order NONE");
            }
            ((JRDesignCrosstabDataset)this.crosstab.getDataset()).setDataPreSorted(false);
            JRCrosstabRowGroup[] rowGroups = this.crosstab.getRowGroups();
            for (int i2 = 0; i2 < rowGroups.length; ++i2) {
                ((JRDesignCrosstabBucket)rowGroups[i2].getBucket()).setOrder(BucketOrder.NONE);
            }
            JRCrosstabColumnGroup[] colGroups = this.crosstab.getColumnGroups();
            for (int i3 = 0; i3 < colGroups.length; ++i3) {
                ((JRDesignCrosstabBucket)colGroups[i3].getBucket()).setOrder(BucketOrder.NONE);
            }
        }
    }

    public void restore() {
        if (log.isDebugEnabled()) {
            log.debug("restoring crosstab " + this.crosstab.getUUID() + " order attributes");
        }
        ((JRDesignCrosstabDataset)this.crosstab.getDataset()).setDataPreSorted(this.dataPreSorted);
        JRCrosstabRowGroup[] rowGroups = this.crosstab.getRowGroups();
        for (int i2 = 0; i2 < rowGroups.length; ++i2) {
            ((JRDesignCrosstabBucket)rowGroups[i2].getBucket()).setOrder(this.rowGroupOrders[i2]);
        }
        JRCrosstabColumnGroup[] colGroups = this.crosstab.getColumnGroups();
        for (int i3 = 0; i3 < colGroups.length; ++i3) {
            ((JRDesignCrosstabBucket)colGroups[i3].getBucket()).setOrder(this.colGroupOrders[i3]);
        }
        this.crosstab.getPropertiesMap().setProperty("net.sf.jasperreports.crosstab.order.by.column", this.orderByColumnProp);
    }

    public String toString() {
        int i2;
        StringBuilder string = new StringBuilder();
        string.append("{").append(this.dataPreSorted).append(",[");
        for (i2 = 0; i2 < this.rowGroupOrders.length; ++i2) {
            string.append(this.rowGroupOrders[i2].getName()).append(",");
        }
        string.append("],[");
        for (i2 = 0; i2 < this.colGroupOrders.length; ++i2) {
            string.append(this.colGroupOrders[i2].getName()).append(",");
        }
        string.append("],").append(this.orderByColumnProp).append("}");
        return string.toString();
    }
}

