/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.bean;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import net.sf.jasperreports.data.AbstractClasspathAwareDataAdapterService;
import net.sf.jasperreports.data.bean.BeanDataAdapter;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JRAbstractBeanDataSource;
import net.sf.jasperreports.engine.data.JRBeanArrayDataSource;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.util.JRClassLoader;

public class BeanDataAdapterService
extends AbstractClasspathAwareDataAdapterService {
    public static final String EXCEPTION_MESSAGE_KEY_INVALID_RETURN_TYPE = "data.bean.invalid.return.type";

    public BeanDataAdapterService(JasperReportsContext jasperReportsContext, BeanDataAdapter beanDataAdapter) {
        super(jasperReportsContext, beanDataAdapter);
    }

    public BeanDataAdapterService(BeanDataAdapter beanDataAdapter) {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), beanDataAdapter);
    }

    public BeanDataAdapter getBeanDataAdapter() {
        return (BeanDataAdapter)this.getDataAdapter();
    }

    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        BeanDataAdapter beanDataAdapter = this.getBeanDataAdapter();
        if (beanDataAdapter != null) {
            JRAbstractBeanDataSource beanDataSource;
            block13: {
                beanDataSource = null;
                ClassLoader oldThreadClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.getClassLoader(oldThreadClassLoader));
                    Class<?> clazz = JRClassLoader.loadClassForRealName(beanDataAdapter.getFactoryClass());
                    Method method = clazz.getMethod(beanDataAdapter.getMethodName(), new Class[0]);
                    Object res = method.invoke(null, new Object[0]);
                    if (res instanceof Collection) {
                        beanDataSource = new JRBeanCollectionDataSource((Collection)res, beanDataAdapter.isUseFieldDescription());
                        break block13;
                    }
                    if (res instanceof Object[]) {
                        beanDataSource = new JRBeanArrayDataSource((Object[])res, beanDataAdapter.isUseFieldDescription());
                        break block13;
                    }
                    throw new JRException(EXCEPTION_MESSAGE_KEY_INVALID_RETURN_TYPE, new Object[]{clazz.getName()});
                }
                catch (ClassNotFoundException e2) {
                    throw new JRException(e2);
                }
                catch (IllegalAccessException e3) {
                    throw new JRException(e3);
                }
                catch (SecurityException e4) {
                    throw new JRException(e4);
                }
                catch (NoSuchMethodException e5) {
                    throw new JRException(e5);
                }
                catch (IllegalArgumentException e6) {
                    throw new JRException(e6);
                }
                catch (InvocationTargetException e7) {
                    throw new JRException(e7);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldThreadClassLoader);
                }
            }
            parameters.put("REPORT_DATA_SOURCE", beanDataSource);
        }
    }
}

