/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.ds;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Map;
import net.sf.jasperreports.data.AbstractClasspathAwareDataAdapterService;
import net.sf.jasperreports.data.ds.DataSourceDataAdapter;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.JRClassLoader;

public class DataSourceDataAdapterService
extends AbstractClasspathAwareDataAdapterService {
    public static final String EXCEPTION_MESSAGE_KEY_INVALID_OBJECT_RETURNED = "data.ds.invalid.object.returned";

    public DataSourceDataAdapterService(JasperReportsContext jasperReportsContext, DataSourceDataAdapter dsDataAdapter) {
        super(jasperReportsContext, dsDataAdapter);
    }

    public DataSourceDataAdapterService(DataSourceDataAdapter dsDataAdapter) {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), dsDataAdapter);
    }

    public DataSourceDataAdapter getDataSourceDataAdapter() {
        return (DataSourceDataAdapter)this.getDataAdapter();
    }

    @Override
    protected ClassLoader getClassLoader(ClassLoader cloader) {
        URL[] localURLs;
        Object obj = this.getJasperReportsContext().getValue("CURRENT_CLASS_LOADER");
        if (obj != null && obj instanceof ClassLoader) {
            cloader = (ClassLoader)obj;
        }
        if ((localURLs = this.getPathClassloader()) == null || localURLs.length == 0) {
            return cloader;
        }
        return new URLClassLoader(localURLs, cloader);
    }

    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        DataSourceDataAdapter dsDataAdapter = this.getDataSourceDataAdapter();
        if (dsDataAdapter != null) {
            JRDataSource ds;
            block12: {
                ds = null;
                ClassLoader oldThreadClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(this.getClassLoader(oldThreadClassLoader));
                    Class<?> clazz = JRClassLoader.loadClassForRealName(dsDataAdapter.getFactoryClass());
                    Object obj = null;
                    Method method = clazz.getMethod(dsDataAdapter.getMethodToCall(), new Class[0]);
                    if (!Modifier.isStatic(method.getModifiers())) {
                        obj = clazz.newInstance();
                    }
                    if (JRDataSource.class.isAssignableFrom(method.getReturnType())) {
                        ds = (JRDataSource)method.invoke(obj, new Object[0]);
                        break block12;
                    }
                    throw new JRException(EXCEPTION_MESSAGE_KEY_INVALID_OBJECT_RETURNED, new Object[]{dsDataAdapter.getMethodToCall(), dsDataAdapter.getFactoryClass()});
                }
                catch (ClassNotFoundException e2) {
                    throw new JRException(e2);
                }
                catch (NoSuchMethodException e3) {
                    throw new JRException(e3);
                }
                catch (InvocationTargetException e4) {
                    throw new JRException(e4);
                }
                catch (IllegalAccessException e5) {
                    throw new JRException(e5);
                }
                catch (InstantiationException e6) {
                    throw new JRException(e6);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldThreadClassLoader);
                }
            }
            parameters.put("REPORT_DATA_SOURCE", ds);
        }
    }
}

