/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.util.Map;
import net.sf.jasperreports.engine.JRScriptletException;
import net.sf.jasperreports.engine.fill.JRFillField;
import net.sf.jasperreports.engine.fill.JRFillGroup;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.fill.JRFillVariable;

public abstract class JRAbstractScriptlet {
    public static final String EXCEPTION_MESSAGE_KEY_FIELD_NOT_FOUND = "scriptlets.field.not.found";
    public static final String EXCEPTION_MESSAGE_KEY_PARAMETER_NOT_FOUND = "scriptlets.parameter.not.found";
    public static final String EXCEPTION_MESSAGE_KEY_VARIABLE_NOT_FOUND = "scriptlets.variable.not.found";
    public static final String EXCEPTION_MESSAGE_KEY_VARIABLE_VALUE_INCOMPATIBLE = "scriptlets.variable.value.incompatible";
    protected Map<String, JRFillParameter> parametersMap;
    protected Map<String, JRFillField> fieldsMap;
    protected Map<String, JRFillVariable> variablesMap;
    protected JRFillGroup[] groups;

    public void setData(Map<String, JRFillParameter> parsm, Map<String, JRFillField> fldsm, Map<String, JRFillVariable> varsm, JRFillGroup[] grps) {
        this.parametersMap = parsm;
        this.fieldsMap = fldsm;
        this.variablesMap = varsm;
        this.groups = grps;
    }

    public Object getParameterValue(String parameterName) throws JRScriptletException {
        return this.getParameterValue(parameterName, true);
    }

    public Object getParameterValue(String parameterName, boolean mustBeDeclared) throws JRScriptletException {
        JRFillParameter parameter = this.parametersMap.get(parameterName);
        if (parameter == null) {
            if (mustBeDeclared) {
                throw new JRScriptletException(EXCEPTION_MESSAGE_KEY_PARAMETER_NOT_FOUND, new Object[]{parameterName});
            }
            return ((Map)this.parametersMap.get("REPORT_PARAMETERS_MAP").getValue()).get(parameterName);
        }
        return parameter.getValue();
    }

    public Object getFieldValue(String fieldName) throws JRScriptletException {
        JRFillField field = this.fieldsMap.get(fieldName);
        if (field == null) {
            throw new JRScriptletException(EXCEPTION_MESSAGE_KEY_FIELD_NOT_FOUND, new Object[]{fieldName});
        }
        return field.getValue();
    }

    public Object getVariableValue(String variableName) throws JRScriptletException {
        JRFillVariable variable = this.variablesMap.get(variableName);
        if (variable == null) {
            throw new JRScriptletException(EXCEPTION_MESSAGE_KEY_VARIABLE_NOT_FOUND, new Object[]{variableName});
        }
        return variable.getValue();
    }

    public void setVariableValue(String variableName, Object value) throws JRScriptletException {
        JRFillVariable variable = this.variablesMap.get(variableName);
        if (variable == null) {
            throw new JRScriptletException(EXCEPTION_MESSAGE_KEY_VARIABLE_NOT_FOUND, new Object[]{variableName});
        }
        if (value != null && !variable.getValueClass().isInstance(value)) {
            throw new JRScriptletException(EXCEPTION_MESSAGE_KEY_VARIABLE_NOT_FOUND, new Object[]{variableName, variable.getValueClassName()});
        }
        variable.setValue(value);
    }

    public void callBeforeReportInit() throws JRScriptletException {
        this.beforeReportInit();
        this.beforePageInit();
        this.beforeColumnInit();
        if (this.groups != null && this.groups.length > 0) {
            for (int i2 = 0; i2 < this.groups.length; ++i2) {
                this.beforeGroupInit(this.groups[i2].getName());
            }
        }
    }

    public void callAfterReportInit() throws JRScriptletException {
        if (this.groups != null && this.groups.length > 0) {
            for (int i2 = this.groups.length - 1; i2 >= 0; --i2) {
                this.afterGroupInit(this.groups[i2].getName());
            }
        }
        this.afterColumnInit();
        this.afterPageInit();
        this.afterReportInit();
    }

    public void callBeforePageInit() throws JRScriptletException {
        this.beforePageInit();
        this.beforeColumnInit();
    }

    public void callAfterPageInit() throws JRScriptletException {
        this.afterColumnInit();
        this.afterPageInit();
    }

    public void callBeforeColumnInit() throws JRScriptletException {
        this.beforeColumnInit();
    }

    public void callAfterColumnInit() throws JRScriptletException {
        this.afterColumnInit();
    }

    public void callBeforeGroupInit() throws JRScriptletException {
        if (this.groups != null && this.groups.length > 0) {
            JRFillGroup group = null;
            for (int i2 = 0; i2 < this.groups.length; ++i2) {
                group = this.groups[i2];
                if (!group.hasChanged()) continue;
                this.beforeGroupInit(group.getName());
            }
        }
    }

    public void callAfterGroupInit() throws JRScriptletException {
        if (this.groups != null && this.groups.length > 0) {
            JRFillGroup group = null;
            for (int i2 = this.groups.length - 1; i2 >= 0; --i2) {
                group = this.groups[i2];
                if (!group.hasChanged()) continue;
                this.afterGroupInit(group.getName());
            }
        }
    }

    public void callBeforeDetailEval() throws JRScriptletException {
        this.beforeDetailEval();
    }

    public void callAfterDetailEval() throws JRScriptletException {
        this.afterDetailEval();
    }

    public abstract void beforeReportInit() throws JRScriptletException;

    public abstract void afterReportInit() throws JRScriptletException;

    public abstract void beforePageInit() throws JRScriptletException;

    public abstract void afterPageInit() throws JRScriptletException;

    public abstract void beforeColumnInit() throws JRScriptletException;

    public abstract void afterColumnInit() throws JRScriptletException;

    public abstract void beforeGroupInit(String var1) throws JRScriptletException;

    public abstract void afterGroupInit(String var1) throws JRScriptletException;

    public abstract void beforeDetailEval() throws JRScriptletException;

    public abstract void afterDetailEval() throws JRScriptletException;
}

