/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.LinkedHashMap;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.AbstractXlsDataSource;
import net.sf.jasperreports.engine.util.FormatUtils;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class AbstractPoiXlsDataSource
extends AbstractXlsDataSource {
    private Workbook workbook;
    private int sheetIndex = -1;
    private int recordIndex = -1;
    private InputStream inputStream;
    private boolean closeWorkbook;
    private boolean closeInputStream;

    public AbstractPoiXlsDataSource(Workbook workbook) {
        this.workbook = workbook;
        this.closeWorkbook = false;
    }

    public AbstractPoiXlsDataSource(InputStream is) throws JRException, IOException {
        this.inputStream = is;
        this.closeWorkbook = true;
        this.closeInputStream = false;
        this.workbook = this.loadWorkbook(this.inputStream);
    }

    public AbstractPoiXlsDataSource(File file) throws JRException, IOException {
        this(new FileInputStream(file));
        this.closeInputStream = true;
    }

    public AbstractPoiXlsDataSource(JasperReportsContext jasperReportsContext, String location) throws JRException, IOException {
        this(RepositoryUtil.getInstance(jasperReportsContext).getInputStreamFromLocation(location));
        this.closeInputStream = true;
    }

    public AbstractPoiXlsDataSource(String location) throws JRException, IOException {
        this(DefaultJasperReportsContext.getInstance(), location);
    }

    protected abstract Workbook loadWorkbook(InputStream var1) throws IOException;

    @Override
    public boolean next() throws JRException {
        if (this.workbook != null) {
            if (this.sheetIndex < 0) {
                if (this.sheetSelection == null) {
                    this.sheetIndex = 0;
                } else {
                    try {
                        this.sheetIndex = Integer.parseInt(this.sheetSelection);
                        if (this.sheetIndex < 0 || this.sheetIndex > this.workbook.getNumberOfSheets() - 1) {
                            throw new JRRuntimeException("data.xls.sheet.index.out.of.range", new Object[]{this.sheetIndex, this.workbook.getNumberOfSheets() - 1});
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (this.sheetIndex < 0) {
                        this.sheetIndex = this.workbook.getSheetIndex(this.workbook.getSheet(this.sheetSelection));
                        if (this.sheetIndex < 0) {
                            throw new JRRuntimeException("data.xls.sheet.not.found", new Object[]{this.sheetSelection});
                        }
                    }
                }
            }
            ++this.recordIndex;
            if (this.sheetSelection == null && this.recordIndex > this.workbook.getSheetAt(this.sheetIndex).getLastRowNum() && this.sheetIndex + 1 < this.workbook.getNumberOfSheets() && this.workbook.getSheetAt(this.sheetIndex + 1).getLastRowNum() > 0) {
                ++this.sheetIndex;
                this.recordIndex = -1;
                return this.next();
            }
            if ((this.sheetSelection != null || this.sheetIndex == 0) && this.useFirstRowAsHeader && this.recordIndex == 0) {
                this.readHeader();
                ++this.recordIndex;
            }
            if (this.recordIndex <= this.workbook.getSheetAt(this.sheetIndex).getLastRowNum()) {
                return true;
            }
            if (this.closeWorkbook) {
                // empty if block
            }
        }
        return false;
    }

    @Override
    public void moveFirst() {
        this.recordIndex = -1;
        this.sheetIndex = -1;
    }

    @Override
    public Object getFieldValue(JRField jrField) throws JRException {
        String fieldName = jrField.getName();
        Class<?> valueClass = jrField.getValueClass();
        try {
            Integer columnIndex = (Integer)this.columnNames.get(fieldName);
            if (columnIndex == null && fieldName.startsWith("COLUMN_")) {
                columnIndex = Integer.valueOf(fieldName.substring(7));
            }
            if (columnIndex == null) {
                throw new JRException("data.common.unknown.column.name", new Object[]{fieldName});
            }
            Sheet sheet = this.workbook.getSheetAt(this.sheetIndex);
            Cell cell = sheet.getRow(this.recordIndex).getCell(columnIndex);
            if (cell == null) {
                return null;
            }
            if (cell.getCellType() == 2) {
                FormulaEvaluator evaluator = this.workbook.getCreationHelper().createFormulaEvaluator();
                Object value = null;
                switch (evaluator.evaluateFormulaCell(cell)) {
                    case 4: {
                        value = cell.getBooleanCellValue();
                        break;
                    }
                    case 0: {
                        if (Date.class.isAssignableFrom(valueClass)) {
                            value = cell.getDateCellValue();
                            break;
                        }
                        value = cell.getNumericCellValue();
                        break;
                    }
                    case 1: {
                        value = cell.getStringCellValue();
                        if (Date.class.isAssignableFrom(valueClass)) {
                            if (value == null || ((String)value).trim().length() == 0) {
                                value = null;
                                break;
                            }
                            if (this.dateFormat != null) {
                                value = FormatUtils.getFormattedDate(this.dateFormat, (String)value, valueClass);
                                break;
                            }
                            value = this.convertStringValue((String)value, valueClass);
                            break;
                        }
                        if (!Number.class.isAssignableFrom(valueClass)) break;
                        if (value == null || ((String)value).trim().length() == 0) {
                            value = null;
                            break;
                        }
                        if (this.numberFormat != null) {
                            value = FormatUtils.getFormattedNumber(this.numberFormat, (String)value, valueClass);
                            break;
                        }
                        value = this.convertStringValue((String)value, valueClass);
                        break;
                    }
                }
                return value;
            }
            if (valueClass.equals(String.class)) {
                return cell.getStringCellValue();
            }
            if (valueClass.equals(Boolean.class)) {
                if (cell.getCellType() == 4) {
                    return cell.getBooleanCellValue();
                }
                String value = cell.getStringCellValue();
                if (value == null || value.trim().length() == 0) {
                    return null;
                }
                return this.convertStringValue(value, valueClass);
            }
            if (Number.class.isAssignableFrom(valueClass)) {
                if (cell.getCellType() == 0) {
                    return this.convertNumber(cell.getNumericCellValue(), valueClass);
                }
                String value = cell.getStringCellValue();
                if (value == null || value.trim().length() == 0) {
                    return null;
                }
                if (this.numberFormat != null) {
                    return FormatUtils.getFormattedNumber(this.numberFormat, value, valueClass);
                }
                return this.convertStringValue(value, valueClass);
            }
            if (Date.class.isAssignableFrom(valueClass)) {
                if (cell.getCellType() == 0) {
                    return cell.getDateCellValue();
                }
                String value = cell.getStringCellValue();
                if (value == null || value.trim().length() == 0) {
                    return null;
                }
                if (this.dateFormat != null) {
                    return FormatUtils.getFormattedDate(this.dateFormat, value, valueClass);
                }
                return this.convertStringValue(value, valueClass);
            }
            throw new JRException("data.common.cannot.convert.field.type", new Object[]{jrField.getName(), valueClass.getName()});
        }
        catch (Exception e2) {
            throw new JRException("data.xls.field.value.not.retrieved", new Object[]{jrField.getName(), valueClass.getName()}, e2);
        }
    }

    private void readHeader() {
        Sheet sheet = this.workbook.getSheetAt(this.sheetSelection != null ? this.sheetIndex : 0);
        if (this.columnNames.size() == 0) {
            Row row = sheet.getRow(this.recordIndex);
            for (int columnIndex = 0; columnIndex < row.getLastCellNum(); ++columnIndex) {
                Cell cell = row.getCell(columnIndex);
                if (cell != null) {
                    this.columnNames.put(cell.toString(), columnIndex);
                    continue;
                }
                this.columnNames.put("COLUMN_" + columnIndex, columnIndex);
            }
        } else {
            LinkedHashMap<String, Integer> newColumnNames = new LinkedHashMap<String, Integer>();
            for (Integer columnIndex : this.columnNames.values()) {
                Row row = sheet.getRow(this.recordIndex);
                Cell cell = row.getCell(columnIndex);
                if (cell == null) continue;
                newColumnNames.put(cell.toString(), columnIndex);
            }
            this.columnNames = newColumnNames;
        }
    }

    @Override
    public void close() {
        try {
            if (this.closeInputStream) {
                this.inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected void checkReadStarted() {
        if (this.sheetIndex >= 0) {
            throw new JRRuntimeException("data.common.cannot.modify.properties.after.start", (Object[])null);
        }
    }
}

